/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorageChooserEx;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@State(name="NewModuleRootManager", storages={@Storage(value="$MODULE_FILE$"), @Storage(storageClass=ClasspathStorage.class)}, useLoadedStateAsExisting=false)
class ModuleRootManagerComponent
extends ModuleRootManagerImpl
implements PersistentStateComponentWithModificationTracker<ModuleRootManagerImpl.ModuleRootManagerState>,
StateStorageChooserEx {
    ModuleRootManagerComponent(Module module) {
        super(module);
    }

    @NotNull
    public StateStorageChooserEx.Resolution getResolution(@NotNull Storage storage, @NotNull StateStorageOperation operation) {
        boolean isEffectiveStorage;
        if (storage == null) {
            ModuleRootManagerComponent.$$$reportNull$$$0(0);
        }
        if (operation == null) {
            ModuleRootManagerComponent.$$$reportNull$$$0(1);
        }
        boolean isClasspathStorage = storage.storageClass() == ClasspathStorage.class;
        boolean bl = isEffectiveStorage = ClassPathStorageUtil.isClasspathStorage(this.getModule()) == isClasspathStorage;
        if (operation == StateStorageOperation.READ) {
            StateStorageChooserEx.Resolution resolution = isEffectiveStorage ? StateStorageChooserEx.Resolution.DO : StateStorageChooserEx.Resolution.SKIP;
            if (resolution == null) {
                ModuleRootManagerComponent.$$$reportNull$$$0(2);
            }
            return resolution;
        }
        StateStorageChooserEx.Resolution resolution = isEffectiveStorage ? StateStorageChooserEx.Resolution.DO : (isClasspathStorage ? StateStorageChooserEx.Resolution.SKIP : StateStorageChooserEx.Resolution.CLEAR);
        if (resolution == null) {
            ModuleRootManagerComponent.$$$reportNull$$$0(3);
        }
        return resolution;
    }

    public long getStateModificationCount() {
        Module module = this.getModule();
        if (!module.isLoaded() || !(module instanceof ModuleEx)) {
            return this.myModificationTracker.getModificationCount();
        }
        long[] result2 = new long[]{this.myModificationTracker.getModificationCount()};
        result2[0] = result2[0] + ((ModuleEx)module).getOptionsModificationCount();
        SmartList handledLibraryTables = new SmartList();
        this.getRootModel().orderEntries().forEachLibrary(arg_0 -> this.lambda$getStateModificationCount$0((List)handledLibraryTables, result2, arg_0));
        return result2[0] + this.myRootModel.getStateModificationCount();
    }

    @Override
    @TestOnly
    public long getModificationCountForTests() {
        return this.getStateModificationCount();
    }

    private /* synthetic */ boolean lambda$getStateModificationCount$0(List handledLibraryTables, long[] result2, Library library2) {
        LibraryTable table = library2.getTable();
        if (table instanceof LibraryTableBase && !handledLibraryTables.contains(table.getTableLevel())) {
            handledLibraryTables.add(table.getTableLevel());
            long count = ((LibraryTableBase)table).getStateModificationCount();
            if (count > 0L && Registry.is((String)"store.track.module.root.manager.changes", (boolean)false)) {
                LOG.error("modification count changed due to library  " + library2.getName() + " change (" + count + "), module " + this.getModule().getName());
            }
            result2[0] = result2[0] + count;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ModuleRootManagerComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ModuleRootManagerComponent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolution";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResolution";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

