/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.gist;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.NullableFunction;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.GistManagerImpl;
import com.intellij.util.gist.PsiFileGist;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.io.DataExternalizer;
import org.jetbrains.annotations.NotNull;

class PsiFileGistImpl<Data>
implements PsiFileGist<Data> {
    private static final ModificationTracker ourReindexTracker = () -> ((GistManagerImpl)GistManager.getInstance()).getReindexCount();
    private final VirtualFileGist<Data> myPersistence;
    private final VirtualFileGist.GistCalculator<Data> myCalculator;
    private final Key<CachedValue<Data>> myCacheKey;

    PsiFileGistImpl(@NotNull String id2, int version2, @NotNull DataExternalizer<Data> externalizer, @NotNull NullableFunction<PsiFile, Data> calculator) {
        if (id2 == null) {
            PsiFileGistImpl.$$$reportNull$$$0(0);
        }
        if (externalizer == null) {
            PsiFileGistImpl.$$$reportNull$$$0(1);
        }
        if (calculator == null) {
            PsiFileGistImpl.$$$reportNull$$$0(2);
        }
        this.myCalculator = (project, file2) -> {
            PsiFile psiFile = PsiFileGistImpl.getPsiFile(project, file2);
            return psiFile == null ? null : calculator.fun((Object)psiFile);
        };
        this.myPersistence = GistManager.getInstance().newVirtualFileGist(id2, version2, externalizer, this.myCalculator);
        this.myCacheKey = Key.create((String)("PsiFileGist " + id2));
    }

    public Data getFileData(@NotNull PsiFile file2) {
        if (file2 == null) {
            PsiFileGistImpl.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (PsiFileGistImpl.shouldUseMemoryStorage(file2)) {
            return (Data)CachedValuesManager.getManager((Project)file2.getProject()).getCachedValue((UserDataHolder)file2, this.myCacheKey, () -> {
                Object data2 = this.myCalculator.calcData(file2.getProject(), file2.getViewProvider().getVirtualFile());
                return CachedValueProvider.Result.create((Object)data2, (Object[])new Object[]{file2, ourReindexTracker});
            }, false);
        }
        file2.putUserData(this.myCacheKey, null);
        return (Data)this.myPersistence.getFileData(file2.getProject(), file2.getVirtualFile());
    }

    private static boolean shouldUseMemoryStorage(PsiFile file2) {
        if (!(file2.getVirtualFile() instanceof NewVirtualFile)) {
            return true;
        }
        PsiDocumentManager pdm = PsiDocumentManager.getInstance((Project)file2.getProject());
        Document document = pdm.getCachedDocument(file2);
        return document != null && (pdm.isUncommited(document) || FileDocumentManager.getInstance().isDocumentUnsaved(document));
    }

    private static PsiFile getPsiFile(@NotNull Project project, @NotNull VirtualFile file2) {
        PsiFile psi;
        if (project == null) {
            PsiFileGistImpl.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            PsiFileGistImpl.$$$reportNull$$$0(5);
        }
        if (!((psi = PsiManager.getInstance((Project)project).findFile(file2)) instanceof PsiFileImpl) || ((PsiFileImpl)psi).isContentsLoaded()) {
            return psi;
        }
        FileType fileType = file2.getFileType();
        if (!(fileType instanceof LanguageFileType)) {
            return null;
        }
        return FileContentImpl.createFileFromText(project, psi.getViewProvider().getContents(), (LanguageFileType)fileType, file2, file2.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalizer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calculator";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/gist/PsiFileGistImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileData";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getPsiFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

