/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ExceptionFilter;
import com.intellij.execution.filters.ExceptionInfo;
import com.intellij.execution.filters.ExceptionInfoCache;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.JvmExceptionOccurrenceFilter;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class AdvancedExceptionFilter
extends ExceptionFilter {
    AdvancedExceptionFilter(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            AdvancedExceptionFilter.$$$reportNull$$$0(0);
        }
        super(scope);
    }

    @Override
    @NotNull
    List<Filter.ResultItem> getExceptionClassNameItems(ExceptionInfo prevLineException) {
        ExceptionInfoCache.ClassResolveInfo info = this.myCache.resolveClass(prevLineException.getExceptionClassName());
        ArrayList classMap = new ArrayList();
        info.myClasses.forEach((key, value) -> {
            PsiClass psiClass = (PsiClass)ObjectUtils.tryCast((Object)value, PsiClass.class);
            if (psiClass != null && (DumbService.isDumb((Project)psiClass.getProject()) || InheritanceUtil.isInheritor(psiClass, "java.lang.Throwable"))) {
                classMap.add(psiClass);
            }
        });
        ArrayList<Filter.ResultItem> exceptionResults = new ArrayList<Filter.ResultItem>();
        if (!classMap.isEmpty()) {
            JvmExceptionOccurrenceFilter.EP_NAME.forEachExtensionSafe(filter2 -> {
                Filter.ResultItem res = filter2.applyFilter(prevLineException.getExceptionClassName(), classMap, prevLineException.getClassNameOffset());
                ContainerUtil.addIfNotNull((Collection)exceptionResults, (Object)res);
            });
        }
        ArrayList<Filter.ResultItem> arrayList = exceptionResults;
        if (arrayList == null) {
            AdvancedExceptionFilter.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/filters/AdvancedExceptionFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/filters/AdvancedExceptionFilter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionClassNameItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

