/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.DescriptorByIdSignatureFinder$WhenMappings;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0018B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ'\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u0011\u001a\u00020\u0016H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorByIdSignatureFinder;", "", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "mangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$DescriptorMangler;", "lookupMode", "Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorByIdSignatureFinder$LookupMode;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/ir/util/KotlinMangler$DescriptorMangler;Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorByIdSignatureFinder$LookupMode;)V", "findDescriptorByHash", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "candidates", "", "id", "", "(Ljava/util/Collection;Ljava/lang/Long;)Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "findDescriptorBySignature", "signature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "findDescriptorForAccessorSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$AccessorSignature;", "findDescriptorForPublicSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$PublicSignature;", "performLookup", "LookupMode", "ir.serialization.common"})
public final class DescriptorByIdSignatureFinder {
    private final ModuleDescriptor moduleDescriptor;
    private final KotlinMangler.DescriptorMangler mangler;
    private final LookupMode lookupMode;

    @Nullable
    public final DeclarationDescriptor findDescriptorBySignature(@NotNull IdSignature signature2) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkNotNullParameter((Object)signature2, (String)"signature");
        IdSignature idSignature = signature2;
        if (idSignature instanceof IdSignature.AccessorSignature) {
            declarationDescriptor = this.findDescriptorForAccessorSignature((IdSignature.AccessorSignature)signature2);
        } else if (idSignature instanceof IdSignature.PublicSignature) {
            declarationDescriptor = this.findDescriptorForPublicSignature((IdSignature.PublicSignature)signature2);
        } else {
            String string2 = "only PublicSignature or AccessorSignature should reach this point, got " + signature2;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return declarationDescriptor;
    }

    private final DeclarationDescriptor findDescriptorForAccessorSignature(IdSignature.AccessorSignature signature2) {
        Object v4;
        block4: {
            DeclarationDescriptor declarationDescriptor = this.findDescriptorBySignature(signature2.getPropertySignature());
            if (!(declarationDescriptor instanceof PropertyDescriptor)) {
                declarationDescriptor = null;
            }
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)declarationDescriptor;
            if (propertyDescriptor == null) {
                return null;
            }
            PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
            List<PropertyAccessorDescriptor> list2 = propertyDescriptor2.getAccessors();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"propertyDescriptor.accessors");
            Iterable $this$singleOrNull$iv = list2;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                PropertyAccessorDescriptor it = (PropertyAccessorDescriptor)element$iv;
                boolean bl = false;
                PropertyAccessorDescriptor propertyAccessorDescriptor = it;
                Intrinsics.checkNotNullExpressionValue((Object)propertyAccessorDescriptor, (String)"it");
                if (!Intrinsics.areEqual((Object)propertyAccessorDescriptor.getName(), (Object)signature2.getAccessorSignature().getDeclarationFqn().shortName())) continue;
                if (found$iv) {
                    v4 = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v4 = !found$iv ? null : single$iv;
        }
        return v4;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<DeclarationDescriptor> performLookup(IdSignature.PublicSignature signature2) {
        Collection collection;
        List<Name> list2 = signature2.getDeclarationFqn().pathSegments();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"signature.declarationFqn.pathSegments()");
        Name declarationName = (Name)CollectionsKt.first(list2);
        switch (DescriptorByIdSignatureFinder$WhenMappings.$EnumSwitchMapping$0[this.lookupMode.ordinal()]) {
            case 1: {
                collection = ResolutionScope.DefaultImpls.getContributedDescriptors$default(this.moduleDescriptor.getPackage(signature2.packageFqName()).getMemberScope(), null, (Function1)new Function1<Name, Boolean>(declarationName){
                    final /* synthetic */ Name $declarationName;

                    public final boolean invoke(@NotNull Name name) {
                        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                        return Intrinsics.areEqual((Object)name, (Object)this.$declarationName);
                    }
                    {
                        this.$declarationName = name;
                        super(1);
                    }
                }, 1, null);
                break;
            }
            case 2: {
                void $this$flatMapTo$iv$iv;
                MemberScope it;
                Iterable $this$mapTo$iv$iv;
                ModuleDescriptor moduleDescriptor = this.moduleDescriptor;
                if (moduleDescriptor == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl");
                }
                Iterable $this$map$iv = ((ModuleDescriptorImpl)moduleDescriptor).getPackageFragmentProviderForModuleContentWithoutDependencies().getPackageFragments(signature2.packageFqName());
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    MemberScope memberScope2 = it.getMemberScope();
                    collection2.add(memberScope2);
                }
                Iterable $this$flatMap$iv = (List)destination$iv$iv;
                boolean $i$f$flatMap = false;
                $this$mapTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (MemberScope)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = ResolutionScope.DefaultImpls.getContributedDescriptors$default(it, null, (Function1)new Function1<Name, Boolean>(declarationName){
                        final /* synthetic */ Name $declarationName$inlined;
                        {
                            this.$declarationName$inlined = name;
                            super(1);
                        }

                        public final boolean invoke(@NotNull Name name) {
                            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                            return Intrinsics.areEqual((Object)name, (Object)this.$declarationName$inlined);
                        }
                    }, 1, null);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                collection = (List)destination$iv$iv;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private final DeclarationDescriptor findDescriptorForPublicSignature(IdSignature.PublicSignature signature2) {
        DeclarationDescriptor declarationDescriptor;
        Collection collection = this.performLookup(signature2);
        boolean bl = false;
        if (collection.isEmpty()) {
            boolean bl2 = false;
            return null;
        }
        Collection toplevelDescriptors2 = collection;
        List<Name> list2 = signature2.getDeclarationFqn().pathSegments();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"signature.declarationFqn.pathSegments()");
        List<Name> pathSegments = list2;
        Iterable $this$fold$iv = CollectionsKt.drop((Iterable)pathSegments, (int)1);
        boolean $i$f$fold = false;
        Collection accumulator$iv = toplevelDescriptors2;
        for (Object element$iv : $this$fold$iv) {
            void $this$flatMapTo$iv$iv;
            Name name = (Name)element$iv;
            Collection acc = accumulator$iv;
            boolean bl3 = false;
            Iterable $this$flatMap$iv = acc;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List list3;
                DeclarationDescriptor container = (DeclarationDescriptor)element$iv$iv;
                boolean bl4 = false;
                DeclarationDescriptor declarationDescriptor2 = container;
                if (!(declarationDescriptor2 instanceof ClassDescriptor)) {
                    declarationDescriptor2 = null;
                }
                if ((ClassDescriptor)declarationDescriptor2 == null) {
                    list3 = CollectionsKt.emptyList();
                } else {
                    void $this$filterTo$iv$iv;
                    void current;
                    ClassDescriptor classDescriptor2;
                    Collection<ClassConstructorDescriptor> collection2 = classDescriptor2.getConstructors();
                    Intrinsics.checkNotNullExpressionValue(collection2, (String)"classDescriptor.constructors");
                    List nextStepCandidates = CollectionsKt.plus((Collection)CollectionsKt.plus(collection2, (Iterable)ResolutionScope.DefaultImpls.getContributedDescriptors$default(classDescriptor2.getUnsubstitutedMemberScope(), null, (Function1)new Function1<Name, Boolean>((Name)current){
                        final /* synthetic */ Name $current$inlined;
                        {
                            this.$current$inlined = name;
                            super(1);
                        }

                        public final boolean invoke(@NotNull Name name) {
                            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                            return Intrinsics.areEqual((Object)name, (Object)this.$current$inlined);
                        }
                    }, 1, null)), (Iterable)ResolutionScope.DefaultImpls.getContributedDescriptors$default(classDescriptor2.getStaticScope(), null, (Function1)new Function1<Name, Boolean>((Name)current){
                        final /* synthetic */ Name $current$inlined;
                        {
                            this.$current$inlined = name;
                            super(1);
                        }

                        public final boolean invoke(@NotNull Name name) {
                            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                            return Intrinsics.areEqual((Object)name, (Object)this.$current$inlined);
                        }
                    }, 1, null));
                    Iterable $this$filter$iv = nextStepCandidates;
                    boolean $i$f$filter = false;
                    Iterable iterable2 = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                        DeclarationDescriptor it = (DeclarationDescriptor)element$iv$iv2;
                        boolean bl5 = false;
                        DeclarationDescriptor declarationDescriptor3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor3, (String)"it");
                        if (!Intrinsics.areEqual((Object)declarationDescriptor3.getName(), (Object)current)) continue;
                        destination$iv$iv2.add(element$iv$iv2);
                    }
                    list3 = (List)destination$iv$iv2;
                }
                Iterable list$iv$iv = list3;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            accumulator$iv = (List)destination$iv$iv;
        }
        Collection candidates2 = accumulator$iv;
        switch (candidates2.size()) {
            case 1: {
                declarationDescriptor = (DeclarationDescriptor)CollectionsKt.first((Iterable)candidates2);
                break;
            }
            default: {
                declarationDescriptor = this.findDescriptorByHash(candidates2, signature2.getId());
                if (declarationDescriptor != null) break;
                String string2 = "No descriptor found for " + signature2;
                boolean bl6 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
        }
        return declarationDescriptor;
    }

    private final DeclarationDescriptor findDescriptorByHash(Collection<? extends DeclarationDescriptor> candidates2, Long id) {
        Object v1;
        block3: {
            Iterable $this$firstOrNull$iv = candidates2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                DeclarationDescriptor candidate2 = (DeclarationDescriptor)element$iv;
                boolean bl2 = false;
                if (id == null) {
                    bl = candidate2 instanceof ClassDescriptor || candidate2 instanceof TypeAliasDescriptor;
                } else {
                    KotlinMangler.DescriptorMangler descriptorMangler = this.mangler;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    KotlinMangler.DescriptorMangler $this$with = descriptorMangler;
                    boolean bl5 = false;
                    long candidateHash = $this$with.getSignatureMangle(candidate2);
                    bl = candidateHash == id;
                }
                if (!bl) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        return v1;
    }

    public DescriptorByIdSignatureFinder(@NotNull ModuleDescriptor moduleDescriptor, @NotNull KotlinMangler.DescriptorMangler mangler, @NotNull LookupMode lookupMode) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)mangler, (String)"mangler");
        Intrinsics.checkNotNullParameter((Object)((Object)lookupMode), (String)"lookupMode");
        this.moduleDescriptor = moduleDescriptor;
        this.mangler = mangler;
        this.lookupMode = lookupMode;
        boolean bl = this.lookupMode != LookupMode.MODULE_ONLY || this.moduleDescriptor instanceof ModuleDescriptorImpl;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorByIdSignatureFinder$LookupMode;", "", "(Ljava/lang/String;I)V", "MODULE_WITH_DEPENDENCIES", "MODULE_ONLY", "ir.serialization.common"})
    public static final class LookupMode
    extends Enum<LookupMode> {
        public static final /* enum */ LookupMode MODULE_WITH_DEPENDENCIES;
        public static final /* enum */ LookupMode MODULE_ONLY;
        private static final /* synthetic */ LookupMode[] $VALUES;

        static {
            LookupMode[] lookupModeArray = new LookupMode[2];
            LookupMode[] lookupModeArray2 = lookupModeArray;
            lookupModeArray[0] = MODULE_WITH_DEPENDENCIES = new LookupMode();
            lookupModeArray[1] = MODULE_ONLY = new LookupMode();
            $VALUES = lookupModeArray;
        }

        public static LookupMode[] values() {
            return (LookupMode[])$VALUES.clone();
        }

        public static LookupMode valueOf(String string2) {
            return Enum.valueOf(LookupMode.class, string2);
        }
    }
}

