/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSystemCommonBackendContext;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeParameterMarker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0006\u001a.\u0010\b\u001a\u0004\u0018\u00010\u0006*\u00020\u00072\u0006\u0010\t\u001a\u00020\u00062\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rH\u0002\u00a8\u0006\u000e"}, d2={"computeUnderlyingType", "Lorg/jetbrains/kotlin/types/KotlinType;", "inlineClassType", "shouldUseUnderlyingType", "", "computeExpandedTypeForInlineClass", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "Lorg/jetbrains/kotlin/types/TypeSystemCommonBackendContext;", "computeExpandedTypeInner", "kotlinType", "visitedClassifiers", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "Lkotlin/collections/HashSet;", "descriptors.jvm"})
public final class InlineClassMappingKt {
    @Nullable
    public static final KotlinType computeUnderlyingType(@NotNull KotlinType inlineClassType) {
        Intrinsics.checkNotNullParameter((Object)inlineClassType, (String)"inlineClassType");
        if (!InlineClassMappingKt.shouldUseUnderlyingType(inlineClassType)) {
            return null;
        }
        Object object = InlineClassesUtilsKt.unsubstitutedUnderlyingType(inlineClassType);
        if (object == null || (object = ((KotlinType)object).getConstructor()) == null || (object = object.getDeclarationDescriptor()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inlineClassType.unsubsti\u2026Descriptor ?: return null");
        Object descriptor2 = object;
        return descriptor2 instanceof TypeParameterDescriptor ? TypeUtilsKt.getRepresentativeUpperBound((TypeParameterDescriptor)descriptor2) : InlineClassesUtilsKt.substitutedUnderlyingType(inlineClassType);
    }

    @Nullable
    public static final KotlinTypeMarker computeExpandedTypeForInlineClass(@NotNull TypeSystemCommonBackendContext $this$computeExpandedTypeForInlineClass, @NotNull KotlinTypeMarker inlineClassType) {
        Intrinsics.checkNotNullParameter((Object)$this$computeExpandedTypeForInlineClass, (String)"$this$computeExpandedTypeForInlineClass");
        Intrinsics.checkNotNullParameter((Object)inlineClassType, (String)"inlineClassType");
        boolean bl = false;
        return InlineClassMappingKt.computeExpandedTypeInner($this$computeExpandedTypeForInlineClass, inlineClassType, new HashSet<TypeConstructorMarker>());
    }

    private static final KotlinTypeMarker computeExpandedTypeInner(TypeSystemCommonBackendContext $this$computeExpandedTypeInner, KotlinTypeMarker kotlinType, HashSet<TypeConstructorMarker> visitedClassifiers) {
        KotlinTypeMarker kotlinTypeMarker;
        TypeConstructorMarker classifier = $this$computeExpandedTypeInner.typeConstructor(kotlinType);
        if (!visitedClassifiers.add(classifier)) {
            return null;
        }
        TypeParameterMarker typeParameter = $this$computeExpandedTypeInner.getTypeParameterClassifier(classifier);
        if (typeParameter != null) {
            KotlinTypeMarker kotlinTypeMarker2 = InlineClassMappingKt.computeExpandedTypeInner($this$computeExpandedTypeInner, $this$computeExpandedTypeInner.getRepresentativeUpperBound(typeParameter), visitedClassifiers);
            if (kotlinTypeMarker2 != null) {
                KotlinTypeMarker kotlinTypeMarker3 = kotlinTypeMarker2;
                boolean bl = false;
                boolean bl2 = false;
                KotlinTypeMarker expandedUpperBound = kotlinTypeMarker3;
                boolean bl3 = false;
                kotlinTypeMarker = $this$computeExpandedTypeInner.isNullableType(expandedUpperBound) || !$this$computeExpandedTypeInner.isMarkedNullable(kotlinType) ? expandedUpperBound : $this$computeExpandedTypeInner.makeNullable(expandedUpperBound);
            } else {
                kotlinTypeMarker = null;
            }
        } else if ($this$computeExpandedTypeInner.isInlineClass(classifier)) {
            KotlinTypeMarker kotlinTypeMarker4 = $this$computeExpandedTypeInner.getSubstitutedUnderlyingType(kotlinType);
            if (kotlinTypeMarker4 == null) {
                return null;
            }
            KotlinTypeMarker underlyingType = kotlinTypeMarker4;
            KotlinTypeMarker kotlinTypeMarker5 = InlineClassMappingKt.computeExpandedTypeInner($this$computeExpandedTypeInner, underlyingType, visitedClassifiers);
            if (kotlinTypeMarker5 == null) {
                return null;
            }
            KotlinTypeMarker expandedUnderlyingType = kotlinTypeMarker5;
            kotlinTypeMarker = !$this$computeExpandedTypeInner.isNullableType(kotlinType) ? expandedUnderlyingType : ($this$computeExpandedTypeInner.isNullableType(expandedUnderlyingType) ? kotlinType : (expandedUnderlyingType instanceof SimpleTypeMarker && $this$computeExpandedTypeInner.isPrimitiveType((SimpleTypeMarker)expandedUnderlyingType) ? kotlinType : $this$computeExpandedTypeInner.makeNullable(expandedUnderlyingType)));
        } else {
            kotlinTypeMarker = kotlinType;
        }
        return kotlinTypeMarker;
    }

    public static final boolean shouldUseUnderlyingType(@NotNull KotlinType inlineClassType) {
        Intrinsics.checkNotNullParameter((Object)inlineClassType, (String)"inlineClassType");
        KotlinType kotlinType = InlineClassesUtilsKt.unsubstitutedUnderlyingType(inlineClassType);
        if (kotlinType == null) {
            return false;
        }
        KotlinType underlyingType = kotlinType;
        return !inlineClassType.isMarkedNullable() || !TypeUtils.isNullableType(underlyingType) && !KotlinBuiltIns.isPrimitiveType(underlyingType);
    }
}

