/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index;

import java.io.File;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.artifact.Gav;
import org.sonatype.nexus.index.ArtifactContext;
import org.sonatype.nexus.index.ArtifactContextProducer;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.context.IndexingContext;
import org.sonatype.nexus.index.locator.ArtifactLocator;
import org.sonatype.nexus.index.locator.GavHelpedLocator;
import org.sonatype.nexus.index.locator.Locator;
import org.sonatype.nexus.index.locator.MetadataLocator;
import org.sonatype.nexus.index.locator.PomLocator;

@Component(role=ArtifactContextProducer.class)
public class DefaultArtifactContextProducer
implements ArtifactContextProducer {
    private GavHelpedLocator pl = new PomLocator();
    private Locator ml = new MetadataLocator();

    public ArtifactContext getArtifactContext(IndexingContext context, File file) {
        File pom;
        File artifact;
        String repositoryPath = context.getRepository().getAbsolutePath();
        String artifactPath = file.getAbsolutePath();
        if (artifactPath.length() <= repositoryPath.length()) {
            return null;
        }
        if (!this.isIndexable(file)) {
            return null;
        }
        Gav gav = this.getGavFromPath(context, repositoryPath, artifactPath);
        if (gav == null) {
            return null;
        }
        if (file.getName().endsWith(".pom")) {
            ArtifactLocator al = new ArtifactLocator(context);
            artifact = al.locate(file, context.getGavCalculator(), gav);
            if (artifact != null) {
                gav = this.getGavFromPath(context, repositoryPath, artifact.getAbsolutePath());
            }
            pom = file;
        } else {
            artifact = file;
            pom = this.pl.locate(file, context.getGavCalculator(), gav);
        }
        String groupId = gav.getGroupId();
        String artifactId = gav.getArtifactId();
        String version = gav.getBaseVersion();
        String classifier = gav.getClassifier();
        ArtifactInfo ai = new ArtifactInfo(context.getRepositoryId(), groupId, artifactId, version, classifier);
        if (!StringUtils.isEmpty((String)ai.classifier)) {
            ai.packaging = gav.getExtension();
        }
        ai.fname = file.getName();
        ai.fextension = gav.getExtension();
        File metadata = this.ml.locate(pom);
        return new ArtifactContext(pom, artifact, metadata, ai, gav);
    }

    private boolean isIndexable(File file) {
        if (file == null) {
            return false;
        }
        String filename = file.getName();
        return !filename.startsWith("maven-metadata") && !filename.endsWith(".properties") && !filename.endsWith(".xml") && !filename.endsWith(".asc") && !filename.endsWith(".md5") && !filename.endsWith(".sha1");
    }

    private Gav getGavFromPath(IndexingContext context, String repositoryPath, String artifactPath) {
        String path = artifactPath.substring(repositoryPath.length() + 1).replace('\\', '/');
        return context.getGavCalculator().pathToGav(path);
    }
}

