/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.packer;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.codehaus.plexus.component.annotations.Component;
import org.sonatype.nexus.index.packer.IndexChunker;

@Component(role=IndexChunker.class, hint="day")
public class DefaultIndexChunker
implements IndexChunker {
    private static final String INDEX_TIME_DAY_FORMAT = "yyyyMMdd";

    public String getChunkId(Date d) {
        if (d == null) {
            return null;
        }
        DateFormat df = this.getDateFormat();
        return df.format(d);
    }

    public Date getChunkDate(String id) {
        if (id == null) {
            return null;
        }
        try {
            return this.getDateFormat().parse(id);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private DateFormat getDateFormat() {
        SimpleDateFormat df = new SimpleDateFormat(INDEX_TIME_DAY_FORMAT);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df;
    }
}

