/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.light.LightFieldBuilder;
import com.intellij.psi.impl.light.LightPsiClassBuilder;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import de.plushnikov.intellij.plugin.icon.LombokIcons;
import de.plushnikov.intellij.plugin.psi.LombokLightModifierList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LombokLightClassBuilder
extends LightPsiClassBuilder
implements PsiExtensibleClass,
SyntheticElement {
    private boolean myIsEnum;
    private final String myQualifiedName;
    private final Icon myBaseIcon;
    private final LombokLightModifierList myModifierList;
    private final Collection<PsiField> myFields;

    public LombokLightClassBuilder(@NotNull PsiElement context, @NotNull String simpleName, @NotNull String qualifiedName) {
        if (context == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(0);
        }
        if (simpleName == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(1);
        }
        if (qualifiedName == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(2);
        }
        super(context, simpleName);
        this.myFields = new ArrayList<PsiField>();
        this.myIsEnum = false;
        this.myQualifiedName = qualifiedName;
        this.myBaseIcon = LombokIcons.CLASS_ICON;
        this.myModifierList = new LombokLightModifierList(context.getManager(), context.getLanguage(), Collections.emptyList(), new String[0]);
    }

    @NotNull
    public LombokLightModifierList getModifierList() {
        LombokLightModifierList lombokLightModifierList = this.myModifierList;
        if (lombokLightModifierList == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(3);
        }
        return lombokLightModifierList;
    }

    @NotNull
    public PsiField[] getFields() {
        PsiField[] psiFieldArray = this.myFields.toArray(PsiField.EMPTY_ARRAY);
        if (psiFieldArray == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(4);
        }
        return psiFieldArray;
    }

    private void addField(PsiField field) {
        if (field instanceof LightFieldBuilder) {
            ((LightFieldBuilder)field).setContainingClass((PsiClass)this);
        }
        this.myFields.add(field);
    }

    public PsiElement getScope() {
        if (this.getContainingClass() != null) {
            return this.getContainingClass().getScope();
        }
        return super.getScope();
    }

    public PsiElement getParent() {
        return this.getContainingClass();
    }

    @Nullable
    public String getQualifiedName() {
        return this.myQualifiedName;
    }

    public Icon getElementIcon(int flags) {
        return this.myBaseIcon;
    }

    public TextRange getTextRange() {
        TextRange r = super.getTextRange();
        return r == null ? TextRange.EMPTY_RANGE : r;
    }

    public PsiFile getContainingFile() {
        if (null != this.getContainingClass()) {
            return this.getContainingClass().getContainingFile();
        }
        return super.getContainingFile();
    }

    public boolean isEnum() {
        return this.myIsEnum;
    }

    public LombokLightClassBuilder withEnum(boolean isEnum) {
        this.myIsEnum = isEnum;
        return this;
    }

    public LombokLightClassBuilder withImplicitModifier(@PsiModifier.ModifierConstant @NotNull @NonNls String modifier) {
        if (modifier == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(5);
        }
        this.myModifierList.addImplicitModifierProperty(modifier);
        return this;
    }

    public LombokLightClassBuilder withModifier(@PsiModifier.ModifierConstant @NotNull @NonNls String modifier) {
        if (modifier == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(6);
        }
        this.myModifierList.addModifier(modifier);
        return this;
    }

    public LombokLightClassBuilder withContainingClass(@NotNull PsiClass containingClass) {
        if (containingClass == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(7);
        }
        this.setContainingClass(containingClass);
        return this;
    }

    public LombokLightClassBuilder withNavigationElement(PsiElement navigationElement) {
        this.setNavigationElement(navigationElement);
        return this;
    }

    public LombokLightClassBuilder withExtends(PsiClass baseClass) {
        this.getExtendsList().addReference(baseClass);
        return this;
    }

    public LombokLightClassBuilder withExtends(PsiClassType baseClassType) {
        this.getExtendsList().addReference(baseClassType);
        return this;
    }

    public LombokLightClassBuilder withField(@NotNull PsiField psiField) {
        if (psiField == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(8);
        }
        this.addField(psiField);
        return this;
    }

    public LombokLightClassBuilder withFields(@NotNull Collection<PsiField> fields) {
        if (fields == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(9);
        }
        for (PsiField field : fields) {
            this.addField(field);
        }
        return this;
    }

    public LombokLightClassBuilder withMethods(@NotNull Collection<PsiMethod> methods) {
        if (methods == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(10);
        }
        for (PsiMethod method : methods) {
            this.addMethod(method);
        }
        return this;
    }

    public LombokLightClassBuilder withParameterTypes(@Nullable PsiTypeParameterList parameterList) {
        if (parameterList != null) {
            Stream.of(parameterList.getTypeParameters()).forEach(this::withParameterType);
        }
        return this;
    }

    public LombokLightClassBuilder withParameterType(@NotNull PsiTypeParameter psiTypeParameter) {
        if (psiTypeParameter == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(11);
        }
        this.getTypeParameterList().addParameter(psiTypeParameter);
        return this;
    }

    @NotNull
    public List<PsiField> getOwnFields() {
        List<PsiField> list = Arrays.asList(this.getFields());
        if (list == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public List<PsiMethod> getOwnMethods() {
        List<PsiMethod> list = Arrays.asList(this.getMethods());
        if (list == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public List<PsiClass> getOwnInnerClasses() {
        List<PsiClass> list = Arrays.asList(this.getInnerClasses());
        if (list == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(14);
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LombokLightClassBuilder that = (LombokLightClassBuilder)((Object)o);
        return this.myQualifiedName.equals(that.myQualifiedName);
    }

    public int hashCode() {
        return this.myQualifiedName.hashCode();
    }

    public boolean isValid() {
        return super.isValid() && this.areAllFieldsAndMethodsValid();
    }

    private boolean areAllFieldsAndMethodsValid() {
        return Arrays.stream(this.getFields()).allMatch(PsiElement::isValid) && Arrays.stream(this.getMethods()).allMatch(PsiElement::isValid);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simpleName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/psi/LombokLightClassBuilder";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiTypeParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/psi/LombokLightClassBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifierList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnFields";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnMethods";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnInnerClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withImplicitModifier";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withModifier";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "withContainingClass";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "withField";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "withFields";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "withMethods";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "withParameterType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

