/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.classpath;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshotData;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassChanges;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntCollection;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntSet;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntSets;

public class ClasspathEntrySnapshot {
    private final ClasspathEntrySnapshotData data;
    private final ClassSetAnalysis analysis;

    public ClasspathEntrySnapshot(ClasspathEntrySnapshotData data) {
        this.data = data;
        this.analysis = new ClassSetAnalysis(data.getClassAnalysis());
    }

    public DependentsSet getAllClasses() {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, HashCode> cls : this.getHashes().entrySet()) {
            String className = cls.getKey();
            DependentsSet dependents = this.getClassAnalysis().getRelevantDependents(className, (IntSet)IntSets.EMPTY_SET);
            if (dependents.isDependencyToAll()) {
                return dependents;
            }
            result.add(className);
        }
        return DependentsSet.dependentClasses(Collections.emptySet(), result);
    }

    public IntSet getAllConstants(DependentsSet dependents) {
        IntOpenHashSet result = new IntOpenHashSet();
        for (String cn : dependents.getAllDependentClasses()) {
            result.addAll((IntCollection)this.data.getClassAnalysis().getConstants(cn));
        }
        return result;
    }

    public IntSet getRelevantConstants(ClasspathEntrySnapshot other, Set<String> affectedClasses) {
        IntOpenHashSet result = new IntOpenHashSet();
        for (String affectedClass : affectedClasses) {
            IntOpenHashSet difference = new IntOpenHashSet((IntCollection)other.getData().getClassAnalysis().getConstants(affectedClass));
            difference.removeAll((IntCollection)this.data.getClassAnalysis().getConstants(affectedClass));
            result.addAll((IntCollection)difference);
        }
        return result;
    }

    public ClassChanges getChangedClassesSince(ClasspathEntrySnapshot other) {
        Set<String> modifiedClasses = this.modifiedSince(other);
        Set<String> addedClasses = this.addedSince(other);
        return new ClassChanges(modifiedClasses, addedClasses);
    }

    private Set<String> modifiedSince(ClasspathEntrySnapshot other) {
        HashSet<String> modified = new HashSet<String>();
        for (Map.Entry<String, HashCode> otherClass : other.getHashes().entrySet()) {
            String otherClassName = otherClass.getKey();
            HashCode otherClassBytes = otherClass.getValue();
            HashCode thisClsBytes = this.getHashes().get(otherClassName);
            if (thisClsBytes != null && thisClsBytes.equals(otherClassBytes)) continue;
            modified.add(otherClassName);
        }
        return modified;
    }

    private Set<String> addedSince(ClasspathEntrySnapshot other) {
        HashSet<String> addedClasses = new HashSet<String>(this.getClasses());
        addedClasses.removeAll(other.getClasses());
        return addedClasses;
    }

    public HashCode getHash() {
        return this.data.getHash();
    }

    public Map<String, HashCode> getHashes() {
        return this.data.getHashes();
    }

    public ClassSetAnalysis getClassAnalysis() {
        return this.analysis;
    }

    public Set<String> getClasses() {
        return this.data.getHashes().keySet();
    }

    public ClasspathEntrySnapshotData getData() {
        return this.data;
    }
}

