/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.io.File;
import java.util.Collection;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntSet;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntSets;

class SourceFileChangeProcessor {
    private final PreviousCompilation previousCompilation;

    public SourceFileChangeProcessor(PreviousCompilation previousCompilation) {
        this.previousCompilation = previousCompilation;
    }

    public void processChange(File inputFile, Collection<String> classNames, RecompilationSpec spec) {
        spec.getClassesToCompile().addAll(classNames);
        for (String className : classNames) {
            DependentsSet actualDependents = this.previousCompilation.getDependents(className, (IntSet)IntSets.EMPTY_SET);
            if (actualDependents.isDependencyToAll()) {
                spec.setFullRebuildCause(actualDependents.getDescription(), inputFile);
                return;
            }
            spec.getClassesToCompile().addAll(actualDependents.getAllDependentClasses());
            spec.getResourcesToGenerate().addAll(actualDependents.getDependentResources());
        }
    }
}

