/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.processing;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.gradle.api.internal.tasks.compile.incremental.processing.IncrementalAnnotationProcessorType;
import org.gradle.api.internal.tasks.compile.processing.AnnotationProcessorDeclaration;
import org.gradle.api.internal.tasks.compile.processing.AnnotationProcessorDeclarationSerializer;
import org.gradle.cache.internal.FileContentCache;
import org.gradle.cache.internal.FileContentCacheFactory;
import org.gradle.internal.FileUtils;
import org.gradle.internal.impldep.com.google.common.base.Charsets;
import org.gradle.internal.impldep.com.google.common.base.Enums;
import org.gradle.internal.impldep.com.google.common.base.Splitter;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.io.CharStreams;
import org.gradle.internal.impldep.com.google.common.io.Files;
import org.gradle.internal.impldep.com.google.common.io.LineProcessor;
import org.gradle.internal.impldep.org.apache.tools.zip.ZipEntry;
import org.gradle.internal.impldep.org.apache.tools.zip.ZipFile;
import org.gradle.internal.serialize.ListSerializer;
import org.slf4j.Logger;

public class AnnotationProcessorDetector {
    public static final String PROCESSOR_DECLARATION = "META-INF/services/javax.annotation.processing.Processor";
    public static final String INCREMENTAL_PROCESSOR_DECLARATION = "META-INF/gradle/incremental.annotation.processors";
    private final FileContentCache<List<AnnotationProcessorDeclaration>> cache;
    private final Logger logger;
    private final boolean logStackTraces;

    public AnnotationProcessorDetector(FileContentCacheFactory cacheFactory, Logger logger, boolean logStackTraces) {
        this.cache = cacheFactory.newCache("annotation-processors", 20000, new ProcessorServiceLocator(), new ListSerializer<AnnotationProcessorDeclaration>(AnnotationProcessorDeclarationSerializer.INSTANCE));
        this.logger = logger;
        this.logStackTraces = logStackTraces;
    }

    public Map<String, AnnotationProcessorDeclaration> detectProcessors(Iterable<File> processorPath) {
        LinkedHashMap processors = Maps.newLinkedHashMap();
        for (File jarOrClassesDir : processorPath) {
            for (AnnotationProcessorDeclaration declaration : this.cache.get(jarOrClassesDir)) {
                String className = declaration.getClassName();
                if (processors.containsKey(className)) continue;
                processors.put(className, declaration);
            }
        }
        return processors;
    }

    private class ProcessorServiceLocator
    implements FileContentCacheFactory.Calculator<List<AnnotationProcessorDeclaration>> {
        private ProcessorServiceLocator() {
        }

        @Override
        public List<AnnotationProcessorDeclaration> calculate(File file, boolean isRegularFile) {
            if (!isRegularFile) {
                return this.detectProcessorsInClassesDir(file);
            }
            if (FileUtils.hasExtensionIgnoresCase(file.getName(), ".jar")) {
                return this.detectProcessorsInJar(file);
            }
            return Collections.emptyList();
        }

        private List<AnnotationProcessorDeclaration> detectProcessorsInClassesDir(File classesDir) {
            try {
                List<String> processorClassNames = this.getProcessorClassNames(classesDir);
                try {
                    Map<String, IncrementalAnnotationProcessorType> processorTypes = this.getProcessorTypes(classesDir);
                    return this.toProcessorDeclarations(processorClassNames, processorTypes);
                }
                catch (Exception e) {
                    AnnotationProcessorDetector.this.logger.warn("Could not read annotation processor declarations from " + classesDir + ". Gradle will assume that all processors in this directory are non-incremental.", (Throwable)(AnnotationProcessorDetector.this.logStackTraces ? e : null));
                    return this.toProcessorDeclarations(processorClassNames, Collections.emptyMap());
                }
            }
            catch (Exception e) {
                AnnotationProcessorDetector.this.logger.warn("Could not read annotation processor declarations from " + classesDir + ". Gradle will assume that this directory contains no annotation processors.", (Throwable)(AnnotationProcessorDetector.this.logStackTraces ? e : null));
                return Collections.emptyList();
            }
        }

        private List<String> getProcessorClassNames(File classesDir) throws IOException {
            File processorDeclaration = new File(classesDir, AnnotationProcessorDetector.PROCESSOR_DECLARATION);
            if (!processorDeclaration.isFile()) {
                return Collections.emptyList();
            }
            return this.readLines(processorDeclaration);
        }

        private Map<String, IncrementalAnnotationProcessorType> getProcessorTypes(File classesDir) throws IOException {
            File incrementalProcessorDeclaration = new File(classesDir, AnnotationProcessorDetector.INCREMENTAL_PROCESSOR_DECLARATION);
            if (!incrementalProcessorDeclaration.isFile()) {
                return Collections.emptyMap();
            }
            List<String> lines = this.readLines(incrementalProcessorDeclaration);
            return this.parseIncrementalProcessors(lines);
        }

        private List<String> readLines(File file) throws IOException {
            return (List)Files.asCharSource((File)file, (Charset)Charsets.UTF_8).readLines((LineProcessor)new MetadataLineProcessor());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        private List<AnnotationProcessorDeclaration> detectProcessorsInJar(File jar) {
            try (ZipFile zipFile = new ZipFile(jar);){
                List<String> processorClassNames = this.getProcessorClassNames(zipFile);
                try {
                    Map<String, IncrementalAnnotationProcessorType> processorTypes = this.getProcessorTypes(zipFile);
                    List<AnnotationProcessorDeclaration> list = this.toProcessorDeclarations(processorClassNames, processorTypes);
                    return list;
                }
                catch (Exception e) {
                    AnnotationProcessorDetector.this.logger.warn("Could not read annotation processor declarations from " + jar + ". Gradle will assume that all processors in this jar are non-incremental.", (Throwable)(AnnotationProcessorDetector.this.logStackTraces ? e : null));
                    List<AnnotationProcessorDeclaration> list2 = this.toProcessorDeclarations(processorClassNames, Collections.emptyMap());
                    zipFile.close();
                    return list2;
                }
            }
            catch (Exception e2) {
                AnnotationProcessorDetector.this.logger.warn("Could not read annotation processor declarations from " + jar + ". Gradle will assume that this jar contains no annotation processors.", (Throwable)(AnnotationProcessorDetector.this.logStackTraces ? e2 : null));
                return Collections.emptyList();
            }
        }

        private List<String> getProcessorClassNames(ZipFile zipFile) throws IOException {
            ZipEntry processorDeclaration = zipFile.getEntry(AnnotationProcessorDetector.PROCESSOR_DECLARATION);
            if (processorDeclaration == null) {
                return Collections.emptyList();
            }
            return this.readLines(zipFile, processorDeclaration);
        }

        private Map<String, IncrementalAnnotationProcessorType> getProcessorTypes(ZipFile zipFile) throws IOException {
            ZipEntry incrementalProcessorDeclaration = zipFile.getEntry(AnnotationProcessorDetector.INCREMENTAL_PROCESSOR_DECLARATION);
            if (incrementalProcessorDeclaration == null) {
                return Collections.emptyMap();
            }
            List<String> lines = this.readLines(zipFile, incrementalProcessorDeclaration);
            return this.parseIncrementalProcessors(lines);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<String> readLines(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
            try (InputStream in = zipFile.getInputStream(zipEntry);){
                List list = (List)CharStreams.readLines((Readable)new InputStreamReader(in, Charsets.UTF_8), (LineProcessor)new MetadataLineProcessor());
                return list;
            }
        }

        private Map<String, IncrementalAnnotationProcessorType> parseIncrementalProcessors(List<String> lines) {
            HashMap types = Maps.newHashMap();
            for (String line : lines) {
                List parts = Splitter.on((char)',').splitToList((CharSequence)line);
                IncrementalAnnotationProcessorType type = this.parseProcessorType(parts);
                types.put((String)parts.get(0), type);
            }
            return types;
        }

        private IncrementalAnnotationProcessorType parseProcessorType(List<String> parts) {
            return (IncrementalAnnotationProcessorType)((Object)Enums.getIfPresent(IncrementalAnnotationProcessorType.class, (String)parts.get(1).toUpperCase(Locale.ROOT)).or((Object)IncrementalAnnotationProcessorType.UNKNOWN));
        }

        private List<AnnotationProcessorDeclaration> toProcessorDeclarations(List<String> processorNames, Map<String, IncrementalAnnotationProcessorType> processorTypes) {
            if (processorNames.isEmpty()) {
                return Collections.emptyList();
            }
            ImmutableList.Builder processors = ImmutableList.builder();
            for (String name : processorNames) {
                IncrementalAnnotationProcessorType type = processorTypes.get(name);
                type = type != null ? type : IncrementalAnnotationProcessorType.UNKNOWN;
                processors.add((Object)new AnnotationProcessorDeclaration(name, type));
            }
            return processors.build();
        }

        private class MetadataLineProcessor
        implements LineProcessor<List<String>> {
            private List<String> lines = Lists.newArrayList();

            private MetadataLineProcessor() {
            }

            public boolean processLine(String line) {
                int commentStart = line.indexOf(35);
                if (commentStart >= 0) {
                    line = line.substring(0, commentStart);
                }
                if (!(line = line.trim()).isEmpty()) {
                    this.lines.add(line);
                }
                return true;
            }

            public List<String> getResult() {
                return this.lines;
            }
        }
    }
}

