/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.tasks.diagnostics.AbstractReportTask;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.internal.graph.GraphRenderer;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;

public class ProjectReportTask
extends AbstractReportTask {
    private final TextReportRenderer renderer = new TextReportRenderer();

    @Override
    protected TextReportRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    protected void generate(Project project) {
        BuildClientMetaData metaData = this.getClientMetaData();
        StyledTextOutput textOutput = this.getRenderer().getTextOutput();
        this.render(project, new GraphRenderer(textOutput), true, textOutput);
        if (project.getChildProjects().isEmpty()) {
            textOutput.withStyle(StyledTextOutput.Style.Info).text("No sub-projects");
            textOutput.println();
        }
        textOutput.println();
        textOutput.text("To see a list of the tasks of a project, run ");
        metaData.describeCommand(textOutput.withStyle(StyledTextOutput.Style.UserInput), "<project-path>:tasks");
        textOutput.println();
        textOutput.text("For example, try running ");
        Project exampleProject = project.getChildProjects().isEmpty() ? project : this.getChildren(project).get(0);
        metaData.describeCommand(textOutput.withStyle(StyledTextOutput.Style.UserInput), exampleProject.absoluteProjectPath("tasks"));
        textOutput.println();
        if (project != project.getRootProject()) {
            textOutput.println();
            textOutput.text("To see a list of all the projects in this build, run ");
            metaData.describeCommand(textOutput.withStyle(StyledTextOutput.Style.UserInput), project.getRootProject().absoluteProjectPath("projects"));
            textOutput.println();
        }
    }

    private void render(Project project, GraphRenderer renderer, boolean lastChild, StyledTextOutput textOutput) {
        renderer.visit(styledTextOutput -> {
            styledTextOutput.text(StringUtils.capitalize((String)project.toString()));
            if (GUtil.isTrue(project.getDescription())) {
                textOutput.withStyle(StyledTextOutput.Style.Description).format(" - %s", project.getDescription());
            }
        }, lastChild);
        renderer.startChildren();
        List<Project> children = this.getChildren(project);
        for (Project child : children) {
            this.render(child, renderer, child == children.get(children.size() - 1), textOutput);
        }
        renderer.completeChildren();
    }

    private List<Project> getChildren(Project project) {
        return CollectionUtils.sort(project.getChildProjects().values());
    }
}

