/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.Optional;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.LanguageLibraryProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateFactory;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.util.GUtil;

public abstract class JvmGradlePluginProjectInitDescriptor
extends LanguageLibraryProjectInitDescriptor {
    private final DocumentationRegistry documentationRegistry;

    public JvmGradlePluginProjectInitDescriptor(DocumentationRegistry documentationRegistry) {
        this.documentationRegistry = documentationRegistry;
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentType.GRADLE_PLUGIN;
    }

    @Override
    public boolean supportsPackage() {
        return true;
    }

    @Override
    public void generateProjectBuildScript(String projectName, InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
        buildScriptBuilder.repositories().jcenter("Use JCenter for resolving dependencies.");
        String pluginId = settings.getPackageName() + ".greeting";
        String pluginClassName = StringUtils.capitalize((String)GUtil.toCamelCase(settings.getProjectName())) + "Plugin";
        buildScriptBuilder.fileComment("This generated file contains a sample Gradle plugin project to get you started.").fileComment("For more details take a look at the Writing Custom Plugins chapter in the Gradle").fileComment("User Manual available at " + this.documentationRegistry.getDocumentationFor("custom_plugins"));
        buildScriptBuilder.plugin("Apply the Java Gradle plugin development plugin to add support for developing Gradle plugins", "java-gradle-plugin");
        buildScriptBuilder.block(null, "gradlePlugin", b -> b.containerElement("Define the plugin", "plugins", "greeting", null, g -> {
            g.propertyAssignment(null, "id", pluginId, true);
            g.propertyAssignment(null, "implementationClass", this.withPackage(settings, pluginClassName), true);
        }));
        BuildScriptBuilder.Expression functionalTestSourceSet = buildScriptBuilder.createContainerElement("Add a source set for the functional test suite", "sourceSets", "functionalTest", "functionalTestSourceSet");
        buildScriptBuilder.methodInvocation(null, "gradlePlugin.testSourceSets", functionalTestSourceSet);
        BuildScriptBuilder.Expression functionalTestConfiguration = buildScriptBuilder.containerElementExpression("configurations", "functionalTestImplementation");
        BuildScriptBuilder.Expression testConfiguration = buildScriptBuilder.containerElementExpression("configurations", "testImplementation");
        buildScriptBuilder.methodInvocation(null, functionalTestConfiguration, "extendsFrom", testConfiguration);
        BuildScriptBuilder.Expression functionalTest = buildScriptBuilder.taskRegistration("Add a task to run the functional tests", "functionalTest", "Test", b -> {
            b.propertyAssignment(null, "testClassesDirs", buildScriptBuilder.propertyExpression(functionalTestSourceSet, "output.classesDirs"), true);
            b.propertyAssignment(null, "classpath", buildScriptBuilder.propertyExpression(functionalTestSourceSet, "runtimeClasspath"), true);
        });
        buildScriptBuilder.taskMethodInvocation("Run the functional tests as part of `check`", "check", "Task", "dependsOn", functionalTest);
    }

    @Override
    public void generateConventionPluginBuildScript(String conventionPluginName, InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
    }

    @Override
    public void generateSources(InitSettings settings, TemplateFactory templateFactory) {
        String pluginId = settings.getPackageName() + ".greeting";
        String pluginClassName = StringUtils.capitalize((String)GUtil.toCamelCase(settings.getProjectName())) + "Plugin";
        String testClassName = pluginClassName + "Test";
        String functionalTestClassName = pluginClassName + "FunctionalTest";
        TemplateOperation sourceTemplate = this.sourceTemplate(settings, templateFactory, pluginId, pluginClassName);
        TemplateOperation testTemplate = this.testTemplate(settings, templateFactory, pluginId, testClassName);
        TemplateOperation functionalTestTemplate = this.functionalTestTemplate(settings, templateFactory, pluginId, functionalTestClassName);
        templateFactory.whenNoSourcesAvailable(sourceTemplate, testTemplate, functionalTestTemplate).generate();
    }

    @Override
    public Optional<String> getFurtherReading(InitSettings settings) {
        return Optional.of(this.documentationRegistry.getDocumentationFor("custom_plugins"));
    }

    protected abstract TemplateOperation sourceTemplate(InitSettings var1, TemplateFactory var2, String var3, String var4);

    protected abstract TemplateOperation testTemplate(InitSettings var1, TemplateFactory var2, String var3, String var4);

    protected abstract TemplateOperation functionalTestTemplate(InitSettings var1, TemplateFactory var2, String var3, String var4);
}

