/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.caching;

import java.util.Optional;
import org.gradle.caching.BuildCacheKey;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingDisabledReasonCategory;
import org.gradle.internal.execution.caching.CachingInputs;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

public interface CachingState {
    public static final CachingState NOT_DETERMINED = CachingState.disabledWithoutInputs(new CachingDisabledReason(CachingDisabledReasonCategory.UNKNOWN, "Cacheability was not determined"));

    public Optional<BuildCacheKey> getKey();

    public ImmutableList<CachingDisabledReason> getDisabledReasons();

    public Optional<CachingInputs> getInputs();

    public static CachingState disabledWithoutInputs(CachingDisabledReason reason) {
        final ImmutableList reasons = ImmutableList.of((Object)reason);
        return new CachingState(){

            @Override
            public Optional<BuildCacheKey> getKey() {
                return Optional.empty();
            }

            @Override
            public ImmutableList<CachingDisabledReason> getDisabledReasons() {
                return reasons;
            }

            @Override
            public Optional<CachingInputs> getInputs() {
                return Optional.empty();
            }
        };
    }
}

