/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.installation;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GradleInstallation {
    public static final FileFilter DIRECTORY_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };
    private final File dir;
    private final List<File> libDirs;

    public GradleInstallation(File dir) {
        this.dir = dir;
        this.libDirs = Collections.unmodifiableList(GradleInstallation.findLibDirs(dir));
    }

    public File getGradleHome() {
        return this.dir;
    }

    public List<File> getLibDirs() {
        return this.libDirs;
    }

    public File getSrcDir() {
        return this.dir.toPath().resolve("src").toFile();
    }

    private static List<File> findLibDirs(File dir) {
        ArrayList<File> libDirAndSubdirs = new ArrayList<File>();
        GradleInstallation.collectWithSubdirectories(new File(dir, "lib"), libDirAndSubdirs);
        return libDirAndSubdirs;
    }

    private static void collectWithSubdirectories(File root, Collection<File> collection2) {
        collection2.add(root);
        File[] subDirs = root.listFiles(DIRECTORY_FILTER);
        if (subDirs != null) {
            for (File subdirectory : subDirs) {
                GradleInstallation.collectWithSubdirectories(subdirectory, collection2);
            }
        }
    }
}

