/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.gradle.internal.file.FileType;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemNode;
import org.gradle.internal.snapshot.MetadataSnapshot;
import org.gradle.internal.snapshot.PartialDirectorySnapshot;
import org.gradle.internal.snapshot.PathUtil;
import org.gradle.internal.snapshot.ReadOnlyFileSystemNode;
import org.gradle.internal.snapshot.SearchUtil;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.snapshot.UnknownSnapshot;
import org.gradle.internal.snapshot.VfsRelativePath;

public class SnapshotUtil {
    private static final int MINIMUM_CHILD_COUNT_FOR_BINARY_SEARCH = 10;

    public static Optional<MetadataSnapshot> getMetadataFromChildren(List<? extends FileSystemNode> children, VfsRelativePath relativePath, CaseSensitivity caseSensitivity, Supplier<Optional<MetadataSnapshot>> noChildFoundResult) {
        int numberOfChildren = children.size();
        switch (numberOfChildren) {
            case 0: {
                return noChildFoundResult.get();
            }
            case 1: {
                FileSystemNode onlyChild = children.get(0);
                return relativePath.hasPrefix(onlyChild.getPathToParent(), caseSensitivity) ? SnapshotUtil.getSnapshotFromChild(onlyChild, relativePath, caseSensitivity) : noChildFoundResult.get();
            }
            case 2: {
                FileSystemNode firstChild = children.get(0);
                FileSystemNode secondChild = children.get(1);
                if (relativePath.hasPrefix(firstChild.getPathToParent(), caseSensitivity)) {
                    return SnapshotUtil.getSnapshotFromChild(firstChild, relativePath, caseSensitivity);
                }
                if (relativePath.hasPrefix(secondChild.getPathToParent(), caseSensitivity)) {
                    return SnapshotUtil.getSnapshotFromChild(secondChild, relativePath, caseSensitivity);
                }
                return noChildFoundResult.get();
            }
        }
        if (numberOfChildren < 10) {
            for (FileSystemNode fileSystemNode : children) {
                if (!relativePath.hasPrefix(fileSystemNode.getPathToParent(), caseSensitivity)) continue;
                return SnapshotUtil.getSnapshotFromChild(fileSystemNode, relativePath, caseSensitivity);
            }
            return noChildFoundResult.get();
        }
        int foundChild = SearchUtil.binarySearch(children, child -> relativePath.compareToFirstSegment(child.getPathToParent(), caseSensitivity));
        return foundChild >= 0 && relativePath.hasPrefix(children.get(foundChild).getPathToParent(), caseSensitivity) ? SnapshotUtil.getSnapshotFromChild(children.get(foundChild), relativePath, caseSensitivity) : noChildFoundResult.get();
    }

    public static Optional<MetadataSnapshot> getSnapshotFromChild(FileSystemNode child, VfsRelativePath relativePath, CaseSensitivity caseSensitivity) {
        if (relativePath.length() == child.getPathToParent().length()) {
            return child.getSnapshot();
        }
        return child.getSnapshot(relativePath.fromChild(child.getPathToParent()), caseSensitivity);
    }

    public static ReadOnlyFileSystemNode getChild(List<? extends FileSystemNode> children, VfsRelativePath relativePath, CaseSensitivity caseSensitivity) {
        int numberOfChildren = children.size();
        switch (numberOfChildren) {
            case 0: {
                return ReadOnlyFileSystemNode.EMPTY;
            }
            case 1: {
                FileSystemNode onlyChild = children.get(0);
                return SnapshotUtil.getNodeFromChild(onlyChild, relativePath, caseSensitivity).orElse(ReadOnlyFileSystemNode.EMPTY);
            }
            case 2: {
                FileSystemNode firstChild = children.get(0);
                FileSystemNode secondChild = children.get(1);
                return SnapshotUtil.getNodeFromChild(firstChild, relativePath, caseSensitivity).orElseGet(() -> SnapshotUtil.getNodeFromChild(secondChild, relativePath, caseSensitivity).orElse(ReadOnlyFileSystemNode.EMPTY));
            }
        }
        if (numberOfChildren < 10) {
            for (FileSystemNode fileSystemNode : children) {
                Optional<ReadOnlyFileSystemNode> node = SnapshotUtil.getNodeFromChild(fileSystemNode, relativePath, caseSensitivity);
                if (!node.isPresent()) continue;
                return node.get();
            }
            return ReadOnlyFileSystemNode.EMPTY;
        }
        int foundChild = SearchUtil.binarySearch(children, child -> relativePath.compareToFirstSegment(child.getPathToParent(), caseSensitivity));
        if (foundChild >= 0) {
            return SnapshotUtil.getNodeFromChild(children.get(foundChild), relativePath, caseSensitivity).orElse(ReadOnlyFileSystemNode.EMPTY);
        }
        return ReadOnlyFileSystemNode.EMPTY;
    }

    public static Optional<ReadOnlyFileSystemNode> getNodeFromChild(final FileSystemNode child, final VfsRelativePath relativePath, final CaseSensitivity caseSensitivity) {
        return SnapshotUtil.handlePathRelationship(child.getPathToParent(), relativePath, caseSensitivity, new PathRelationshipHandler<Optional<ReadOnlyFileSystemNode>>(){

            @Override
            public Optional<ReadOnlyFileSystemNode> handleDescendant() {
                return Optional.of(child.getNode(relativePath.fromChild(child.getPathToParent()), caseSensitivity));
            }

            @Override
            public Optional<ReadOnlyFileSystemNode> handleAncestor() {
                return Optional.of(child.withPathToParent(child.getPathToParent().substring(relativePath.length() + 1)));
            }

            @Override
            public Optional<ReadOnlyFileSystemNode> handleSame() {
                return Optional.of(child);
            }

            @Override
            public Optional<ReadOnlyFileSystemNode> handleDifferent(int commonPrefixLength) {
                return Optional.empty();
            }
        });
    }

    public static FileSystemNode storeSingleChild(final FileSystemNode child, final VfsRelativePath relativePath, final CaseSensitivity caseSensitivity, final MetadataSnapshot snapshot, final SnapshotHierarchy.NodeDiffListener diffListener) {
        return SnapshotUtil.handlePathRelationship(child.getPathToParent(), relativePath, caseSensitivity, new PathRelationshipHandler<FileSystemNode>(){

            @Override
            public FileSystemNode handleDescendant() {
                return child.store(relativePath.fromChild(child.getPathToParent()), caseSensitivity, snapshot, diffListener);
            }

            @Override
            public FileSystemNode handleAncestor() {
                return this.replacedNode();
            }

            @Override
            public FileSystemNode handleSame() {
                return snapshot instanceof CompleteFileSystemLocationSnapshot ? this.replacedNode() : child.getSnapshot().filter(oldSnapshot -> oldSnapshot instanceof CompleteFileSystemLocationSnapshot).map(it -> child).orElseGet(this::replacedNode);
            }

            private FileSystemNode replacedNode() {
                diffListener.nodeRemoved(child);
                FileSystemNode newNode = snapshot.asFileSystemNode(relativePath.getAsString());
                diffListener.nodeAdded(newNode);
                return newNode;
            }

            @Override
            public FileSystemNode handleDifferent(int commonPrefixLength) {
                String prefix = child.getPathToParent();
                String commonPrefix = prefix.substring(0, commonPrefixLength);
                boolean emptyCommonPrefix = commonPrefixLength == 0;
                FileSystemNode newChild = emptyCommonPrefix ? child : child.withPathToParent(prefix.substring(commonPrefixLength + 1));
                FileSystemNode sibling = snapshot.asFileSystemNode(emptyCommonPrefix ? relativePath.getAsString() : relativePath.suffixStartingFrom(commonPrefixLength + 1).getAsString());
                ImmutableList newChildren = PathUtil.getPathComparator(caseSensitivity).compare(newChild.getPathToParent(), sibling.getPathToParent()) < 0 ? ImmutableList.of((Object)newChild, (Object)sibling) : ImmutableList.of((Object)sibling, (Object)newChild);
                diffListener.nodeAdded(sibling);
                boolean isDirectory = child.getSnapshot().filter(x$0 -> SnapshotUtil.isRegularFileOrDirectory(x$0)).isPresent() || SnapshotUtil.isRegularFileOrDirectory(snapshot);
                return isDirectory ? new PartialDirectorySnapshot(commonPrefix, (List<? extends FileSystemNode>)newChildren) : new UnknownSnapshot(commonPrefix, (List<? extends FileSystemNode>)newChildren);
            }
        });
    }

    private static boolean isRegularFileOrDirectory(MetadataSnapshot metadataSnapshot) {
        return metadataSnapshot.getType() != FileType.Missing;
    }

    public static Optional<FileSystemNode> invalidateSingleChild(final FileSystemNode child, final VfsRelativePath relativePath, final CaseSensitivity caseSensitivity, final SnapshotHierarchy.NodeDiffListener diffListener) {
        return SnapshotUtil.handlePathRelationship(child.getPathToParent(), relativePath, caseSensitivity, new PathRelationshipHandler<Optional<FileSystemNode>>(){

            @Override
            public Optional<FileSystemNode> handleDescendant() {
                return child.invalidate(relativePath.fromChild(child.getPathToParent()), caseSensitivity, diffListener);
            }

            @Override
            public Optional<FileSystemNode> handleAncestor() {
                diffListener.nodeRemoved(child);
                return Optional.empty();
            }

            @Override
            public Optional<FileSystemNode> handleSame() {
                diffListener.nodeRemoved(child);
                return Optional.empty();
            }

            @Override
            public Optional<FileSystemNode> handleDifferent(int commonPrefixLength) {
                return Optional.of(child);
            }
        });
    }

    public static <T> T handleChildren(List<? extends FileSystemNode> children, VfsRelativePath relativePath, CaseSensitivity caseSensitivity, ChildHandler<T> childHandler) {
        int childIndex = SearchUtil.binarySearch(children, candidate -> relativePath.compareToFirstSegment(candidate.getPathToParent(), caseSensitivity));
        if (childIndex >= 0) {
            return childHandler.handleChildOfExisting(childIndex);
        }
        return childHandler.handleNewChild(-childIndex - 1);
    }

    private static <T> T handlePathRelationship(String pathToParent, VfsRelativePath relativePath, CaseSensitivity caseSensitivity, PathRelationshipHandler<T> pathRelationshipHandler) {
        int pathToParentLength = pathToParent.length();
        int relativePathLength = relativePath.length();
        int maxPos = Math.min(pathToParentLength, relativePathLength);
        int commonPrefixLength = relativePath.lengthOfCommonPrefix(pathToParent, caseSensitivity);
        if (commonPrefixLength == maxPos) {
            if (pathToParentLength > relativePathLength) {
                return pathRelationshipHandler.handleAncestor();
            }
            if (pathToParentLength == relativePathLength) {
                return pathRelationshipHandler.handleSame();
            }
            return pathRelationshipHandler.handleDescendant();
        }
        return pathRelationshipHandler.handleDifferent(commonPrefixLength);
    }

    private static interface PathRelationshipHandler<T> {
        public T handleDescendant();

        public T handleAncestor();

        public T handleSame();

        public T handleDifferent(int var1);
    }

    public static interface ChildHandler<T> {
        public T handleNewChild(int var1);

        public T handleChildOfExisting(int var1);
    }
}

