/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.scala.internal.toolchain;

import java.io.File;
import java.util.Set;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.tasks.scala.DaemonScalaCompiler;
import org.gradle.api.internal.tasks.scala.HashedClasspath;
import org.gradle.api.internal.tasks.scala.NormalizingScalaCompiler;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.internal.tasks.scala.ZincScalaCompilerFacade;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.internal.logging.text.DiagnosticsVisitor;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.platform.base.internal.toolchain.ToolProvider;
import org.gradle.process.internal.JavaForkOptionsFactory;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.WorkerDaemonFactory;

public class DefaultScalaToolProvider
implements ToolProvider {
    public static final String DEFAULT_ZINC_VERSION = "1.3.5";
    private final File daemonWorkingDir;
    private final WorkerDaemonFactory workerDaemonFactory;
    private final HashedClasspath resolvedScalaClasspath;
    private final Set<File> resolvedZincClasspath;
    private final JavaForkOptionsFactory forkOptionsFactory;
    private final ClassPathRegistry classPathRegistry;
    private final ClassLoaderRegistry classLoaderRegistry;
    private final ActionExecutionSpecFactory actionExecutionSpecFactory;

    public DefaultScalaToolProvider(File daemonWorkingDir, WorkerDaemonFactory workerDaemonFactory, JavaForkOptionsFactory forkOptionsFactory, HashedClasspath resolvedScalaClasspath, Set<File> resolvedZincClasspath, ClassPathRegistry classPathRegistry, ClassLoaderRegistry classLoaderRegistry, ActionExecutionSpecFactory actionExecutionSpecFactory) {
        this.daemonWorkingDir = daemonWorkingDir;
        this.workerDaemonFactory = workerDaemonFactory;
        this.forkOptionsFactory = forkOptionsFactory;
        this.resolvedScalaClasspath = resolvedScalaClasspath;
        this.resolvedZincClasspath = resolvedZincClasspath;
        this.classPathRegistry = classPathRegistry;
        this.classLoaderRegistry = classLoaderRegistry;
        this.actionExecutionSpecFactory = actionExecutionSpecFactory;
    }

    @Override
    public <T extends CompileSpec> Compiler<T> newCompiler(Class<T> spec) {
        if (ScalaJavaJointCompileSpec.class.isAssignableFrom(spec)) {
            return new NormalizingScalaCompiler(new DaemonScalaCompiler<ScalaJavaJointCompileSpec>(this.daemonWorkingDir, ZincScalaCompilerFacade.class, new Object[]{this.resolvedScalaClasspath, true}, this.workerDaemonFactory, this.resolvedZincClasspath, this.forkOptionsFactory, this.classPathRegistry, this.classLoaderRegistry, this.actionExecutionSpecFactory));
        }
        throw new IllegalArgumentException(String.format("Cannot create Compiler for unsupported CompileSpec type '%s'", spec.getSimpleName()));
    }

    @Override
    public <T> T get(Class<T> toolType) {
        throw new IllegalArgumentException(String.format("Don't know how to provide tool of type %s.", toolType.getSimpleName()));
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public void explain(DiagnosticsVisitor visitor) {
    }
}

