/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.exec;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.launcher.daemon.server.api.DaemonCommandExecution;

class DaemonConnectionBackedEventConsumer
implements BuildEventConsumer {
    private final DaemonCommandExecution execution;
    private final BlockingQueue<Object> queue = new LinkedBlockingQueue<Object>();
    private final ForwardEvents forwarder = new ForwardEvents();

    public DaemonConnectionBackedEventConsumer(DaemonCommandExecution execution) {
        this.execution = execution;
        this.forwarder.start();
    }

    @Override
    public void dispatch(Object event) {
        this.queue.offer(event);
    }

    public void waitForFinish() {
        this.forwarder.waitForFinish();
    }

    private class ForwardEvents
    extends Thread {
        private volatile boolean stopped;
        private boolean ableToSend = true;

        private ForwardEvents() {
        }

        @Override
        public void run() {
            while (this.moreMessagesToSend()) {
                Object event = this.getNextEvent();
                if (event == null) continue;
                this.dispatchEvent(event);
            }
        }

        private boolean moreMessagesToSend() {
            return this.ableToSend && (!this.stopped || !DaemonConnectionBackedEventConsumer.this.queue.isEmpty());
        }

        private Object getNextEvent() {
            try {
                return DaemonConnectionBackedEventConsumer.this.queue.poll(10L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                this.stopped = true;
                return null;
            }
        }

        private void dispatchEvent(Object event) {
            try {
                DaemonConnectionBackedEventConsumer.this.execution.getConnection().event(event);
            }
            catch (RuntimeException e) {
                this.ableToSend = false;
            }
        }

        public void waitForFinish() {
            this.stopped = true;
            try {
                this.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

