/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.ReadOnlyPropertyException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.base.Equivalence;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.collect.ArrayListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.impldep.org.objectweb.asm.ClassVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.ClassWriter;
import org.gradle.internal.impldep.org.objectweb.asm.FieldVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.Label;
import org.gradle.internal.impldep.org.objectweb.asm.MethodVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.Type;
import org.gradle.internal.reflect.Methods;
import org.gradle.internal.reflect.PropertyAccessorType;
import org.gradle.internal.reflect.Types;
import org.gradle.internal.reflect.UnsupportedPropertyValueException;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.internal.typeconversion.TypeConverter;
import org.gradle.model.internal.asm.AsmClassGenerator;
import org.gradle.model.internal.asm.AsmClassGeneratorUtils;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.manage.binding.BridgeMethodBinding;
import org.gradle.model.internal.manage.binding.DelegateMethodBinding;
import org.gradle.model.internal.manage.binding.DirectMethodBinding;
import org.gradle.model.internal.manage.binding.ManagedProperty;
import org.gradle.model.internal.manage.binding.ManagedPropertyMethodBinding;
import org.gradle.model.internal.manage.binding.StructBindings;
import org.gradle.model.internal.manage.binding.StructMethodBinding;
import org.gradle.model.internal.manage.instance.GeneratedViewState;
import org.gradle.model.internal.manage.instance.ManagedInstance;
import org.gradle.model.internal.manage.instance.ModelElementState;
import org.gradle.model.internal.manage.schema.CompositeSchema;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.ScalarValueSchema;
import org.gradle.model.internal.manage.schema.StructSchema;
import org.gradle.model.internal.manage.schema.UnmanagedImplStructSchema;
import org.gradle.model.internal.manage.schema.extract.AbstractProxyClassGenerator;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaUtils;
import org.gradle.model.internal.method.WeaklyTypeReferencingMethod;
import org.gradle.model.internal.type.ModelType;
import org.gradle.util.ClosureBackedAction;

public class ManagedProxyClassGenerator
extends AbstractProxyClassGenerator {
    private static final String STATE_FIELD_NAME = "$state";
    private static final String TYPE_CONVERTER_FIELD_NAME = "$typeConverter";
    private static final String MANAGED_TYPE_FIELD_NAME = "$managedType";
    private static final String DELEGATE_FIELD_NAME = "$delegate";
    private static final String CAN_CALL_SETTERS_FIELD_NAME = "$canCallSetters";
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private static final Type STRING_TYPE = Type.getType(String.class);
    private static final Type CLASS_TYPE = Type.getType(Class.class);
    private static final Type CLOSURE_TYPE = Type.getType(Closure.class);
    private static final Type TYPE_CONVERTER_TYPE = Type.getType(TypeConverter.class);
    private static final Type MODEL_TYPE_TYPE = Type.getType(ModelType.class);
    private static final Type GENERATED_VIEW_STATE_TYPE = Type.getType(GeneratedViewState.class);
    private static final String GENERATED_VIEW_STATE_TYPE_NAME = GENERATED_VIEW_STATE_TYPE.getInternalName();
    private static final Type MODEL_ELEMENT_STATE_TYPE = Type.getType(ModelElementState.class);
    private static final Type GENERATED_VIEW_TYPE = Type.getType(GeneratedView.class);
    private static final String GET_VIEW_STATE_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)GENERATED_VIEW_STATE_TYPE, (Type[])new Type[0]);
    private static final String STATE_SET_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{STRING_TYPE, OBJECT_TYPE});
    private static final String STATE_GET_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{STRING_TYPE});
    private static final String STATE_APPLY_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{STRING_TYPE, CLOSURE_TYPE});
    private static final String MANAGED_INSTANCE_TYPE = Type.getInternalName(ManagedInstance.class);
    private static final String TO_STRING_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)STRING_TYPE, (Type[])new Type[0]);
    private static final String GET_BACKING_NODE_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(MutableModelNode.class), (Type[])new Type[0]);
    private static final String MODEL_TYPE_INTERNAL_NAME = MODEL_TYPE_TYPE.getInternalName();
    private static final String MODEL_TYPE_OF_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)MODEL_TYPE_TYPE, (Type[])new Type[]{CLASS_TYPE});
    private static final String GET_MANAGED_TYPE_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)MODEL_TYPE_TYPE, (Type[])new Type[0]);
    private static final String GET_PROPERTY_MISSING_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{STRING_TYPE});
    private static final String MISSING_PROPERTY_EXCEPTION_TYPE = Type.getInternalName(MissingPropertyException.class);
    private static final String READ_ONLY_PROPERTY_EXCEPTION_TYPE = Type.getInternalName(ReadOnlyPropertyException.class);
    private static final String CLASS_INTERNAL_NAME = Type.getInternalName(Class.class);
    private static final String FOR_NAME_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)CLASS_TYPE, (Type[])new Type[]{STRING_TYPE});
    private static final String HASH_CODE_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(Integer.TYPE), (Type[])new Type[0]);
    private static final String EQUALS_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(Boolean.TYPE), (Type[])new Type[]{OBJECT_TYPE});
    private static final String OBJECT_ARRAY_TYPE = Type.getInternalName(Object[].class);
    private static final String MISSING_METHOD_EXCEPTION_TYPE = Type.getInternalName(MissingMethodException.class);
    private static final Type TYPE_CONVERSION_EXCEPTION_TYPE = Type.getType(TypeConversionException.class);
    private static final String MISSING_PROPERTY_CONSTRUCTOR_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{STRING_TYPE, CLASS_TYPE});
    private static final String METHOD_MISSING_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{STRING_TYPE, OBJECT_TYPE});
    private static final String SET_PROPERTY_MISSING_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{STRING_TYPE, OBJECT_TYPE});
    private static final String MISSING_METHOD_EXCEPTION_CONSTRUCTOR_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{STRING_TYPE, CLASS_TYPE, Type.getType(Object[].class)});
    private static final String SET_OBJECT_PROPERTY_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{OBJECT_TYPE});
    private static final String COERCE_TO_SCALAR_DESCRIPTOR = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{OBJECT_TYPE, CLASS_TYPE, Type.getType(Boolean.TYPE)});
    private static final String MODEL_ELEMENT_STATE_TYPE_INTERNAL_NAME = MODEL_ELEMENT_STATE_TYPE.getInternalName();
    private static final Map<Class<?>, Class<?>> BOXED_TYPES = ImmutableMap.builder().put(Byte.TYPE, Byte.class).put(Short.TYPE, Short.class).put(Integer.TYPE, Integer.class).put(Boolean.TYPE, Boolean.class).put(Float.TYPE, Float.class).put(Character.TYPE, Character.class).put(Double.TYPE, Double.class).put(Long.TYPE, Long.class).build();

    public <T, M extends T, D extends T> Class<? extends M> generate(Class<? extends GeneratedViewState> backingStateType, StructSchema<M> viewSchema, StructBindings<?> structBindings) {
        Class superclass;
        Class viewClass;
        if (!structBindings.getImplementedViewSchemas().contains(viewSchema)) {
            throw new IllegalArgumentException(String.format("View '%s' is not supported by struct '%s'", viewSchema.getType(), structBindings.getPublicSchema().getType()));
        }
        ModelType viewType = viewSchema.getType();
        StringBuilder generatedTypeNameBuilder = new StringBuilder();
        if (backingStateType == GeneratedViewState.class) {
            generatedTypeNameBuilder.append("$View");
        } else {
            generatedTypeNameBuilder.append("$NodeView");
        }
        StructSchema delegateSchema = (StructSchema)Cast.uncheckedCast(structBindings.getDelegateSchema());
        if (delegateSchema != null) {
            generatedTypeNameBuilder.append("$").append(delegateSchema.getType().getName().replaceAll("\\.", "_"));
        }
        String classNameSuffix = generatedTypeNameBuilder.toString();
        final ImmutableSet.Builder interfacesToImplement = ImmutableSet.builder();
        final ImmutableSet.Builder typesToDelegate = ImmutableSet.builder();
        typesToDelegate.add(viewType);
        interfacesToImplement.add((Object)GENERATED_VIEW_TYPE.getInternalName());
        if (backingStateType == ModelElementState.class) {
            interfacesToImplement.add((Object)MANAGED_INSTANCE_TYPE);
        }
        if ((viewClass = viewType.getConcreteClass()).isInterface()) {
            superclass = Object.class;
            interfacesToImplement.add((Object)Type.getInternalName(viewClass));
        } else {
            superclass = viewClass;
        }
        if (delegateSchema != null) {
            Types.walkTypeHierarchy(delegateSchema.getType().getConcreteClass(), ModelSchemaUtils.IGNORED_OBJECT_TYPES, new Types.TypeVisitor<D>(){

                @Override
                public void visitType(Class<? super D> type) {
                    if (type.isInterface()) {
                        typesToDelegate.add(ModelType.of(type));
                        interfacesToImplement.add((Object)Type.getInternalName(type));
                    }
                }
            });
        }
        ClassLoader targetClassLoader = viewClass.getClassLoader();
        if (delegateSchema != null) {
            try {
                viewClass.getClassLoader().loadClass(delegateSchema.getType().getConcreteClass().getName());
            }
            catch (ClassNotFoundException e) {
                targetClassLoader = delegateSchema.getType().getConcreteClass().getClassLoader();
            }
        }
        AsmClassGenerator generator = new AsmClassGenerator(viewClass, classNameSuffix);
        ClassWriter visitor = generator.getVisitor();
        this.generateProxyClass(visitor, viewSchema, structBindings, (Collection<String>)interfacesToImplement.build(), (Collection<ModelType<?>>)typesToDelegate.build(), generator.getGeneratedType(), Type.getType(superclass), backingStateType);
        return generator.define(targetClassLoader);
    }

    private void generateProxyClass(ClassWriter visitor, StructSchema<?> viewSchema, StructBindings<?> bindings, Collection<String> interfacesToImplement, Collection<ModelType<?>> viewTypes, Type generatedType, Type superclassType, Class<? extends GeneratedViewState> backingStateType) {
        Class viewClass = viewSchema.getType().getConcreteClass();
        StructSchema<?> delegateSchema = bindings.getDelegateSchema();
        this.declareClass((ClassVisitor)visitor, interfacesToImplement, generatedType, superclassType);
        this.declareStateField((ClassVisitor)visitor);
        this.declareTypeConverterField((ClassVisitor)visitor);
        this.declareManagedTypeField((ClassVisitor)visitor);
        this.declareCanCallSettersField((ClassVisitor)visitor);
        this.writeStaticConstructor((ClassVisitor)visitor, generatedType, viewClass);
        this.writeConstructor((ClassVisitor)visitor, generatedType, superclassType, delegateSchema, Type.getType(backingStateType));
        this.writeToString((ClassVisitor)visitor, generatedType, viewClass, delegateSchema);
        this.writeGeneratedViewMethods(visitor, generatedType);
        if (backingStateType == ModelElementState.class) {
            this.writeManagedInstanceMethods((ClassVisitor)visitor, generatedType);
        }
        this.writeGroovyMethods((ClassVisitor)visitor, viewClass);
        this.writeViewMethods((ClassVisitor)visitor, generatedType, viewTypes, bindings);
        this.writeHashCodeMethod((ClassVisitor)visitor, generatedType);
        this.writeEqualsMethod((ClassVisitor)visitor, generatedType);
        visitor.visitEnd();
    }

    private void declareClass(ClassVisitor visitor, Collection<String> interfaceInternalNames, Type generatedType, Type superclassType) {
        visitor.visit(50, 1, generatedType.getInternalName(), null, superclassType.getInternalName(), (String[])Iterables.toArray(interfaceInternalNames, String.class));
    }

    private void declareStateField(ClassVisitor visitor) {
        this.declareField(visitor, STATE_FIELD_NAME, GeneratedViewState.class);
    }

    private void declareTypeConverterField(ClassVisitor visitor) {
        this.declareField(visitor, TYPE_CONVERTER_FIELD_NAME, TypeConverter.class);
    }

    private void declareManagedTypeField(ClassVisitor visitor) {
        this.declareStaticField(visitor, MANAGED_TYPE_FIELD_NAME, ModelType.class);
    }

    private void declareDelegateField(ClassVisitor visitor, Class<?> delegateClass) {
        this.declareField(visitor, DELEGATE_FIELD_NAME, delegateClass);
    }

    private void declareCanCallSettersField(ClassVisitor visitor) {
        this.declareField(visitor, CAN_CALL_SETTERS_FIELD_NAME, Boolean.TYPE);
    }

    private void declareField(ClassVisitor visitor, String name, Class<?> fieldClass) {
        visitor.visitField(4114, name, Type.getDescriptor(fieldClass), null, null);
    }

    private FieldVisitor declareStaticField(ClassVisitor visitor, String name, Class<?> fieldClass) {
        return visitor.visitField(4122, name, Type.getDescriptor(fieldClass), null, null);
    }

    private void writeConstructor(ClassVisitor visitor, Type generatedType, Type superclassType, StructSchema<?> delegateSchema, Type backingStateType) {
        String constructorDescriptor;
        Type delegateType;
        if (delegateSchema == null) {
            delegateType = null;
            constructorDescriptor = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{backingStateType, TYPE_CONVERTER_TYPE});
        } else {
            delegateType = Type.getType(delegateSchema.getType().getConcreteClass());
            constructorDescriptor = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{backingStateType, TYPE_CONVERTER_TYPE, delegateType});
        }
        MethodVisitor constructorVisitor = this.declareMethod(visitor, "<init>", constructorDescriptor, CONCRETE_SIGNATURE);
        this.invokeSuperConstructor(constructorVisitor, superclassType);
        this.assignStateField(constructorVisitor, generatedType);
        this.assignTypeConverterField(constructorVisitor, generatedType);
        if (delegateType != null) {
            this.assignDelegateField(constructorVisitor, generatedType, delegateType);
        }
        this.setCanCallSettersField(constructorVisitor, generatedType, true);
        this.finishVisitingMethod(constructorVisitor);
    }

    private void writeStaticConstructor(ClassVisitor visitor, Type generatedType, Class<?> managedTypeClass) {
        MethodVisitor constructorVisitor = this.declareMethod(visitor, "<clinit>", "()V", CONCRETE_SIGNATURE, 8);
        this.writeManagedTypeStaticField(generatedType, managedTypeClass, constructorVisitor);
        this.finishVisitingMethod(constructorVisitor);
    }

    private void writeManagedTypeStaticField(Type generatedType, Class<?> managedTypeClass, MethodVisitor constructorVisitor) {
        constructorVisitor.visitLdcInsn((Object)Type.getType(managedTypeClass));
        constructorVisitor.visitMethodInsn(184, MODEL_TYPE_INTERNAL_NAME, "of", MODEL_TYPE_OF_METHOD_DESCRIPTOR, false);
        constructorVisitor.visitFieldInsn(179, generatedType.getInternalName(), MANAGED_TYPE_FIELD_NAME, Type.getDescriptor(ModelType.class));
    }

    private void invokeSuperConstructor(MethodVisitor constructorVisitor, Type superclassType) {
        this.putThisOnStack(constructorVisitor);
        constructorVisitor.visitMethodInsn(183, superclassType.getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
    }

    private void writeToString(ClassVisitor visitor, Type generatedType, Class<?> viewClass, StructSchema<?> delegateSchema) {
        Method toStringMethod = this.getToStringMethod(viewClass);
        if (toStringMethod != null && !toStringMethod.getDeclaringClass().equals(Object.class)) {
            this.writeNonAbstractMethodWrapper(visitor, generatedType, viewClass, toStringMethod);
        } else if (delegateSchema != null && delegateSchema.hasProperty("displayName")) {
            this.writeDelegatingToString(visitor, generatedType, Type.getType(delegateSchema.getType().getConcreteClass()));
        } else {
            this.writeDefaultToString(visitor, generatedType);
        }
    }

    private void writeDelegatingToString(ClassVisitor visitor, Type generatedType, Type delegateType) {
        MethodVisitor methodVisitor = this.declareMethod(visitor, "toString", TO_STRING_METHOD_DESCRIPTOR, CONCRETE_SIGNATURE);
        this.putDelegateFieldValueOnStack(methodVisitor, generatedType, delegateType);
        methodVisitor.visitMethodInsn(182, delegateType.getInternalName(), "getDisplayName", TO_STRING_METHOD_DESCRIPTOR, false);
        this.finishVisitingMethod(methodVisitor, 176);
    }

    private void writeDefaultToString(ClassVisitor visitor, Type generatedType) {
        MethodVisitor methodVisitor = this.declareMethod(visitor, "toString", TO_STRING_METHOD_DESCRIPTOR, CONCRETE_SIGNATURE);
        this.putStateFieldValueOnStack(methodVisitor, generatedType);
        methodVisitor.visitMethodInsn(185, GENERATED_VIEW_STATE_TYPE_NAME, "getDisplayName", TO_STRING_METHOD_DESCRIPTOR, true);
        this.finishVisitingMethod(methodVisitor, 176);
    }

    private Method getToStringMethod(Class<?> managedTypeClass) {
        try {
            return managedTypeClass.getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private void writeGroovyMethods(ClassVisitor visitor, Class<?> viewClass) {
        MethodVisitor methodVisitor = this.declareMethod(visitor, "propertyMissing", GET_PROPERTY_MISSING_METHOD_DESCRIPTOR, CONCRETE_SIGNATURE);
        methodVisitor.visitTypeInsn(187, MISSING_PROPERTY_EXCEPTION_TYPE);
        methodVisitor.visitInsn(89);
        this.putFirstMethodArgumentOnStack(methodVisitor);
        this.putClassOnStack(methodVisitor, viewClass);
        methodVisitor.visitMethodInsn(183, MISSING_PROPERTY_EXCEPTION_TYPE, "<init>", MISSING_PROPERTY_CONSTRUCTOR_DESCRIPTOR, false);
        this.finishVisitingMethod(methodVisitor, 191);
        methodVisitor = this.declareMethod(visitor, "propertyMissing", SET_PROPERTY_MISSING_METHOD_DESCRIPTOR, CONCRETE_SIGNATURE);
        methodVisitor.visitTypeInsn(187, MISSING_PROPERTY_EXCEPTION_TYPE);
        methodVisitor.visitInsn(89);
        this.putFirstMethodArgumentOnStack(methodVisitor);
        this.putClassOnStack(methodVisitor, viewClass);
        methodVisitor.visitMethodInsn(183, MISSING_PROPERTY_EXCEPTION_TYPE, "<init>", MISSING_PROPERTY_CONSTRUCTOR_DESCRIPTOR, false);
        this.finishVisitingMethod(methodVisitor, 191);
        methodVisitor = this.declareMethod(visitor, "methodMissing", METHOD_MISSING_METHOD_DESCRIPTOR, CONCRETE_SIGNATURE);
        methodVisitor.visitTypeInsn(187, MISSING_METHOD_EXCEPTION_TYPE);
        methodVisitor.visitInsn(89);
        this.putMethodArgumentOnStack(methodVisitor, 1);
        this.putClassOnStack(methodVisitor, viewClass);
        this.putMethodArgumentOnStack(methodVisitor, 2);
        methodVisitor.visitTypeInsn(192, OBJECT_ARRAY_TYPE);
        methodVisitor.visitMethodInsn(183, MISSING_METHOD_EXCEPTION_TYPE, "<init>", MISSING_METHOD_EXCEPTION_CONSTRUCTOR_DESCRIPTOR, false);
        this.finishVisitingMethod(methodVisitor, 191);
    }

    private void putClassOnStack(MethodVisitor methodVisitor, Class<?> managedTypeClass) {
        this.putConstantOnStack(methodVisitor, managedTypeClass.getName());
        methodVisitor.visitMethodInsn(184, CLASS_INTERNAL_NAME, "forName", FOR_NAME_METHOD_DESCRIPTOR, false);
    }

    private void writeGeneratedViewMethods(ClassWriter visitor, Type generatedType) {
        MethodVisitor methodVisitor = this.declareMethod((ClassVisitor)visitor, "__view_state__", GET_VIEW_STATE_METHOD_DESCRIPTOR, CONCRETE_SIGNATURE, 4097);
        this.putStateFieldValueOnStack(methodVisitor, generatedType);
        this.finishVisitingMethod(methodVisitor, 176);
    }

    private void writeManagedInstanceMethods(ClassVisitor visitor, Type generatedType) {
        this.writeManagedInstanceGetBackingNodeMethod(visitor, generatedType);
        this.writeManagedInstanceGetManagedTypeMethod(visitor, generatedType);
    }

    private void writeManagedInstanceGetBackingNodeMethod(ClassVisitor visitor, Type generatedType) {
        MethodVisitor methodVisitor = this.declareMethod(visitor, "getBackingNode", GET_BACKING_NODE_METHOD_DESCRIPTOR, CONCRETE_SIGNATURE, 4097);
        this.putNodeStateFieldValueOnStack(methodVisitor, generatedType);
        methodVisitor.visitMethodInsn(185, MODEL_ELEMENT_STATE_TYPE_INTERNAL_NAME, "getBackingNode", GET_BACKING_NODE_METHOD_DESCRIPTOR, true);
        this.finishVisitingMethod(methodVisitor, 176);
    }

    private void writeManagedInstanceGetManagedTypeMethod(ClassVisitor visitor, Type generatedType) {
        MethodVisitor managedTypeVisitor = this.declareMethod(visitor, "getManagedType", GET_MANAGED_TYPE_METHOD_DESCRIPTOR, CONCRETE_SIGNATURE, 4097);
        this.putManagedTypeFieldValueOnStack(managedTypeVisitor, generatedType);
        this.finishVisitingMethod(managedTypeVisitor, 176);
    }

    private void assignStateField(MethodVisitor constructorVisitor, Type generatedType) {
        this.putThisOnStack(constructorVisitor);
        this.putFirstMethodArgumentOnStack(constructorVisitor);
        constructorVisitor.visitFieldInsn(181, generatedType.getInternalName(), STATE_FIELD_NAME, GENERATED_VIEW_STATE_TYPE.getDescriptor());
    }

    private void assignTypeConverterField(MethodVisitor constructorVisitor, Type generatedType) {
        this.putThisOnStack(constructorVisitor);
        this.putSecondMethodArgumentOnStack(constructorVisitor);
        constructorVisitor.visitFieldInsn(181, generatedType.getInternalName(), TYPE_CONVERTER_FIELD_NAME, TYPE_CONVERTER_TYPE.getDescriptor());
    }

    private void assignDelegateField(MethodVisitor constructorVisitor, Type generatedType, Type delegateType) {
        this.putThisOnStack(constructorVisitor);
        this.putThirdMethodArgumentOnStack(constructorVisitor);
        constructorVisitor.visitFieldInsn(181, generatedType.getInternalName(), DELEGATE_FIELD_NAME, delegateType.getDescriptor());
    }

    private void setCanCallSettersField(MethodVisitor methodVisitor, Type generatedType, boolean canCallSetters) {
        this.putThisOnStack(methodVisitor);
        methodVisitor.visitLdcInsn((Object)canCallSetters);
        methodVisitor.visitFieldInsn(181, generatedType.getInternalName(), CAN_CALL_SETTERS_FIELD_NAME, Type.BOOLEAN_TYPE.getDescriptor());
    }

    private void writeViewMethods(ClassVisitor visitor, Type generatedType, Collection<ModelType<?>> viewTypes, StructBindings<?> bindings) {
        Type delegateType;
        StructSchema<?> delegateSchema = bindings.getDelegateSchema();
        if (delegateSchema != null) {
            Class delegateClass = delegateSchema.getType().getRawClass();
            this.declareDelegateField(visitor, delegateClass);
            delegateType = Type.getType(delegateClass);
        } else {
            delegateType = null;
        }
        ArrayListMultimap viewPropertiesByNameBuilder = ArrayListMultimap.create();
        LinkedHashSet viewMethods = Sets.newLinkedHashSet();
        block4: for (StructSchema<?> viewSchema : bindings.getImplementedViewSchemas()) {
            for (ModelType<?> viewType : viewTypes) {
                if (!viewType.equals(viewSchema.getType())) continue;
                for (ModelProperty<?> modelProperty : viewSchema.getProperties()) {
                    String propertyName = modelProperty.getName();
                    viewPropertiesByNameBuilder.put((Object)propertyName, modelProperty);
                }
                for (WeaklyTypeReferencingMethod weaklyTypeReferencingMethod : viewSchema.getAllMethods()) {
                    viewMethods.add(Methods.SIGNATURE_EQUIVALENCE.wrap((Object)weaklyTypeReferencingMethod.getMethod()));
                }
                continue block4;
            }
        }
        Class viewClass = bindings.getPublicSchema().getType().getConcreteClass();
        for (Collection viewProperties : viewPropertiesByNameBuilder.asMap().values()) {
            this.writeViewPropertyDslMethods(visitor, generatedType, viewProperties, viewClass);
        }
        for (StructMethodBinding methodBinding : bindings.getMethodBindings()) {
            WeaklyTypeReferencingMethod<?, ?> weakViewMethod = methodBinding.getViewMethod();
            Method viewMethod = weakViewMethod.getMethod();
            Equivalence.Wrapper wrapper = Methods.SIGNATURE_EQUIVALENCE.wrap((Object)viewMethod);
            if (!viewMethods.contains(wrapper)) continue;
            if (methodBinding instanceof DirectMethodBinding) {
                boolean isGetterMethod = methodBinding.getAccessorType() == PropertyAccessorType.GET_GETTER || methodBinding.getAccessorType() == PropertyAccessorType.IS_GETTER;
                if (!isGetterMethod || Modifier.isFinal(viewMethod.getModifiers()) || viewMethod.getName().equals("getMetaClass")) continue;
                this.writeNonAbstractMethodWrapper(visitor, generatedType, viewClass, viewMethod);
                continue;
            }
            if (methodBinding instanceof BridgeMethodBinding) {
                this.writeBridgeMethod(visitor, generatedType, viewMethod);
                continue;
            }
            if (methodBinding instanceof DelegateMethodBinding) {
                this.writeDelegatingMethod(visitor, generatedType, delegateType, viewMethod);
                continue;
            }
            if (methodBinding instanceof ManagedPropertyMethodBinding) {
                ManagedPropertyMethodBinding propertyBinding = (ManagedPropertyMethodBinding)methodBinding;
                ManagedProperty<?> managedProperty = bindings.getManagedProperty(propertyBinding.getPropertyName());
                String propertyName = managedProperty.getName();
                Class<?> propertyClass = managedProperty.getType().getRawClass();
                WeaklyTypeReferencingMethod<?, ?> propertyAccessor = propertyBinding.getViewMethod();
                switch (propertyBinding.getAccessorType()) {
                    case GET_GETTER: 
                    case IS_GETTER: {
                        this.writeGetter(visitor, generatedType, propertyName, propertyClass, propertyAccessor);
                        break;
                    }
                    case SETTER: {
                        this.writeSetter(visitor, generatedType, propertyName, propertyClass, propertyAccessor);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                continue;
            }
            throw new AssertionError();
        }
    }

    private void writeViewPropertyDslMethods(ClassVisitor visitor, Type generatedType, Collection<ModelProperty<?>> viewProperties, Class<?> viewClass) {
        boolean writable = Iterables.any(viewProperties, (Predicate)new Predicate<ModelProperty<?>>(){

            public boolean apply(ModelProperty<?> viewProperty) {
                return viewProperty.isWritable();
            }
        });
        ModelProperty<?> firstProperty = viewProperties.iterator().next();
        this.writeConfigureMethod(visitor, generatedType, firstProperty, writable);
        this.writeSetMethod(visitor, generatedType, firstProperty);
        this.writeTypeConvertingSetter(visitor, generatedType, viewClass, firstProperty);
        this.writeReadOnlySetter(visitor, viewClass, writable, firstProperty);
    }

    private void writeReadOnlySetter(ClassVisitor visitor, Class<?> viewClass, boolean writable, ModelProperty<?> property) {
        if (!writable) {
            String setterName = "set" + StringUtils.capitalize((String)property.getName());
            MethodVisitor methodVisitor = this.declareMethod(visitor, setterName, SET_OBJECT_PROPERTY_DESCRIPTOR, null, 4097);
            methodVisitor.visitTypeInsn(187, READ_ONLY_PROPERTY_EXCEPTION_TYPE);
            methodVisitor.visitInsn(89);
            this.putConstantOnStack(methodVisitor, property.getName());
            this.putClassOnStack(methodVisitor, viewClass);
            methodVisitor.visitMethodInsn(183, READ_ONLY_PROPERTY_EXCEPTION_TYPE, "<init>", MISSING_PROPERTY_CONSTRUCTOR_DESCRIPTOR, false);
            this.finishVisitingMethod(methodVisitor, 191);
        }
    }

    private void writeSetMethod(ClassVisitor visitor, Type generatedType, ModelProperty<?> property) {
        WeaklyTypeReferencingMethod<?, ?> setter = property.getAccessor(PropertyAccessorType.SETTER);
        if (setter != null && property.getSchema() instanceof ScalarValueSchema) {
            MethodVisitor methodVisitor = this.declareMethod(visitor, property.getName(), Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{OBJECT_TYPE}), null);
            this.putThisOnStack(methodVisitor);
            this.putFirstMethodArgumentOnStack(methodVisitor);
            methodVisitor.visitMethodInsn(182, generatedType.getInternalName(), setter.getName(), Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{OBJECT_TYPE}), false);
            this.finishVisitingMethod(methodVisitor);
        }
    }

    private void writeConfigureMethod(ClassVisitor visitor, Type generatedType, ModelProperty<?> property, boolean writable) {
        if (!writable && property.getSchema() instanceof CompositeSchema) {
            MethodVisitor methodVisitor = this.declareMethod(visitor, property.getName(), Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{CLOSURE_TYPE}), null);
            this.putNodeStateFieldValueOnStack(methodVisitor, generatedType);
            this.putConstantOnStack(methodVisitor, property.getName());
            this.putFirstMethodArgumentOnStack(methodVisitor);
            methodVisitor.visitMethodInsn(185, MODEL_ELEMENT_STATE_TYPE_INTERNAL_NAME, "apply", STATE_APPLY_METHOD_DESCRIPTOR, true);
            this.finishVisitingMethod(methodVisitor);
            return;
        }
        if (!writable && property.getSchema() instanceof UnmanagedImplStructSchema) {
            UnmanagedImplStructSchema structSchema = (UnmanagedImplStructSchema)property.getSchema();
            if (!structSchema.isAnnotated()) {
                return;
            }
            MethodVisitor methodVisitor = this.declareMethod(visitor, property.getName(), Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{CLOSURE_TYPE}), null);
            this.putThisOnStack(methodVisitor);
            methodVisitor.visitMethodInsn(182, generatedType.getInternalName(), property.getGetter().getName(), Type.getMethodDescriptor((Type)Type.getType(property.getType().getConcreteClass()), (Type[])new Type[0]), false);
            this.putFirstMethodArgumentOnStack(methodVisitor);
            methodVisitor.visitMethodInsn(184, Type.getInternalName(ClosureBackedAction.class), "execute", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{OBJECT_TYPE, CLOSURE_TYPE}), false);
            this.finishVisitingMethod(methodVisitor);
            return;
        }
        MethodVisitor methodVisitor = this.declareMethod(visitor, property.getName(), Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{CLOSURE_TYPE}), null);
        this.putThisOnStack(methodVisitor);
        this.putConstantOnStack(methodVisitor, property.getName());
        methodVisitor.visitInsn(4);
        methodVisitor.visitTypeInsn(189, OBJECT_TYPE.getInternalName());
        methodVisitor.visitInsn(89);
        methodVisitor.visitInsn(3);
        this.putFirstMethodArgumentOnStack(methodVisitor);
        methodVisitor.visitInsn(83);
        methodVisitor.visitMethodInsn(182, generatedType.getInternalName(), "methodMissing", METHOD_MISSING_METHOD_DESCRIPTOR, false);
        this.finishVisitingMethod(methodVisitor);
    }

    private void writeSetter(ClassVisitor visitor, Type generatedType, String propertyName, Class<?> propertyClass, WeaklyTypeReferencingMethod<?, ?> weakSetter) {
        Type propertyType = Type.getType(propertyClass);
        Label calledOutsideOfConstructor = new Label();
        Method setter = weakSetter.getMethod();
        String methodDescriptor = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{propertyType});
        MethodVisitor methodVisitor = this.declareMethod(visitor, setter.getName(), methodDescriptor, AsmClassGeneratorUtils.signature(setter));
        this.putCanCallSettersFieldValueOnStack(methodVisitor, generatedType);
        this.jumpToLabelIfStackEvaluatesToTrue(methodVisitor, calledOutsideOfConstructor);
        this.throwExceptionBecauseCalledOnItself(methodVisitor);
        methodVisitor.visitLabel(calledOutsideOfConstructor);
        this.putStateFieldValueOnStack(methodVisitor, generatedType);
        this.putConstantOnStack(methodVisitor, propertyName);
        this.putFirstMethodArgumentOnStack(methodVisitor, propertyType);
        if (propertyClass.isPrimitive()) {
            this.boxType(methodVisitor, propertyClass);
        }
        this.invokeStateSetMethod(methodVisitor);
        this.finishVisitingMethod(methodVisitor);
    }

    private void writeTypeConvertingSetter(ClassVisitor visitor, Type generatedType, Class<?> viewClass, ModelProperty<?> property) {
        WeaklyTypeReferencingMethod<?, ?> weakSetter = property.getAccessor(PropertyAccessorType.SETTER);
        if (weakSetter == null) {
            return;
        }
        if (!(property.getSchema() instanceof ScalarValueSchema)) {
            return;
        }
        Class<?> propertyClass = property.getType().getConcreteClass();
        Type propertyType = Type.getType(propertyClass);
        Class<?> boxedClass = propertyClass.isPrimitive() ? BOXED_TYPES.get(propertyClass) : propertyClass;
        Type boxedType = Type.getType(boxedClass);
        Method setter = weakSetter.getMethod();
        MethodVisitor methodVisitor = this.declareMethod(visitor, setter.getName(), SET_OBJECT_PROPERTY_DESCRIPTOR, SET_OBJECT_PROPERTY_DESCRIPTOR);
        this.putThisOnStack(methodVisitor);
        this.putTypeConverterFieldValueOnStack(methodVisitor, generatedType);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitLdcInsn((Object)boxedType);
        methodVisitor.visitInsn(propertyClass.isPrimitive() ? 4 : 3);
        Label startTry = new Label();
        methodVisitor.visitLabel(startTry);
        methodVisitor.visitMethodInsn(185, TYPE_CONVERTER_TYPE.getInternalName(), "convert", COERCE_TO_SCALAR_DESCRIPTOR, true);
        Label endTry = new Label();
        methodVisitor.visitLabel(endTry);
        methodVisitor.visitTypeInsn(192, boxedType.getInternalName());
        if (propertyClass.isPrimitive()) {
            this.unboxType(methodVisitor, propertyClass);
        }
        methodVisitor.visitMethodInsn(182, generatedType.getInternalName(), setter.getName(), Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{propertyType}), false);
        methodVisitor.visitInsn(177);
        Label startCatch = new Label();
        methodVisitor.visitLabel(startCatch);
        methodVisitor.visitTryCatchBlock(startTry, endTry, startCatch, TYPE_CONVERSION_EXCEPTION_TYPE.getInternalName());
        methodVisitor.visitVarInsn(58, 2);
        this.putClassOnStack(methodVisitor, viewClass);
        methodVisitor.visitLdcInsn((Object)property.getName());
        this.putFirstMethodArgumentOnStack(methodVisitor);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitMethodInsn(184, Type.getInternalName(ManagedProxyClassGenerator.class), "propertyValueConvertFailure", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{CLASS_TYPE, STRING_TYPE, OBJECT_TYPE, TYPE_CONVERSION_EXCEPTION_TYPE}), false);
        this.finishVisitingMethod(methodVisitor);
    }

    private void writeHashCodeMethod(ClassVisitor visitor, Type generatedType) {
        MethodVisitor methodVisitor = this.declareMethod(visitor, "hashCode", HASH_CODE_METHOD_DESCRIPTOR, null);
        this.putStateFieldValueOnStack(methodVisitor, generatedType);
        methodVisitor.visitMethodInsn(185, GENERATED_VIEW_STATE_TYPE_NAME, "hashCode", HASH_CODE_METHOD_DESCRIPTOR, true);
        this.finishVisitingMethod(methodVisitor, 172);
    }

    private void writeEqualsMethod(ClassVisitor cw, Type generatedType) {
        MethodVisitor methodVisitor = cw.visitMethod(1, "equals", EQUALS_METHOD_DESCRIPTOR, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        Label notSameLabel = new Label();
        methodVisitor.visitJumpInsn(166, notSameLabel);
        methodVisitor.visitInsn(4);
        methodVisitor.visitInsn(172);
        methodVisitor.visitLabel(notSameLabel);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(193, GENERATED_VIEW_TYPE.getInternalName());
        Label generatedViewLabel = new Label();
        methodVisitor.visitJumpInsn(154, generatedViewLabel);
        methodVisitor.visitInsn(3);
        methodVisitor.visitInsn(172);
        methodVisitor.visitLabel(generatedViewLabel);
        this.putStateFieldValueOnStack(methodVisitor, generatedType);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(192, GENERATED_VIEW_TYPE.getInternalName());
        methodVisitor.visitMethodInsn(185, GENERATED_VIEW_TYPE.getInternalName(), "__view_state__", GET_VIEW_STATE_METHOD_DESCRIPTOR, true);
        methodVisitor.visitMethodInsn(185, GENERATED_VIEW_STATE_TYPE_NAME, "equals", EQUALS_METHOD_DESCRIPTOR, true);
        this.finishVisitingMethod(methodVisitor, 172);
    }

    private void throwExceptionBecauseCalledOnItself(MethodVisitor methodVisitor) {
        String exceptionInternalName = Type.getInternalName(UnsupportedOperationException.class);
        methodVisitor.visitTypeInsn(187, exceptionInternalName);
        methodVisitor.visitInsn(89);
        this.putConstantOnStack(methodVisitor, "Calling setters of a managed type on itself is not allowed");
        String constructorDescriptor = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{STRING_TYPE});
        methodVisitor.visitMethodInsn(183, exceptionInternalName, "<init>", constructorDescriptor, false);
        methodVisitor.visitInsn(191);
    }

    private void jumpToLabelIfStackEvaluatesToTrue(MethodVisitor methodVisitor, Label label) {
        methodVisitor.visitJumpInsn(154, label);
    }

    private void invokeStateSetMethod(MethodVisitor methodVisitor) {
        methodVisitor.visitMethodInsn(185, GENERATED_VIEW_STATE_TYPE_NAME, "set", STATE_SET_METHOD_DESCRIPTOR, true);
    }

    private void putConstantOnStack(MethodVisitor methodVisitor, Object value) {
        methodVisitor.visitLdcInsn(value);
    }

    private MethodVisitor declareMethod(ClassVisitor visitor, Method method) {
        return this.declareMethod(visitor, method.getName(), Type.getMethodDescriptor((Method)method));
    }

    private MethodVisitor declareMethod(ClassVisitor visitor, String methodName, String methodDescriptor) {
        return this.declareMethod(visitor, methodName, methodDescriptor, CONCRETE_SIGNATURE);
    }

    private MethodVisitor declareMethod(ClassVisitor visitor, String methodName, String methodDescriptor, String methodSignature) {
        return this.declareMethod(visitor, methodName, methodDescriptor, methodSignature, 1);
    }

    private MethodVisitor declareMethod(ClassVisitor visitor, String methodName, String methodDescriptor, String methodSignature, int access) {
        MethodVisitor methodVisitor = visitor.visitMethod(access, methodName, methodDescriptor, methodSignature, NO_EXCEPTIONS);
        methodVisitor.visitCode();
        return methodVisitor;
    }

    private void putFirstMethodArgumentOnStack(MethodVisitor methodVisitor, Type argType) {
        int loadCode = argType.getOpcode(21);
        methodVisitor.visitVarInsn(loadCode, 1);
    }

    private void putFirstMethodArgumentOnStack(MethodVisitor methodVisitor) {
        this.putFirstMethodArgumentOnStack(methodVisitor, OBJECT_TYPE);
    }

    private void putSecondMethodArgumentOnStack(MethodVisitor methodVisitor) {
        methodVisitor.visitVarInsn(25, 2);
    }

    private void putThirdMethodArgumentOnStack(MethodVisitor methodVisitor) {
        methodVisitor.visitVarInsn(25, 3);
    }

    private void putMethodArgumentOnStack(MethodVisitor methodVisitor, int index) {
        methodVisitor.visitVarInsn(25, index);
    }

    private void putMethodArgumentOnStack(MethodVisitor methodVisitor, Type type, int index) {
        methodVisitor.visitVarInsn(type.getOpcode(21), index);
    }

    private void putStateFieldValueOnStack(MethodVisitor methodVisitor, Type generatedType) {
        this.putFieldValueOnStack(methodVisitor, generatedType, STATE_FIELD_NAME, GENERATED_VIEW_STATE_TYPE);
    }

    private void putNodeStateFieldValueOnStack(MethodVisitor methodVisitor, Type generatedType) {
        this.putFieldValueOnStack(methodVisitor, generatedType, STATE_FIELD_NAME, GENERATED_VIEW_STATE_TYPE);
        methodVisitor.visitTypeInsn(192, MODEL_ELEMENT_STATE_TYPE_INTERNAL_NAME);
    }

    private void putTypeConverterFieldValueOnStack(MethodVisitor methodVisitor, Type generatedType) {
        this.putFieldValueOnStack(methodVisitor, generatedType, TYPE_CONVERTER_FIELD_NAME, TYPE_CONVERTER_TYPE);
    }

    private void putManagedTypeFieldValueOnStack(MethodVisitor methodVisitor, Type generatedType) {
        this.putStaticFieldValueOnStack(methodVisitor, generatedType, MANAGED_TYPE_FIELD_NAME, MODEL_TYPE_TYPE);
    }

    private void putDelegateFieldValueOnStack(MethodVisitor methodVisitor, Type generatedType, Type delegateType) {
        this.putFieldValueOnStack(methodVisitor, generatedType, DELEGATE_FIELD_NAME, delegateType);
    }

    private void putCanCallSettersFieldValueOnStack(MethodVisitor methodVisitor, Type generatedType) {
        this.putFieldValueOnStack(methodVisitor, generatedType, CAN_CALL_SETTERS_FIELD_NAME, Type.BOOLEAN_TYPE);
    }

    private void putFieldValueOnStack(MethodVisitor methodVisitor, Type generatedType, String name, Type fieldType) {
        this.putThisOnStack(methodVisitor);
        methodVisitor.visitFieldInsn(180, generatedType.getInternalName(), name, fieldType.getDescriptor());
    }

    private void putStaticFieldValueOnStack(MethodVisitor methodVisitor, Type generatedType, String name, Type fieldType) {
        methodVisitor.visitFieldInsn(178, generatedType.getInternalName(), name, fieldType.getDescriptor());
    }

    private void writeGetter(ClassVisitor visitor, Type generatedType, String propertyName, Class<?> propertyClass, WeaklyTypeReferencingMethod<?, ?> weakGetter) {
        Method getter = weakGetter.getMethod();
        Type propertyType = Type.getType(propertyClass);
        MethodVisitor methodVisitor = this.declareMethod(visitor, getter.getName(), Type.getMethodDescriptor((Type)propertyType, (Type[])new Type[0]), AsmClassGeneratorUtils.signature(getter));
        this.putStateFieldValueOnStack(methodVisitor, generatedType);
        this.putConstantOnStack(methodVisitor, propertyName);
        this.invokeStateGetMethod(methodVisitor);
        this.castFirstStackElement(methodVisitor, propertyClass);
        this.finishVisitingMethod(methodVisitor, this.returnCode(propertyType));
    }

    private int returnCode(Type returnType) {
        return returnType.getOpcode(172);
    }

    private void castFirstStackElement(MethodVisitor methodVisitor, Class<?> returnType) {
        if (returnType.isPrimitive()) {
            this.unboxType(methodVisitor, returnType);
        } else {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(returnType));
        }
    }

    private void boxType(MethodVisitor methodVisitor, Class<?> primitiveType) {
        Class<?> boxedType = BOXED_TYPES.get(primitiveType);
        methodVisitor.visitMethodInsn(184, Type.getInternalName(boxedType), "valueOf", "(" + Type.getDescriptor(primitiveType) + ")" + Type.getDescriptor(boxedType), false);
    }

    private void unboxType(MethodVisitor methodVisitor, Class<?> primitiveClass) {
        Class<?> boxedType = BOXED_TYPES.get(primitiveClass);
        Type primitiveType = Type.getType(primitiveClass);
        methodVisitor.visitTypeInsn(192, Type.getInternalName(boxedType));
        methodVisitor.visitInsn(89);
        Label exit = new Label();
        Label elseValue = new Label();
        methodVisitor.visitJumpInsn(199, elseValue);
        methodVisitor.visitInsn(87);
        this.pushDefaultValue(methodVisitor, primitiveClass);
        methodVisitor.visitJumpInsn(167, exit);
        methodVisitor.visitLabel(elseValue);
        methodVisitor.visitMethodInsn(182, Type.getInternalName(boxedType), primitiveClass.getSimpleName() + "Value", Type.getMethodDescriptor((Type)primitiveType, (Type[])new Type[0]), false);
        methodVisitor.visitLabel(exit);
    }

    private void pushDefaultValue(MethodVisitor methodVisitor, Class<?> primitiveType) {
        int ins = 3;
        if (Long.TYPE == primitiveType) {
            ins = 9;
        } else if (Double.TYPE == primitiveType) {
            ins = 14;
        } else if (Float.TYPE == primitiveType) {
            ins = 11;
        }
        methodVisitor.visitInsn(ins);
    }

    private void invokeStateGetMethod(MethodVisitor methodVisitor) {
        methodVisitor.visitMethodInsn(185, GENERATED_VIEW_STATE_TYPE_NAME, "get", STATE_GET_METHOD_DESCRIPTOR, true);
    }

    private void writeNonAbstractMethodWrapper(ClassVisitor visitor, Type generatedType, Class<?> managedTypeClass, Method method) {
        Label start = new Label();
        Label end = new Label();
        Label handler = new Label();
        MethodVisitor methodVisitor = this.declareMethod(visitor, method);
        methodVisitor.visitTryCatchBlock(start, end, handler, null);
        this.setCanCallSettersField(methodVisitor, generatedType, false);
        methodVisitor.visitLabel(start);
        this.invokeSuperMethod(methodVisitor, managedTypeClass, method);
        methodVisitor.visitLabel(end);
        this.setCanCallSettersField(methodVisitor, generatedType, true);
        methodVisitor.visitInsn(176);
        methodVisitor.visitLabel(handler);
        this.setCanCallSettersField(methodVisitor, generatedType, true);
        methodVisitor.visitInsn(191);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private void writeBridgeMethod(ClassVisitor visitor, Type generatedType, Method method) {
        MethodVisitor methodVisitor = this.declareMethod(visitor, method.getName(), Type.getMethodDescriptor((Method)method), AsmClassGeneratorUtils.signature(method));
        this.invokeBridgedMethod(methodVisitor, generatedType, method);
        Class<?> returnType = method.getReturnType();
        this.finishVisitingMethod(methodVisitor, this.returnCode(Type.getType(returnType)));
    }

    private void invokeBridgedMethod(MethodVisitor methodVisitor, Type generatedType, Method method) {
        this.putThisOnStack(methodVisitor);
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int paramNo = 0; paramNo < parameterTypes.length; ++paramNo) {
            this.putMethodArgumentOnStack(methodVisitor, Type.getType(parameterTypes[paramNo]), paramNo + 1);
        }
        methodVisitor.visitMethodInsn(182, generatedType.getInternalName(), method.getName(), Type.getMethodDescriptor((Method)method), false);
    }

    private void writeDelegatingMethod(ClassVisitor visitor, Type generatedType, Type delegateType, Method method) {
        MethodVisitor methodVisitor = this.declareMethod(visitor, method.getName(), Type.getMethodDescriptor((Method)method), AsmClassGeneratorUtils.signature(method));
        this.invokeDelegateMethod(methodVisitor, generatedType, delegateType, method);
        Class<?> returnType = method.getReturnType();
        this.finishVisitingMethod(methodVisitor, this.returnCode(Type.getType(returnType)));
    }

    private void invokeDelegateMethod(MethodVisitor methodVisitor, Type generatedType, Type delegateType, Method method) {
        this.putDelegateFieldValueOnStack(methodVisitor, generatedType, delegateType);
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int paramNo = 0; paramNo < parameterTypes.length; ++paramNo) {
            this.putMethodArgumentOnStack(methodVisitor, Type.getType(parameterTypes[paramNo]), paramNo + 1);
        }
        methodVisitor.visitMethodInsn(182, delegateType.getInternalName(), method.getName(), Type.getMethodDescriptor((Method)method), false);
    }

    private void invokeSuperMethod(MethodVisitor methodVisitor, Class<?> superClass, Method method) {
        this.putThisOnStack(methodVisitor);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(superClass), method.getName(), Type.getMethodDescriptor((Method)method), false);
    }

    public static void propertyValueConvertFailure(Class<?> viewType, String propertyName, Object value, TypeConversionException failure) throws UnsupportedPropertyValueException {
        throw new UnsupportedPropertyValueException(String.format("Cannot set property: %s for class: %s to value: %s.", propertyName, viewType.getName(), value), failure);
    }

    public static interface GeneratedView {
        public GeneratedViewState __view_state__();
    }
}

