/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.type;

import groovy.lang.GroovyObject;
import java.util.ArrayDeque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Ordering;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.model.ModelMap;
import org.gradle.model.ModelSet;
import org.gradle.model.internal.type.ModelType;

public abstract class ModelTypes {
    public static <I> ModelType<ModelMap<I>> modelMap(Class<I> type) {
        return ModelTypes.modelMap(ModelType.of(type));
    }

    public static <I> ModelType<ModelMap<I>> modelMap(ModelType<I> type) {
        return new ModelType.Builder<ModelMap<I>>(){}.where(new ModelType.Parameter<I>(){}, type).build();
    }

    public static <I> ModelType<ModelSet<I>> modelSet(ModelType<I> type) {
        return new ModelType.Builder<ModelSet<I>>(){}.where(new ModelType.Parameter<I>(){}, type).build();
    }

    public static <I> ModelType<List<I>> list(ModelType<I> type) {
        return new ModelType.Builder<List<I>>(){}.where(new ModelType.Parameter<I>(){}, type).build();
    }

    public static <I> ModelType<Set<I>> set(ModelType<I> type) {
        return new ModelType.Builder<Set<I>>(){}.where(new ModelType.Parameter<I>(){}, type).build();
    }

    public static <T> Ordering<ModelType<? extends T>> displayOrder() {
        return new Ordering<ModelType<? extends T>>(){

            public int compare(ModelType<? extends T> left, ModelType<? extends T> right) {
                return left.getDisplayName().compareTo(right.getDisplayName());
            }
        };
    }

    public static Iterable<String> getDisplayNames(Iterable<? extends ModelType<?>> types) {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        for (ModelType<?> type : types) {
            builder.add((Object)type.getDisplayName());
        }
        return builder.build();
    }

    public static Set<ModelType<?>> collectHierarchy(Iterable<? extends ModelType<?>> types) {
        ModelType type;
        ArrayDeque queue = new ArrayDeque(Iterables.size(types) * 2);
        Iterables.addAll(queue, types);
        LinkedHashSet seenTypes = Sets.newLinkedHashSet();
        while ((type = (ModelType)queue.poll()) != null) {
            ModelType superType;
            Class rawClass = type.getRawClass();
            if (rawClass.equals(Object.class) || rawClass.equals(GroovyObject.class) || !seenTypes.add(type)) continue;
            Class superclass = rawClass.getSuperclass();
            if (superclass != null && !seenTypes.contains(superType = ModelType.of(superclass))) {
                queue.add(superType);
            }
            for (Class<?> iface : rawClass.getInterfaces()) {
                ModelType<?> ifaceType = ModelType.of(iface);
                if (seenTypes.contains(ifaceType)) continue;
                queue.add(ifaceType);
            }
        }
        return seenTypes;
    }
}

