/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.xctest.internal.execution;

import java.util.Deque;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.testing.DefaultTestClassDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestMethodDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestOutputEvent;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.io.TextStream;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.time.Clock;
import org.gradle.nativeplatform.test.xctest.internal.execution.XCTestDescriptor;
import org.gradle.util.TextUtil;

class XCTestScraper
implements TextStream {
    private static final Pattern TEST_FAILURE_PATTERN = Pattern.compile(":\\d+: error: (-\\[\\p{Alnum}+.)?(\\p{Alnum}+)[ .](\\p{Alnum}+)]? : (.*)");
    private final TestResultProcessor processor;
    private final TestOutputEvent.Destination destination;
    private final IdGenerator<?> idGenerator;
    private final Clock clock;
    private final String rootTestSuiteId;
    private final Deque<XCTestDescriptor> testDescriptors;
    private TestDescriptorInternal lastDescriptor;
    private StringBuilder textBuilder = new StringBuilder();

    XCTestScraper(TestOutputEvent.Destination destination, TestResultProcessor processor, IdGenerator<?> idGenerator, Clock clock, String rootTestSuiteId, Deque<XCTestDescriptor> testDescriptors) {
        this.processor = processor;
        this.destination = destination;
        this.idGenerator = idGenerator;
        this.clock = clock;
        this.rootTestSuiteId = rootTestSuiteId;
        this.testDescriptors = testDescriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void text(String textFragment) {
        this.textBuilder.append(textFragment);
        if (!textFragment.endsWith(SystemProperties.getInstance().getLineSeparator())) {
            return;
        }
        String text = this.textBuilder.toString();
        this.textBuilder = new StringBuilder();
        Deque<XCTestDescriptor> deque = this.testDescriptors;
        synchronized (deque) {
            Scanner scanner = new Scanner(text).useDelimiter("'");
            if (scanner.hasNext()) {
                String token = scanner.next().trim();
                if (token.equals("Test Suite")) {
                    String testSuite = scanner.next();
                    if (testSuite.equals("All tests") || testSuite.equals("Selected tests") || testSuite.endsWith(".xctest")) {
                        return;
                    }
                    String status = scanner.next();
                    boolean started = status.contains("started at");
                    if (started) {
                        DefaultTestClassDescriptor testDescriptor = new DefaultTestClassDescriptor(this.idGenerator.generateId(), testSuite);
                        this.processor.started(testDescriptor, new TestStartEvent(this.clock.getCurrentTime()));
                        this.testDescriptors.push(new XCTestDescriptor(testDescriptor));
                    } else {
                        XCTestDescriptor xcTestDescriptor = this.testDescriptors.pop();
                        this.lastDescriptor = xcTestDescriptor.getDescriptorInternal();
                        TestDescriptorInternal testDescriptor = xcTestDescriptor.getDescriptorInternal();
                        TestResult.ResultType resultType = TestResult.ResultType.SUCCESS;
                        boolean failed = status.contains("failed at");
                        if (failed) {
                            resultType = TestResult.ResultType.FAILURE;
                        }
                        this.processor.completed(testDescriptor.getId(), new TestCompleteEvent(this.clock.getCurrentTime(), resultType));
                    }
                } else if (token.equals("Test Case")) {
                    String testCase;
                    String testSuite;
                    String testSuiteAndCase = scanner.next();
                    String[] splits = testSuiteAndCase.replace('[', ' ').replace(']', ' ').split("[. ]");
                    if (OperatingSystem.current().isMacOsX()) {
                        testSuite = splits[2];
                        testCase = splits[3];
                    } else {
                        testSuite = splits[0];
                        testCase = splits[1];
                    }
                    String status = scanner.next().trim();
                    boolean started = status.contains("started");
                    if (started) {
                        DefaultTestMethodDescriptor testDescriptor = new DefaultTestMethodDescriptor(this.idGenerator.generateId(), testSuite, testCase);
                        this.processor.started(testDescriptor, new TestStartEvent(this.clock.getCurrentTime()));
                        this.testDescriptors.push(new XCTestDescriptor(testDescriptor));
                    } else {
                        XCTestDescriptor xcTestDescriptor = this.testDescriptors.pop();
                        this.lastDescriptor = xcTestDescriptor.getDescriptorInternal();
                        TestDescriptorInternal testDescriptor = xcTestDescriptor.getDescriptorInternal();
                        TestResult.ResultType resultType = TestResult.ResultType.SUCCESS;
                        boolean failed = status.contains("failed");
                        if (failed) {
                            resultType = TestResult.ResultType.FAILURE;
                            this.processor.failure(testDescriptor.getId(), new Throwable(Joiner.on((String)TextUtil.getPlatformLineSeparator()).join(xcTestDescriptor.getMessages())));
                        }
                        this.processor.completed(testDescriptor.getId(), new TestCompleteEvent(this.clock.getCurrentTime(), resultType));
                    }
                } else {
                    XCTestDescriptor xcTestDescriptor = this.testDescriptors.peek();
                    if (xcTestDescriptor != null) {
                        TestDescriptorInternal testDescriptor = xcTestDescriptor.getDescriptorInternal();
                        this.processor.output(testDescriptor.getId(), new DefaultTestOutputEvent(this.destination, text));
                        Matcher failureMessageMatcher = TEST_FAILURE_PATTERN.matcher(text);
                        if (failureMessageMatcher.find()) {
                            String testSuite = failureMessageMatcher.group(2);
                            String testCase = failureMessageMatcher.group(3);
                            String message2 = failureMessageMatcher.group(4);
                            if (testDescriptor.getClassName().equals(testSuite) && testDescriptor.getName().equals(testCase)) {
                                xcTestDescriptor.getMessages().add(message2);
                            }
                        }
                    } else if (this.lastDescriptor != null) {
                        this.processor.output(this.lastDescriptor.getId(), new DefaultTestOutputEvent(this.destination, text));
                    } else {
                        this.processor.output(this.rootTestSuiteId, new DefaultTestOutputEvent(this.destination, text));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endOfStream(@Nullable Throwable failure) {
        if (failure != null) {
            Deque<XCTestDescriptor> deque = this.testDescriptors;
            synchronized (deque) {
                Object testId = !this.testDescriptors.isEmpty() ? this.testDescriptors.pop().getDescriptorInternal().getId() : this.rootTestSuiteId;
                this.processor.failure(testId, failure);
                this.testDescriptors.clear();
            }
        }
    }
}

