/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.psi.impl;

import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.Optional;
import kotlin.text.StringsKt;
import org.editorconfig.language.psi.EditorConfigCharClassLetter;
import org.editorconfig.language.psi.EditorConfigOptionValueList;
import org.editorconfig.language.psi.EditorConfigOptionValuePair;
import org.editorconfig.language.psi.impl.EditorConfigListDescriptorFinderVisitor;
import org.editorconfig.language.psi.impl.EditorConfigPairDescriptorFinderVisitor;
import org.editorconfig.language.psi.interfaces.EditorConfigDescribableElement;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorConfigPsiImplUtils {
    private EditorConfigPsiImplUtils() {
    }

    public static boolean isEscape(@NotNull EditorConfigCharClassLetter letter) {
        if (letter == null) {
            EditorConfigPsiImplUtils.$$$reportNull$$$0(0);
        }
        return letter.textContains('\\');
    }

    public static boolean isValidEscape(@NotNull EditorConfigCharClassLetter letter) {
        if (letter == null) {
            EditorConfigPsiImplUtils.$$$reportNull$$$0(1);
        }
        if (!letter.isEscape()) {
            return false;
        }
        int length = letter.getTextLength();
        if (length == 3) {
            return letter.textMatches("\\\r\n");
        }
        if (length != 2) {
            return false;
        }
        String text = letter.getText();
        if (text.charAt(0) != '\\') {
            return false;
        }
        return StringsKt.contains((CharSequence)" \r\n\t\\#;!?*[]{}", (char)text.charAt(1), (boolean)false);
    }

    @Nullable
    public static EditorConfigDescriptor getDescriptor(@NotNull EditorConfigOptionValuePair pair, boolean smart) {
        EditorConfigDescribableElement parent;
        if (pair == null) {
            EditorConfigPsiImplUtils.$$$reportNull$$$0(2);
        }
        if ((parent = pair.getDescribableParent()) == null) {
            return null;
        }
        EditorConfigDescriptor parentDescriptor = parent.getDescriptor(smart);
        if (parentDescriptor == null) {
            return null;
        }
        EditorConfigPairDescriptorFinderVisitor finder = new EditorConfigPairDescriptorFinderVisitor();
        parentDescriptor.accept(finder);
        return finder.getDescriptor();
    }

    @Nullable
    public static EditorConfigDescriptor getDescriptor(@NotNull EditorConfigOptionValueList list, boolean smart) {
        EditorConfigDescribableElement parent;
        if (list == null) {
            EditorConfigPsiImplUtils.$$$reportNull$$$0(3);
        }
        if ((parent = list.getDescribableParent()) == null) {
            return null;
        }
        EditorConfigDescriptor parentDescriptor = parent.getDescriptor(smart);
        if (parentDescriptor == null) {
            return null;
        }
        EditorConfigListDescriptorFinderVisitor finder = new EditorConfigListDescriptorFinderVisitor(list);
        parentDescriptor.accept(finder);
        return finder.getDescriptor();
    }

    @NotNull
    public static EditorConfigDescribableElement getFirst(@NotNull EditorConfigOptionValuePair pair) {
        Optional<PsiElement> first;
        if (pair == null) {
            EditorConfigPsiImplUtils.$$$reportNull$$$0(4);
        }
        if ((first = Arrays.stream(pair.getChildren()).filter(child -> child instanceof EditorConfigDescribableElement).findFirst()).isEmpty()) {
            throw new IllegalStateException();
        }
        EditorConfigDescribableElement editorConfigDescribableElement = (EditorConfigDescribableElement)first.get();
        if (editorConfigDescribableElement == null) {
            EditorConfigPsiImplUtils.$$$reportNull$$$0(5);
        }
        return editorConfigDescribableElement;
    }

    @NotNull
    public static EditorConfigDescribableElement getSecond(@NotNull EditorConfigOptionValuePair pair) {
        Optional<PsiElement> second;
        if (pair == null) {
            EditorConfigPsiImplUtils.$$$reportNull$$$0(6);
        }
        if ((second = Arrays.stream(pair.getChildren()).filter(child -> child instanceof EditorConfigDescribableElement).skip(1L).findFirst()).isEmpty()) {
            throw new IllegalStateException();
        }
        EditorConfigDescribableElement editorConfigDescribableElement = (EditorConfigDescribableElement)second.get();
        if (editorConfigDescribableElement == null) {
            EditorConfigPsiImplUtils.$$$reportNull$$$0(7);
        }
        return editorConfigDescribableElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "letter";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/editorconfig/language/psi/impl/EditorConfigPsiImplUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/editorconfig/language/psi/impl/EditorConfigPsiImplUtils";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirst";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecond";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEscape";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isValidEscape";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFirst";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSecond";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

