<TeXmacs|1.99.12>

<style|<tuple|tmdoc|old-spacing|framed-session|old-dots>>

<\body>
  <tmdoc-title|Example of <name|Graphviz> sessions>

  You may insert a <name|Graphviz> session using
  <menu|Insert|Session|Graph>viz.

  Type <verbatim|help>, you will get all the available graph backends.

  <\session|dot|default>
    <\output>
      dot - graphviz version 2.43.0 (0)
    </output>

    <\unfolded-io>
      dot]\ 
    <|unfolded-io>
      help
    <|unfolded-io>
      [help, dot, neato, twopi, circo, fdp, sfdp, patchwork, osage]

      dot - graphviz version 2.43.0 (0)
    </unfolded-io>

    <\unfolded-io>
      dot]\ 
    <|unfolded-io>
      neato
    <|unfolded-io>
      neato - graphviz version 2.43.0 (0)
    </unfolded-io>

    <\unfolded-io>
      neato]\ 
    <|unfolded-io>
      twopi
    <|unfolded-io>
      twopi - graphviz version 2.43.0 (0)
    </unfolded-io>

    <\input>
      twopi]\ 
    <|input>
      \;
    </input>
  </session>

  <section|The Magic Line><label|magicline>

  You may control the behavior of the graph generator via the magic line.

  <\session|dot|default>
    <\unfolded-io>
      twopi]\ 
    <|unfolded-io>
      %dot -width 400

      digraph G { a -\<gtr\> b; a -\<gtr\> c; a -\<gtr\> d; a -\<gtr\> f; a
      -\<gtr\> g }
    <|unfolded-io>
      <image|<tuple|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|ps>|400px|||>
    </unfolded-io>

    <\unfolded-io>
      twopi]\ 
    <|unfolded-io>
      %dot -width 300

      digraph G { a -\<gtr\> b; a -\<gtr\> c; a -\<gtr\> d; a -\<gtr\> f; a
      -\<gtr\> g }
    <|unfolded-io>
      <image|<tuple|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|ps>|300px|||>
    </unfolded-io>

    <\unfolded-io>
      twopi]\ 
    <|unfolded-io>
      %neato -width 400

      digraph G { a -\<gtr\> b; a -\<gtr\> c; a -\<gtr\> d; a -\<gtr\> f; a
      -\<gtr\> g }
    <|unfolded-io>
      <image|<tuple|<#252150532D41646F62652D332E3020455053462D332E300A252543726561746F723A20677261706876697A2076657273696F6E20322E34332E30202830290A25255469746C653A20470A252550616765733A20310A2525426F756E64696E67426F783A20333620333620323532203233300A2525456E64436F6D6D656E74730A736176650A2525426567696E50726F6C6F670A2F446F7444696374203230302064696374206465660A446F744469637420626567696E0A0A2F73657475704C6174696E31207B0A6D61726B0A2F456E636F64696E67566563746F7220323536206172726179206465660A20456E636F64696E67566563746F7220300A0A49534F4C6174696E31456E636F64696E6720302032353520676574696E74657276616C20707574696E74657276616C0A456E636F64696E67566563746F72203435202F68797068656E207075740A0A25205365742075702049534F204C6174696E20312063686172616374657220656E636F64696E670A2F737461726E657449534F207B0A2020202020202020647570206475702066696E64666F6E7420647570206C656E677468206469637420626567696E0A20202020202020207B203120696E646578202F464944206E65207B20646566207D7B20706F7020706F70207D206966656C73650A20202020202020207D20666F72616C6C0A20202020202020202F456E636F64696E6720456E636F64696E67566563746F72206465660A202020202020202063757272656E746469637420656E6420646566696E65666F6E740A7D206465660A2F54696D65732D526F6D616E20737461726E657449534F206465660A2F54696D65732D4974616C696320737461726E657449534F206465660A2F54696D65732D426F6C6420737461726E657449534F206465660A2F54696D65732D426F6C644974616C696320737461726E657449534F206465660A2F48656C76657469636120737461726E657449534F206465660A2F48656C7665746963612D4F626C6971756520737461726E657449534F206465660A2F48656C7665746963612D426F6C6420737461726E657449534F206465660A2F48656C7665746963612D426F6C644F626C6971756520737461726E657449534F206465660A2F436F757269657220737461726E657449534F206465660A2F436F75726965722D4F626C6971756520737461726E657449534F206465660A2F436F75726965722D426F6C6420737461726E657449534F206465660A2F436F75726965722D426F6C644F626C6971756520737461726E657449534F206465660A636C656172746F6D61726B0A7D2062696E64206465660A0A2525426567696E5265736F757263653A2070726F6373657420677261706876697A203020300A2F636F6F72642D666F6E742D66616D696C79202F54696D65732D526F6D616E206465660A2F64656661756C742D666F6E742D66616D696C79202F54696D65732D526F6D616E206465660A2F636F6F7264666F6E7420636F6F72642D666F6E742D66616D696C792066696E64666F6E742038207363616C65666F6E74206465660A0A2F496E765363616C65466163746F7220312E30206465660A2F7365745F7363616C65207B0A202020202020206475702031206578636820646976202F496E765363616C65466163746F722065786368206465660A202020202020207363616C650A7D2062696E64206465660A0A25207374796C65730A2F736F6C6964207B205B5D20302073657464617368207D2062696E64206465660A2F646173686564207B205B3920496E765363616C65466163746F72206D756C20647570205D20302073657464617368207D2062696E64206465660A2F646F74746564207B205B3120496E765363616C65466163746F72206D756C203620496E765363616C65466163746F72206D756C5D20302073657464617368207D2062696E64206465660A2F696E766973207B2F66696C6C207B6E6577706174687D20646566202F7374726F6B65207B6E6577706174687D20646566202F73686F77207B706F70206E6577706174687D206465667D2062696E64206465660A2F626F6C64207B2032207365746C696E657769647468207D2062696E64206465660A2F66696C6C6564207B207D2062696E64206465660A2F756E66696C6C6564207B207D2062696E64206465660A2F726F756E646564207B207D2062696E64206465660A2F646961676F6E616C73207B207D2062696E64206465660A2F74617065726564207B207D2062696E64206465660A0A2520686F6F6B7320666F722073657474696E6720636F6C6F72200A2F6E6F6465636F6C6F72207B20736574687362636F6C6F72207D2062696E64206465660A2F65646765636F6C6F72207B20736574687362636F6C6F72207D2062696E64206465660A2F6772617068636F6C6F72207B20736574687362636F6C6F72207D2062696E64206465660A2F6E6F70636F6C6F72207B706F7020706F7020706F707D2062696E64206465660A0A2F626567696E70616765207B09252069206A206E70616765730A092F6E70616765732065786368206465660A092F6A2065786368206465660A092F692065786368206465660A092F73747220313020737472696E67206465660A096E70616765732031206774207B0A090967736176650A090909636F6F7264666F6E7420736574666F6E740A090909302030206D6F7665746F0A090909285C28292073686F77206920737472206376732073686F7720282C292073686F77206A20737472206376732073686F7720285C29292073686F770A090967726573746F72650A097D2069660A7D2062696E64206465660A0A2F7365745F666F6E74207B0A0966696E64666F6E7420657863680A097363616C65666F6E7420736574666F6E740A7D206465660A0A25206472617720746578742066697474656420746F206974732065787065637465642077696474680A2F616C69676E656474657874207B0909092520776964746820746578740A092F746578742065786368206465660A092F77696474682065786368206465660A0967736176650A090977696474682030206774207B0A0909095B5D203020736574646173680A0909097465787420737472696E67776964746820706F702077696474682065786368207375622074657874206C656E6774682064697620302074657874206173686F770A09097D2069660A0967726573746F72650A7D206465660A0A2F626F787072696D207B09090909252078636F726E65722079636F726E6572207873697A65207973697A650A090934203220726F6C6C0A09096D6F7665746F0A09093220636F70790A090965786368203020726C696E65746F0A090930206578636820726C696E65746F0A0909706F70206E6567203020726C696E65746F0A0909636C6F7365706174680A7D2062696E64206465660A0A2F656C6C697073655F70617468207B0A092F72792065786368206465660A092F72782065786368206465660A092F792065786368206465660A092F782065786368206465660A096D61747269782063757272656E746D61747269780A096E6577706174680A09782079207472616E736C6174650A097278207279207363616C650A093020302031203020333630206172630A097365746D61747269780A7D2062696E64206465660A0A2F656E6470616765207B2073686F7770616765207D2062696E64206465660A2F73686F7770616765207B207D206465660A0A2F6C61796572636F6C6F727365710A095B0925206C6179657220636F6C6F722073657175656E6365202D206461726B65737420746F206C696768746573740A09095B30203020305D0A09095B2E32202E38202E385D0A09095B2E34202E38202E385D0A09095B2E36202E38202E385D0A09095B2E38202E38202E385D0A095D0A6465660A0A2F6C617965726C656E206C61796572636F6C6F72736571206C656E677468206465660A0A2F7365746C61796572207B2F6D61786C61796572206578636820646566202F6375726C617965722065786368206465660A096C61796572636F6C6F72736571206375726C61796572203120737562206C617965726C656E206D6F64206765740A09616C6F616420706F7020736574687362636F6C6F720A092F6E6F6465636F6C6F72207B6E6F70636F6C6F727D206465660A092F65646765636F6C6F72207B6E6F70636F6C6F727D206465660A092F6772617068636F6C6F72207B6E6F70636F6C6F727D206465660A7D2062696E64206465660A0A2F6F6E6C61796572207B206375726C61796572206E65207B696E7669737D206966207D206465660A0A2F6F6E6C6179657273207B0A092F6D7975707065722065786368206465660A092F6D796C6F7765722065786368206465660A096375726C61796572206D796C6F776572206C740A096375726C61796572206D7975707065722067740A096F720A097B696E7669737D2069660A7D206465660A0A2F6375726C617965722030206465660A0A2525456E645265736F757263650A2525456E6450726F6C6F670A2525426567696E53657475700A31342064656661756C742D666F6E742D66616D696C79207365745F666F6E740A25202F6172726F776C656E677468203130206465660A25202F6172726F7777696474682035206465660A0A25206D616B652073757265207064666D61726B206973206861726D6C65737320666F722050532D696E74657270726574657273206F74686572207468616E2044697374696C6C65720A2F7064666D61726B207768657265207B706F707D207B7573657264696374202F7064666D61726B202F636C656172746F6D61726B206C6F6164207075747D206966656C73650A25206D616B6520273C3C2720616E6420273E3E272073616665206F6E205053204C6576656C203120646576696365730A2F6C616E67756167656C6576656C207768657265207B706F70206C616E67756167656C6576656C7D7B317D206966656C73650A32206C74207B0A20202020757365726469637420283C3C292063766E20285B292063766E206C6F6164207075740A20202020757365726469637420283E3E292063766E20285B292063766E206C6F6164207075740A7D2069660A0A2525456E6453657475700A73657475704C6174696E310A2525506167653A203120310A252550616765426F756E64696E67426F783A20333620333620323532203233300A2525506167654F7269656E746174696F6E3A20506F7274726169740A302030203120626567696E706167650A67736176650A3336203336203231362031393420626F787072696D20636C6970206E6577706174680A312031207365745F7363616C65203020726F74617465203430203430207472616E736C6174650A2520610A67736176650A31207365746C696E6577696474680A3020302030206E6F6465636F6C6F720A3130352E333339332038362E3337383820323720313820656C6C697073655F70617468207374726F6B650A3020302030206E6F6465636F6C6F720A3134202F54696D65732D526F6D616E207365745F666F6E740A3130302E383339332038322E36373838206D6F7665746F20392028612920616C69676E6564746578740A67726573746F72650A2520620A67736176650A31207365746C696E6577696474680A3020302030206E6F6465636F6C6F720A3135372E323031352032332E3833323120323720313820656C6C697073655F70617468207374726F6B650A3020302030206E6F6465636F6C6F720A3134202F54696D65732D526F6D616E207365745F666F6E740A3135322E323031352032302E31333231206D6F7665746F2031302028622920616C69676E6564746578740A67726573746F72650A2520612D3E620A67736176650A31207365746C696E6577696474680A30203020302065646765636F6C6F720A6E657770617468203131382E343236332037302E35393536206D6F7665746F0A3132342E313535382036332E36383537203133312E303034362035352E343236203133372E3334312034372E37383433206375727665746F0A7374726F6B650A30203020302065646765636F6C6F720A6E657770617468203134302E323439362034392E37353938206D6F7665746F0A3134332E393338332033392E38323738206C696E65746F0A3133342E3836312034352E32393137206C696E65746F0A636C6F7365706174682066696C6C0A31207365746C696E6577696474680A736F6C69640A30203020302065646765636F6C6F720A6E657770617468203134302E323439362034392E37353938206D6F7665746F0A3134332E393338332033392E38323738206C696E65746F0A3133342E3836312034352E32393137206C696E65746F0A636C6F736570617468207374726F6B650A67726573746F72650A2520630A67736176650A31207365746C696E6577696474680A3020302030206E6F6465636F6C6F720A36312E3538323720313820323720313820656C6C697073655F70617468207374726F6B650A3020302030206E6F6465636F6C6F720A3134202F54696D65732D526F6D616E207365745F666F6E740A35372E353832372031342E33206D6F7665746F20382028632920616C69676E6564746578740A67726573746F72650A2520612D3E630A67736176650A31207365746C696E6577696474680A30203020302065646765636F6C6F720A6E6577706174682039342E3532332036392E34373632206D6F7665746F0A38392E343839322036312E363039372038332E3339352035322E303836332037372E383234322034332E33383037206375727665746F0A7374726F6B650A30203020302065646765636F6C6F720A6E6577706174682038302E363132372034312E32343437206D6F7665746F0A37322E323734352033342E37303832206C696E65746F0A37342E373136352034352E30313738206C696E65746F0A636C6F7365706174682066696C6C0A31207365746C696E6577696474680A736F6C69640A30203020302065646765636F6C6F720A6E6577706174682038302E363132372034312E32343437206D6F7665746F0A37322E323734352033342E37303832206C696E65746F0A37342E373136352034352E30313738206C696E65746F0A636C6F736570617468207374726F6B650A67726573746F72650A2520640A67736176650A31207365746C696E6577696474680A3020302030206E6F6465636F6C6F720A3237203130372E3732323820323720313820656C6C697073655F70617468207374726F6B650A3020302030206E6F6465636F6C6F720A3134202F54696D65732D526F6D616E207365745F666F6E740A3232203130342E30323238206D6F7665746F2031302028642920616C69676E6564746578740A67726573746F72650A2520612D3E640A67736176650A31207365746C696E6577696474680A30203020302065646765636F6C6F720A6E6577706174682038302E3132312039332E32343937206D6F7665746F0A37342E333930322039342E383131312036382E3230312039362E343937342036322E313431372039382E31343833206375727665746F0A7374726F6B650A30203020302065646765636F6C6F720A6E6577706174682036302E383939322039342E38353931206D6F7665746F0A35322E313731203130302E38363438206C696E65746F0A36322E37333934203130312E36313239206C696E65746F0A636C6F7365706174682066696C6C0A31207365746C696E6577696474680A736F6C69640A30203020302065646765636F6C6F720A6E6577706174682036302E383939322039342E38353931206D6F7665746F0A35322E313731203130302E38363438206C696E65746F0A36322E37333934203130312E36313239206C696E65746F0A636C6F736570617468207374726F6B650A67726573746F72650A2520660A67736176650A31207365746C696E6577696474680A3020302030206E6F6465636F6C6F720A3138312E31323837203131352E3833363720323720313820656C6C697073655F70617468207374726F6B650A3020302030206E6F6465636F6C6F720A3134202F54696D65732D526F6D616E207365745F666F6E740A3137382E31323837203131322E31333637206D6F7665746F20362028662920616C69676E6564746578740A67726573746F72650A2520612D3E660A67736176650A31207365746C696E6577696474680A30203020302065646765636F6C6F720A6E657770617468203132382E393034312039352E353338206D6F7665746F0A3133342E383932352039372E38363536203134312E34343038203130302E34313038203134372E38313338203130322E38383739206375727665746F0A7374726F6B650A30203020302065646765636F6C6F720A6E657770617468203134362E39383938203130362E33323236206D6F7665746F0A3135372E35373835203130362E36383332206C696E65746F0A3134392E353235382039392E37393831206C696E65746F0A636C6F7365706174682066696C6C0A31207365746C696E6577696474680A736F6C69640A30203020302065646765636F6C6F720A6E657770617468203134362E39383938203130362E33323236206D6F7665746F0A3135372E35373835203130362E36383332206C696E65746F0A3134392E353235382039392E37393831206C696E65746F0A636C6F736570617468207374726F6B650A67726573746F72650A2520670A67736176650A31207365746C696E6577696474680A3020302030206E6F6465636F6C6F720A3130312E35303835203136372E3536343620323720313820656C6C697073655F70617468207374726F6B650A3020302030206E6F6465636F6C6F720A3134202F54696D65732D526F6D616E207365745F666F6E740A39362E35303835203136332E38363436206D6F7665746F2031302028672920616C69676E6564746578740A67726573746F72650A2520612D3E670A67736176650A31207365746C696E6577696474680A30203020302065646765636F6C6F720A6E657770617468203130342E34383931203130342E33393636206D6F7665746F0A3130342E30303634203131342E36323537203130332E33393135203132372E36353931203130322E38343536203133392E32323731206375727665746F0A7374726F6B650A30203020302065646765636F6C6F720A6E6577706174682039392E33343439203133392E31363236206D6F7665746F0A3130322E33363936203134392E33313635206C696E65746F0A3130362E33333731203133392E34393236206C696E65746F0A636C6F7365706174682066696C6C0A31207365746C696E6577696474680A736F6C69640A30203020302065646765636F6C6F720A6E6577706174682039392E33343439203133392E31363236206D6F7665746F0A3130322E33363936203134392E33313635206C696E65746F0A3130362E33333731203133392E34393236206C696E65746F0A636C6F736570617468207374726F6B650A67726573746F72650A656E64706167650A73686F77706167650A67726573746F72650A252550616765547261696C65720A2525456E64506167653A20310A2525547261696C65720A656E640A726573746F72650A2525454F460A>|ps>|400px|||>
    </unfolded-io>

    <\unfolded-io>
      twopi]\ 
    <|unfolded-io>
      %dot -width 300 -output png

      digraph G { a -\<gtr\> b; a -\<gtr\> c; a -\<gtr\> d; a -\<gtr\> f; a
      -\<gtr\> g }
    <|unfolded-io>
      <image|<tuple|<#89504E470D0A1A0A0000000D49484452000001D30000009B08060000003982711800000006624B474400FF00FF00FFA0BDA7930000200049444154789CEDDD79589465DB3FF0EF0C0303C822B8802CEE22ABB8A198BB0266824B6A8FB95B8AD9AFC06C214D0FD4CA4C3341AB27EB3513330D4D521EC585C705700B9554DC15059255501950D6397F7FF4C22B8A803033D7CC707E8EA37F80E6FECEB73B4EE69E7BAE4B424404C618638C35D40EA9E8048C31C698AEE361CA18638C35120F53C61863AC9164A20330C6FE51515181ECEC6C646767E3C18307A8A8A88042A1407979394C4D4D2197CB61626282E6CD9BA34D9B36B0B6B6161D9931F6BF789832A6618F1F3F466262222E5CB880E4E4645CBA7409B76EDD424E4E0E2A2A2AEAFD38C6C6C670707040D7AE5DE1EEEE0E373737F4ECD913AEAEAE9048246A7C068CB1A749F86E5EC6D44BA954E2F4E9D3D8B76F1F8E1E3D8AC4C444949494C0DADABA6A0876EDDA156DDAB4819D9D1D6C6C6C606D6D0DA9540A737373C864323C7AF408252525282E2E467E7E3E32323290999989F4F4745CBE7C19972E5DC2952B57505A5A8A56AD5A61E0C081183A7428468F1E8DB66DDB8AAE80317DB7838729636A72FCF8716CDDBA15BB77EF464646063A75EA8421438660F0E0C1183C78B0CA875C797939FEFAEB2FC4C5C5E1D8B1633876EC180A0A0AD0AB572F8C1F3F1ED3A74F879D9D9D4A8FC91803C0C39431D52A2C2C44444404BEFFFE7B5CBC7811DDBA75C3F8F1E3316EDC3878787868344B6969290E1F3E8CA8A828ECDAB50B0F1E3C40404000E6CD9B075F5F5F8D66614CCFF130654C150A0B0BB171E346AC5CB9B26A68050606C2C7C747743400FF0CD6DDBB77E3871F7EC07FFFFB5F78787860F1E2C598306102BFBFCA58E3F13065AC31944A25366CD880254B96A0ACAC0C41414178EFBDF7B4FA4EDB73E7CE61D9B265888E8E86979717BEF9E61B787979898EC5982EE31590186BA873E7CEC1DBDB1BC1C1C198356B166EDFBE8D4F3FFD54AB072900F4ECD913BB77EFC6D9B367616A6A0A6F6F6FCC9B370F0F1E3C101D8D319DC5C394B117444458B56A15BCBDBD61626282A4A424AC5EBD5AEB87E8D37AF4E881C3870F63F3E6CDF8E38F3FD0BD7B779C387142742CC674120F53C65EC0FDFBF7F1F2CB2F63F1E2C5F8FCF3CF71F4E851B8B9B9898ED56012890453A74EC5C58B17E1EEEE8EC1830763F5EAD5A26331A67378D106C6EA293D3D1D23478E444141018E1F3FAE57EF33B66CD912D1D1D158BB762D3EFAE823DCBE7D1BEBD7AF87818181E8688CE9041EA68CD5C3CD9B373174E850585959E1E4C993B0B7B7171D49E5241209162C58808E1D3B62F2E4C9C8CDCDC5B66DDB2093F1AF09C6EAC2977919AB43666626468C18013B3B3BC4C5C5E9E5207DD2D8B16371E0C001ECDBB70F73E7CE05DFF0CF58DD789832568B478F1E61E4C891303232C2DEBD7BD1BC7973D1913462E0C081D8B16307B66CD98265CB96898EC398D6E361CA582DDE7FFF7DA4A5A561FFFEFD68D9B2A5E8381AF5CA2BAF60FDFAF5F8F4D34F71F4E851D17118D36ABC680363CF111D1D8D3163C660C78E1D183F7EBCE838C24C9C3811A74E9DC2C58B179BCC2B73C65E10AF80C4584D4A4B4BE1EAEA0A6F6F6FFCF2CB2FA2E30875FFFE7D74EDDA153367CEC4AA55AB44C7614C1BF10A488CD5E4BBEFBE43464606BEF8E20BD15184B3B2B2C292254BB07EFD7AA4A6A68A8EC39856E261CAD853944A25D6AE5D8B79F3E6C1D1D151741CAD3077EE5CB46EDD1ADF7EFBADE8288C69251EA68C3D253636166969699833678EE8285AC3C8C808B366CD42444404CACACA44C7614CEBF03065EC29DBB76F47BF7EFDE0ECEC2C3A8A5699356B1672727270E4C811D15118D33A3C4C197B4A7C7CBCB0CDB3CBCBCBF1DB6FBFC1D7D717B6B6B630313181878707C2C3C3A1542A8564AAD4AE5D3B74EEDC19090909427330A68D789832F6847BF7EEE1D6AD5BE8D7AF9F90E3EFDFBF1F93264DC2B061C370E5CA15A4A7A7233030100B162C40484888904C4F7AE9A59770F2E449D13118D33A3C4C197B426A6A2A88085DBB76159661C8902158B87021ACACACD0B2654BBCFBEEBB983C7932C2C3C3515050202C1700383939E1CE9D3B423330A68D789832F6847BF7EE01005AB46821E4F8FEFEFE35BE27E9E9E989B2B2325CBA744940AAFFD3A2450BE4E5E509CDC09836E2ED20187BC2E3C78F0100262626428EFFF0E143AC59B306515151F8FBEFBFF1E0C1836ADF7FF4E891905C95CCCCCC50545424340363DA885F9932F6042B2B2B00FFACFA23424040003EFDF453CC993307D7AF5F8752A9041161EDDAB500207C0797BCBC3C585B5B0BCDC09836E261CAD8132A2FEFE6E6E66AFCD8151515387EFC386C6D6D1114148456AD5A41229100F8BF57CCA2E5E6E60ABB04CE9836E361CAD813BA74E90263636324252569FCD806060618326408B2B2B2B07AF56ADCBB770F8F1F3FC6912347F0FDF7DF6B3C4F4DCE9D3B070F0F0FD13118D33A3C4C197B825C2E478F1E3D70E2C40921C7FFEDB7DF3077EE5CAC5FBF1E767676E8D0A1032222223079F2640080AFAF2F7AF7EE2D241B11E1D4A953C23E36C49836E35D63187BCA92254BF0F3CF3FE3CE9D3B303030101D476B1C3B760C43860CC1C58B17E1EEEE2E3A0E63DA84778D61EC69B366CDC2DDBB7771E8D021D151B4CAC68D1BE1E5E5C58394B11AF03065EC291D3B76C4A04183AAEEA065C0DF7FFF8D9D3B7762F6ECD9A2A330A695F8322F6335888B8BC3E0C18371E0C001F8F9F9898E23DCAC59B370F4E8515CBD7A1572B95C741CC6B4CD0E1EA68C3DC7E8D1A3919292823367CEC0D8D858741C614E9D3A8501030654BB118A31560D0F53C69E273D3D1D9E9E9E983A752AD6AD5B273A8E10858585E8D9B3273A76EC88989898AACFBD32C6AAE11B90187B1E4747477CF7DD77F8E69B6FF0DB6FBF898EA3714AA5123366CC8042A1C0E6CD9B799032560B5E9B97B15A4C9A3409A74F9FC68C1933D0B2654B0C1F3E5C74248D79E79D77B06FDF3E1C3C7810363636A2E330A6D5F89529637558B3660D264C988071E3C6D5B8A38BBE21227CF0C107F8E1871FB06DDB360C1C38507424C6B41E0F53C6EA20954AB169D3268C1A350A23478EC4F6EDDB4547529BD2D2524C993205EBD7AF47444404C68E1D2B3A12633A81872963F5909F9F8FB66DDB422A9562F2E4C9F8F8E38F515656263A964AA5A6A662E8D0A1F8E38F3FD0BC7973E4E6E66ACD02FB8C693B1EA68CD5E2F6EDDB983B772EDAB66D8B6DDBB661D5AA55F8F7BFFF8D6FBEF90683060DC2AD5BB7444754899D3B77A2478F1E78F8F021F6ECD983091326E0E38F3F46972E5D101616267C1F55C6B41E31C69E71EBD62D0A0C0C24994C46EDDBB7A7B0B0307AFCF871D5F72F5FBE4C9E9E9E64626242CB972FA7E2E26281691B2E252585FCFDFD0900050606D2A3478FAABE979D9D4DA1A1A1646161412D5BB6A4D0D050BA7FFFBEC0B48C69AD481EA68C3D21393999A64D9B4632998C3A76EC481B366CA0B2B2B21A7FB6B4B49456AD5A45666666D4B97367DAB2650B9597976B3871C3E4E4E45048480899989890ABAB2B1D3972E4B93F9B9B9B4BA1A1A1D4BC7973B2B0B0A0909010CACBCBD35C58C6B41F0F53C68888CE9F3F4FD3A64D23030303727777A7CD9B37D77B30A6A7A7D38C193348269351D7AE5D69D3A64DD55EC56A93B4B434FAF0C30FC9CCCC8C5AB76E4D6BD7AEA5D2D2D27AFDBB0F1F3EA4952B5792B5B53599999951505010656666AA3931633A8187296BDA4E9C3841FEFEFE249148C8D3D393366FDE4C1515150D7AAC1B376ED0840913482A9592959515CD9F3F9F929393559CF8C59596965274743405040490542A255353535AB56A1515151535E8F1140A05858585519B366DA859B366141414447FFFFDB78A5333A65322F90624D624252424202020002FBDF412F2F3F3B17BF76E24252561FAF4E9904A1BF6BF854C26C3D9B367E1EAEA8AB7DF7E1BBB77EF86BBBB3B5C5C5CB078F1629C3973061515152A7E2635532814D8B3670F66CE9C095B5B5B8C1E3D1A8F1E3D42686828A45229FEFCF34F181A1A36E8B1CDCCCC101C1C8C1B376EE0F3CF3FC7EFBFFF8E8E1D3B62FAF4E97A734316632F4CF438674C93E2E3E369D8B0610480FAF7EF4F7BF6EC51C9E35EBD7A95ECEDEDA967CF9E74EFDE3D2222AAA8A8A0B8B8389A3F7F3EB56BD78E0090A5A5258D1A358ABEF8E20B3A70E000DDBD7BB7D1C72E2B2BA3CB972F536464242D58B080BCBCBC48269391542AA5FEFDFBD39A356BE8F6EDDB553F1F1F1F4F161616346AD428955C8E2E2929A1CD9B3753E7CE9DC9D0D090A64D9B46D7AE5D6BF4E332A6432279A17BD624C4C6C662F1E2C5387DFA34FAF7EF8FE5CB9763D8B0612A79EC2B57AEC0C7C707F6F6F6D8BF7F3FACADAD6BFCB9E4E4641C3B760C7171714848484046460600C0DADA1A4E4E4EB0B5B585A3A3235AB76E0D4B4B4BC8E572989A9A422E9743A150A0BCBC1C0A8502050505484F4F47767636D2D2D270FDFA75949696422693C1C5C50583070FC6A041833068D0A0E72E0378E6CC198C1831027DFAF4C1AE5DBB606262D2E81ECACACAB06DDB36AC58B102376EDCC0F8F1E3B16CD932B8B8B834FAB119D372BC6B0CD35F4AA5127BF7EEC5B265CB70EEDC398C1A350A4B962C419F3E7D54768CBFFEFA0B7E7E7E707676C6DEBD7B616E6E5EEF7F372F2F0F172F5EC4A54B9770F3E64D646565E1EEDDBBC8CECE464141014A4A4A50585888B2B232989999C1D0D010E6E6E6B0B0B080BDBD3D6C6D6DE1E0E000676767B8B9B9C1D5D5F585F61A3D77EE1CFCFCFCE0EEEE8EFFFCE73F3033336B4805CF502A95F8FDF7DF111A1A8A6BD7AEE195575EC1D2A54BD1AB572F953C3E635A68075FE6657AA7A2A282222323C9C5C585A45229F9FBFBD3993367547E9CB367CF528B162D68F0E0C1A4502854FEF84444BFFDF61B418DEFC624252551AB56AD68C08001545050A0D2C7AEA8A8A03D7BF650EFDEBD49229190BFBF3F9D3E7D5AA5C7604C4BF00D484C7F949595212222022E2E2E98346912DCDDDD71E9D225444747ABFC55D1993367E0EBEB0B2F2F2FC4C4C4A8EC559DA675EFDE1D717171484949C1B061C3909F9FAFB2C7964AA5080808406262220E1E3C88DCDC5CF4EDDB1703060CC0E1C38755761CC6B4010F53A6F34A4B4BAB86E8ECD9B3D1B76F5F5CB9720591919170767656F9F1121212306CD830F4EBD70F5151512A79BF51246767671C397204595959F0F5F5455E5E9ECA8FE1E3E38353A74E213E3E1EC6C6C6183E7C38060C1880E8E868951F8B31117898329D55545484F0F07074ECD81173E6CCC1F0E1C371EBD62D444444C0C9C9492DC73C76EC18468E1C89112346202A2A0AC6C6C66A398EA6393939213E3E1EF7EFDF878F8F0F727373D5729C01030620363616F1F1F1B0B2B2C2E8D1A3D1BF7F7F44474783F8F60DA6C37898329D53585888F0F07074E9D2059F7CF209C68F1F8FDBB76F63C3860D70747454DB71F7EFDF8F912347C2DFDF1FDBB66D6BF0E734B555FBF6ED71F4E85114161662F0E0C155771BAB43E5ABD273E7CEC1DEDE1E63C68C418F1E3D10111101A552A9B6E332A62E3C4C99CE282828C0975F7E8976EDDA61C99225983871226EDEBC89F0F070D8D9D9A9F5D87BF7EEC5B871E3306EDC386CD9B20532994CADC713A56DDBB6888F8F874422C1B061C370F7EE5DB51EAF478F1E888C8CC45F7FFD856EDDBAE18D37DE80A7A72722222234B6C00563AAC0C39469BD7BF7EE61E9D2A568D7AE1D56AC58813973E620353515E1E1E1B0B5B555FBF177EEDC8971E3C661DAB4697A3D482BD9DADAE2F0E1C3303434C480010370FBF66DB51FB35BB76E888888C0F9F3E7D1A3470FBCF9E69B707272C20F3FFC80F2F272B51F9FB1C6E261CAB4564E4E0E3EFEF863B46BD70EDF7DF71D82838391969686952B57C2CACA4A23197EFBED37BCFEFAEB78F3CD37B161C386062F35A86B6C6C6CF0DFFFFE1716161618326488C6960974737343444404AE5FBF0E1F1F1FBCF3CE3BE8D2A50BC2C3C3515C5CAC910C8C3588E80FE730F6B4D4D4540A0A0A22131313B2B1B1A1952B57367851F6C6D8BA752BC96432FAE0830F347EEC4AEAFE9C695DF2F3F3A94F9F3EE4E8E848D7AF5FD7F8F1EFDCB943414141646C6C5C752E3CB9E72A635A82778D61DA23252585828282482E9753BB76ED282C2C4CD82FCE1F7EF881A4522985848408397E25D1C39488E8C18307E4EDED4D36363674F1E2452119B2B2B2282424844C4D4DA955AB56141A1A4A0F1E3C109285B11AF03065E2DDBC799302030349269351870E1D282C2C8C8A8B8B85E5F9F7BFFFAD158394483B862911516161210D1D3A945AB76E4DE7CF9F179623272787424343C9D2D2925AB46841A1A1A1949F9F2F2C0F63FF8B872913E7C2850B551B72BBB9B9D1E6CD9BA9ACAC4C68A6AFBEFA8A00D0A79F7E2A3447256D19A64444454545E4E3E343565656C29705BC77EF1E85868692959515999B9B53484808E5E5E509CDC49A341EA64CF392929268E2C489249148C8C3C383366FDE4CE5E5E5A263D1CA952B492291D0DAB56B4547A9A24DC39488E8D1A347E4E7E747CD9B37A793274F8A8E4305050514161646B6B6B6646666464141412AD9D68EB117C4C394694E424202F9FBFB934422A1EEDDBB5364642429954AD1B188E8FF06E9BA75EB4447A946DB8629D13FFB978E193386CCCCCCE8C89123A2E310D13F97A1C3C2C2C8CECE8EE47239050606527A7ABAE858ACE9E061CAD42F3E3E9EFCFDFD55BE21B7AA2C5EBC98A452296DDCB85174946768E33025FA67A0BEFAEAABD4AC59338A8D8D151DA74A7171316DD8B0811C1D1DC9C8C888A64D9B46376EDC101D8BE93F1EA64C7D0E1D3A44DEDEDE5543549B7EE9121129954A9A3F7F3E191818D0CF3FFF2C3A4E8DB475981211959797D3D4A953C9D4D4940E1C38203A4E35252525B479F366EAD2A50B191A1AD2B469D3E8EAD5ABA26331FDC55BB031D52222444747A34F9F3EF0F5F5859999194E9E3C898484040C1F3E5C74BC2A4484E0E060AC5FBF1E3FFFFC3366CC98213A92CE313030C0CF3FFF8C89132722202000BB77EF161DA98A919111A64F9F8EAB57AF62EBD6AD484C4C84ABAB2B020202909494243A1ED3433C4C994A28954A444747A377EFDE1833660C6C6C6C9098988843870EC1DBDB5B74BC6A944A2566CF9E8D0D1B3660C78E1D983A75AAE8483ACBC0C0009B366DC2ECD9B3F1DA6BAF61D7AE5DA2235523954A3171E2445CBA74097FFCF107323232D0AB57AFAA7D561953151EA6AC512A37E4767373C3D8B16361676787B367CF560D566D5351518137DE78035BB76EC58E1D3B306EDC38D191749E4422C137DF7C83B7DE7A0BAFBDF61A7EF9E517D1919E51B951F9993367B07BF76E646767575D3D3975EA94E8784C0FF030650D52B921B79B9B1B66CF9E0D2F2F2F5CBE7C19D1D1D1E8D1A387E87835AAA8A8C0CC9933B163C70E44474763F4E8D1A223E90D894482B0B03004050561E6CC99D8BC79B3E84835924824080808C09F7FFE8943870EA1A8A808FDFAF5E38DCA59A3F130652FA4A4A4043FFCF0033A75EA843973E6C0DBDB1B972F5F46444404BA76ED2A3ADE73959696E2B5D75E43545414A2A3A3E1EBEB2B3A92DE914824F8FAEBAFB168D122BCF1C61BF8E9A79F4447AA958F8F0F4E9C38516DA3721EAAACC144DF02C574832E7F8EAFF2739196969674FCF871D1715E8836DFCD5B1B6DFDDC6E6DB4F973D04CEBF1476358ED2A5798B1B1B1A95A612623234374AC7A2B2A2AD2AA157B5E94AE0E5322A22FBFFC52EB5694AA8FBFFEFA4B2B57E8625A8D8729AB993EAC7D5A585848C3870F272B2B2BFAF3CF3F45C769105D1EA644FFAC752C9148B466ADE31771F1E2C5AAB5A35D5D5DB562ED68A6B57898B2EA9EDC95A365CB96141A1A4AF7EFDF171DEB8529140A1A326488F05D4E1A4BD787299176EDC2D310DAB6AB11D34A3C4CD93F9EDC2FB275EBD6141A1A4A0F1F3E141DAB41EEDFBF4FDEDEDE646B6B2B6CFF4D55D187614A44F4E38F3FEAF4402522BA7DFB76D546E56DDBB615BADF2ED33A3C4C9BBA3B77EE54FD82707474D4F95F10F9F9F9E4E5E5458E8E8E74FDFA75D1711A4D5F862911D1D6AD5B492693D1FBEFBF2F3A4AA3A4A6A65250501099989850EBD6AD69E5CA95545454243A16138B87695375EBD6ADAA4B57EDDBB7A7B0B0307AFCF8B1E8588D929D9D4DDDBA75A376EDDAD1CD9B3745C751097D1AA64444DBB76F274343437AEBADB7A8A2A242749C46C9CECEA6D0D050B2B0B0D0E9B744984AF0306D6A92939369DAB4692493C9A863C78EB461C306BDB8A9222B2B8BDCDDDDA943870E949292223A8ECAE8DB302522DAB3670FC9E5729A33678ECE0F5422A2DCDC5C0A0D0DA5E6CD9B938585854EDEACC71A8D17BA6F2A2E5CB880E9D3A7C3D3D313494949D8B87123AE5FBF8EC0C040C86432D1F11A253D3D1D03070E44595919E2E3E3D1A14307D191582D020202B06BD72E6CD9B205D3A64D437979B9E8488DD2B2654B2C5DBA14A9A9A958B468117EFCF147B46BD70EC1C1C1C8CACA121D8F69080F533D77F2E449040404A07BF7EEB870E1027EFAE9279C3F7F1ED3A74F87818181E8788D96969686A14387422693E1C89123B0B7B7171D89D5C32BAFBC82A8A82844454561EAD4A93A3F5001C0C2C202212121484D4DC5679F7D861D3B76A073E7CE080E0EC6DDBB7745C7636AC6C3544F252424202020002FBDF412F2F3F3B17BF76E24252561FAF4E9904AF5E33FFB9D3B773064C810989B9B232E2E0E6DDAB4111D89BD80975F7E19FBF7EFC7DEBD7BF1FAEBAFA3ACAC4C742495303333437070306EDCB881CF3FFF1CBFFFFE3B3A76EC88E9D3A7E3D6AD5BA2E33135D18FDFAAAC4AE5BEA103070EC4FDFBF7B167CF1E1C3F7E1C010101904824A2E3A9CCB56BD73060C000585B5B233636162D5BB6141D8935C0A041831013138383070F62DCB871282E2E161D49659A356B86E0E060A4A4A4E0C71F7FC4C99327E1E2E282E9D3A7E3FAF5EBA2E33115931011890EC11A2F3636168B172FC6E9D3A7D1BF7F7F2C5FBE1CC3860D131D4B2DAE5CB9021F1F1FB46FDF1E313131B0B0B0101D4925323232E0EFEF5FED159A42A1406666269C9C9CAAFD6C8F1E3D101111A1E9886A73E6CC198C1831027DFAF4C1AE5DBB606262223A92CA95959561DBB66D58B162056EDCB881F1E3C763D9B265707171111D8D35DE0EFDBA4DB089A9A8A8A03D7BF650AF5EBD48229190BFBF3F9D3E7D5A742CB54A4A4AA256AD5AD1C08103A9A0A040741C95737373230075FEF3D9679F898EAA7267CF9EA5162D5AD0E0C18349A150888EA336151515141919492E2E2E24954AC9DFDF9FCE9C39233A166B1CBE9B571729954AECD8B103EEEEEE183B762CDAB46983C4C444444747A34F9F3EA2E3A9CDB973E7E0E3E303575757ECDBB70FE6E6E6A223A9DCF4E9D3EBBCBB5A229160F2E4C91A4AA4393D7BF6446C6C2C2E5FBE8C91234742A150888EA41652A91413274E44727232FEF8E30F646565C1CBCBAB6A9F55A69B7898EA90B2B232444444C0C5C50593264D82BBBB3B2E5DBA84E8E868F4EAD54B743CB53A73E60C7C7D7DE1E5E585989818989999898EA416AFBFFE3A2A2A2A9EFB7D8944825EBD7AE9EDC77FBA77EF8EB8B838A4A4A460D8B061C8CFCF171D496DA452290202029098988883070F223737177DFBF6C580010370F8F061D1F1D80BE261AA034A4B4BAB86E8ECD9B3D1B76F5F5CB97205919191707676161D4F25727373F1CE3BEF40A9543EF3BDF8F8780C1B360CFDFAF5435454945EBE9F56C9D1D1117DFBF67DEE1DD7060606983E7DBA86536996B3B3330E1F3E8CACAC2CF8FAFA222F2FEF999FB97BF72E82838305A4530F1F1F1F9C3A750AF1F1F1303636C6F0E1C379A3725D23FA42337BBECA0DB9EDEDEDC9C8C888020303292D2D4D742CB5F8F0C30F0900CD9933A7DA86CC478F1E253333339A3871229596960A4CA839DF7EFB2D191818D4F85EA9542AA5ACAC2CD11135E2F6EDDBD4A14307EADEBD3BE5E4E4547D3D3333933A76EC480074766BBDBAC4C7C793BFBF3F01A0975E7A89F6ECD9C31B956B375E4E501B29140A0A0B0BA3366DDA50B366CD28282888EEDEBD2B3A96DAE4E4E490B1B171D5B0F87FFFEFFF9152A9A4989818323131A1499326E9C59287F5959B9B5BE330353030A061C386898EA751A9A9A9D4A95327727171A1BB77EF524E4E0E39393991A1A121C964327AF9E597454754AB73E7CE556D54EEE9E9499B376FD68B2518F5100F536DF2F0E1435AB97225595B5B93B9B939050505516666A6E8586AF7D1471F914C26ABF6EA6BCC9831646C6C4C53A64C695283B4929F9FDF3303D5C0C080366DDA243A9AC665646490ABAB2B75E9D2855C5C5CC8D0D0B05A2FFAFAEAF449E7CF9FAFDAA8DCDDDD9D366FDE4CE5E5E5A263B1FFC3C3541BD4B450767E7EBEE8581A71EFDE3D32313179E65558E55FE24DF5AFF0888808924AA5D53A3134346CB2BB925CBD7A95CCCCCCAAFDD105806432198D1C3952743C8DD1D78D2AF4000F5391B2B3B3AB36E46ED5AA15858686D283070F44C7D2A8909090677E413E3950972D5B263AA2100505052497CBAB0D8DB163C78A8E2544616121F5EBD7EF9957A44DEDD5E993525252283030900C0D0DF5660B451DC7C35484273717B6B1B169B29B0B3FEF55E9D303F5F3CF3F171D5588091326540D108944423B77EE141D49E38A8A8A68C08001CFFD83ABF20F8D575E7945745421EEDCB943414141646C6C5CF5BBE4D1A347A26335453C4C3529252585828282482E9753BB76ED282C2CAC499FF8212121B5BEDA78F29FAFBFFE5A745C8D8B8A8A2289444200C8D4D4B4C99D2B8F1E3DA2214386D4EBFC9048244D7A15A1ACACAC267F954B305E01A9A18808F3E7CF477272729D3F7BEBD62DCC9D3B174E4E4E888E8EC6975F7E896BD7AE21383858AF3F33599B7BF7EE61DDBA75B5EE1452B9459C3E2F52509B912347A259B3660080F1E3C737B973A5BCBC1C23468C40CB962D61606050EB6E4706060658B2648906D369171B1B1BAC5CB91277EEDCC1DB6FBF8DB0B03074EAD4094B972EC5FDFBF7EBFCF757AD5A85D8D8580D24D55F5AB5D07D454505B2B3B3919D9D8D070F1EA0A2A2020A8502E5E5E5303535855C2E878989099A376F8E366DDAC0DADA5A58D6F9F3E7233C3C1CAFBFFE3A7EFDF5D71A7FE6E2C58B58BD7A357EFDF557383B3BE3A38F3EC2E4C993B576336E4DF6BF70E142AC59B3A6C6612A93C9505E5E0E6F6F6F2C5AB4080101018D795A3AA3A6FEBFF8E20B1C3E7C18CB972F47BF7EFDB4E6FCD7A4D2D2526CDFBE1DCB972F474A4A0AA452E9735789FAF3CF3FE1E5E5D5A0E3E8D2EF9FBAE4E5E561FDFAF558B76E1DCACBCBF1F6DB6FE3A38F3EAA31B342A1808383038A8B8B111313236C830C1DEF7F879061FAF8F163242626E2C2850B484E4EC6A54B9770EBD62DE4E4E4D4BA94DAD38C8D8DE1E0E080AE5DBBC2DDDD1D6E6E6EE8CE181F2C0000125249444154D9B3275C5D5DD5BADDD8FBEFBF8FB0B03028954A48A5525CBB760D9D3B77AEFAFE5F7FFD85152B5660E7CE9D707777C7071F7C802953A668CD66DCA2FBCFCBCB83A3A3231E3F7E5CEDEB868686282F2FC7C89123B16CD932F4EEDDBBC1CF519B89EE5F5729954AECDDBB17CB962DC3D9B367ABFEE8AA64686888112346D4B96A5053EA5FA150E0A79F7EC2CA952B5158588837DE7803212121B0B3B3ABFA992FBFFC128B172F8652A984A1A1216262623074E850B565D2D3FE35334C954A254E9F3E8D7DFBF6E1E8D1A3484C4C44494909ACADADAB4AE8DAB52BDAB469033B3B3BD8D8D8C0DADA1A52A914E6E6E690C96478F4E8114A4A4A505C5C8CFCFC7C64646420333313E9E9E9B87CF9322E5DBA842B57AEA0B4B414AD5AB5C2C081033174E8508C1E3D1A6DDBB655D97359B4681156AE5C89CADA0C0D0D3165CA146CDAB409C78F1FC7CA952BB177EF5E787A7A62D1A24598306182F0FFB1B4ADFF458B1661F5EAD555BF08653219241209264D9A84254B96A04B972E226A529BC6F4DFAC5933AC59B306C1C1C15A71FE6B8B8484047CFEF9E73870E000643259B52B1C4FBF3AD5B6F35F84A2A222FCCFFFFC0F56AD5A85BCBC3CCC9831034B962C81B5B5351C1C1CAA2E054BA552181A1A62DFBE7D2A7B85DA44FA57EF166C090909346FDE3CB2B3B32300D4A953277AF3CD3729222282525353557EBCB2B2324A4C4CA4356BD6D0E8D1A3C9D2D292241209F5EEDD9BBEF8E28B46AF22B468D1A2AA1B429EFCC7C0C080FAF6ED4B0068D0A04174F0E041153DA3C6D1C6FE9FBC83D7C0C0802C2D2D69E9D2A574EFDE3D95E7114D55FDD7F77384EA3EFFB551525212FDEB5FFF22030383AA9BD9468D1A4544DA79FE8BF6E8D1230A0F0F2707070792CBE5F4F2CB2F3FB33888542A25B95C4E870F1F6ED4B19A58FFAABF9B57A150D0B7DF7E4B1E1E1E0480BA75EB46CB962DA30B172EA8FA50752A2929A19898180A0C0CA4962D5B924C26A371E3C63568D87DF2C927350E52FCEF87E9BB77EF4EC78E1D53C3B37831DADEBF93931301207B7B7B5AB76E9DDE7D2448DBFB6FE8F9AFED525252E8EDB7DFAEFA6C6EE7CE9DB9FF5A141717D337DF7C43161616CF5D03BA2103B5099FFFAA1BA695EBC9DADADA92B1B1314D9C38910E1D3AA4AA876FB49292128A8C8C241F1F1F924824D4AD5B378A8C8CACD7E2D18B172F7EEE207D72A0FEFDF7DF1A782635D385FE376EDC48CD9B37278944421E1E1EF5EE5F17E842FF0D3DFF754165FFAD5BB726994C46EDDBB7E7FEEBF0EDB7DF3EB3CA564D03F5C89123753E169FFF2A18A6151515F4DD77DF518B162DC8C2C282162F5E4C797979AA08A73667CF9EA5D1A347934422A13E7DFAD4BA7ACA92254BEA1CA495C374FEFCF91A7C16FFD0A5FE8B8A8A48A954BE50FFDA4E97FAAFD414FA2F2C2C141DEDB9B4A1FFD2D252B2B7B7AFF3779B542A256363633A7AF4688D8FC3E77F95C60DD3B367CF92979717191A1AD2071F7CA0F5253EEDDCB9733464C810924AA5F4D65B6F3DB3EE697D0769E53F72B99CB2B3B335965FDFFBD776DCBF58DC7FC3FDF4D34FB5BE2A7D7AA09A9898D0F1E3C7AB3D06F75F4DC386A952A9A42FBFFC920C0D0D69D0A041949C9CDC98104229954ADAB2650BD9DADA52BB76EDAA4E98D0D0D07ABF2295CBE55527E6471F7DA491CCFADEBF36E3FEC5E2FE1BA7BCBCBCEA3D65994C4672B9FCB9FBE73E7993A5A9A9299D387182FBAFD98B0FD3FCFC7CF2F3F3234343435AB56A95DEBCE7929B9B4BA3468D22994C467E7E7E5527919191D133EB829A989850C78E1DC9CFCF8FE6CE9D4B9F7DF619454444D0B163C7D47297DA939A42FFAB56AD121DE7B9B87FB1B8FFC62B2B2BA3E4E464DABB772F7DFFFDF7F4C9279FD0B469D3A87FFFFEE4E0E050EDF79D442221B95C5E756397A9A929F5EDDB97FB7FD68B0DD3B4B434727373234747479D7E9FE579944A258D1A358A00908D8D0D4D993285162E5C48DF7DF71D454747D3850B17845E0A6B0AFDAF59B3860C0C0C68DEBC795AB75F23F72F16F7AFB91C77EFDEA593274F52646424AD59B386828383C9CFCF8F8C8D8D492693E9E5BEBA8DECBFFEC3F4C68D1BE4E0E0401E1E1E42EF5A55B7F2F2728A8A8A221313139A306182D6EC15D854FA2722EE5F30EE5F2C5DE85FDBFED052A506F65FBF619A9191411D3B76A43E7DFAE8DC4D0A0D15171747A6A6A6F4C61B6F08BF94C1FD73FF9AC6FD8BC5FD8BD580FEEB1EA6454545E4E9E949CECECE949B9BDBF8943A64EFDEBD64686848A1A1A1C23270FFDCBF28DCBF58DCBF582FD87FDDC3F4ADB7DE222B2B2BBA73E74EA3C3E9A2EFBFFF9EA45269BD3EB8AC0EDC3FF72F12F72F16F72FD60BF45FFB30DDB3670F492412DAB973A7CAC2E9A209132690838383C62F7170FFFFE0FEC5E2FEC5E2FEC5AA67FFCF1FA6252525D4A953279A32658AEAD33DC7EAD5ABAB6EC9B6B7B7D7D871EB929F9F4FAD5AB5A20F3FFC5063C714D1BFB66AEAFD6FDBB6ADDAC2209AD694FBDFBE7D3B797A7A92B1B171D57F838B172F6A344353EE5F1BD4B3FFE70FD3B56BD792898909A5A5A5A93E5D1D3C3D3DB56A981211AD5BB78E8C8D8D3576B94364FFDA88FB271A3E7CB890614AD434FB4F4848208944421F7EF82129140ABA79F326393838687C981235CDFEB5493DFAAF799856545450DBB66D69C18205EA4B570B6D1CA6252525D4B66D5B8DFC7528BA7F6DC4FD8B1DA64DB1FFE0E06002A0151FC5698AFD6B937AF41F297D768F53203636166969699833674E4DDF6E928C8C8C306BD62C44444454DB88581DB8FF6771FF6235C5FED3D3D301002D5AB4109A03689AFD6B93FAF45FE330DDBE7D3BFAF5EB07676767B506D435B366CD424E4E0E8E1C39A2D6E370FF35E3FEC56A6AFD575454083DFED39A5AFFDAA6AEFE6B1CA6F1F1F1F0F5F5556BB0FAB87AF52A468D1A054B4B4B989A9A62E8D0A1387EFCB8B03CEDDAB543E7CE9D919090A0D6E36843FF79797958B060013A75EA04B95C0E070707F8F8F8E0E79F7FC6E3C78F85646A2AFD5FBD7A1563C78E85A5A5259A356B86810307AAFD39D74753E9FF8F3FFE804422C1EEDDBB0100262626904824F0F6F6169609683AFD3F79FE9B9A9AA24F9F3EF8CF7FFE031F1F1F482412482412CC9E3D5BE3B9EAECFFE90BBFB9B9B924914828262646BD17A16BE1E9E9499696963474E8504A484820854241898989D4AD5B373232327AEEDE7A9A3063C60CF2F1F151DBE36B43FF999999D4A14307B2B5B5A5E8E8682A2828A0ACAC2CFAF4D34F0900AD5DBB5658367DEFFFC68D1BD4BC7973B2B7B7A783070F9242A1A00B172E909F9F1FB56FDF5ED87BA695F4BDFF278D19338600D0E3C78F4547A9A2EFFDD774FE272727938F8F0FB56AD54A9BCFFF67DF334D4D4D0511A16BD7AEEA1DF37578F8F02156AC5881FEFDFBC3CCCC0CBD7BF7C62FBFFC82D2D2520407070BCBE5E4E4843B77EEA8EDF1B5A1FF850B17E2F6EDDB080F0F87BFBF3FCCCDCD61636383C58B17E3E5975F16960BD0FFFE172D5A84070F1E203C3C1CBEBEBE30333383878707366DDA84CCCC4C21999EA4EFFD6B3B7DEFBFA6F3DFCDCD0DBFFEFA2B8A8A8A84647A526DFDCB9EFEC2BD7BF700887FD3DDD8D8187DFBF6ADF6350F0F0FD8D9D9E1FCF9F3C8CCCC449B366D349EAB458B16C8CBCB53DBE36B43FF51515100809123473EF3BD9898184DC7A946DFFBDFBF7F3F0060C48811D5BE6E6767072727275CBF7E5D44AC2AFADEBFB6D3F7FE9F77FEB76AD50ACECECEB874E9928858556AEBFF9957A695EF87999898A837551D5AB468018944F2CCD75BB76E0D00C8C9C9D1742400809999995AFF4212DD7F4949091E3E7C08636363989B9B0BC9501B7DEEBFA4A4040A8502C6C6C63033337BE6FB95E7BE48FADCBF2ED0E7FEEB3AFFADACAC349EE969B5F5FFCC30AD0C7CFFFE7DF5A6AAC3C3870F6BFC7AE51015F58B252F2F0FD6D6D66A7B7CD1FDCBE572585A5AA2B8B8180A85424886DAE873FF72B91CE6E6E6282E2E466161E133DFCFCFCFD778A6A7E973FFBA409FFBAFEBFC17F502EA49B5F5FFCC30AD7C799F9B9BABDE5475282C2CC4F9F3E7AB7DEDE2C58BC8C8C880A7A7A7904BBCC03FBDA8F3128836F43F6EDC3800C0BE7DFB9EF95E8F1E3DF0DE7BEF693A52157DEFBFF2D27AE5E5AE4AF7EEDDC3B56BD74444AA46DFFBD776FADEFFF3CEFFACAC2CE16F7100B5F7FFCC30EDD2A50B8C8D8D919494A4F660B569D6AC19DE79E71D9C3E7D1A4545453873E60CA64E9D0A2323238487870BCB75EEDC39787878A8EDF1B5A1FF2FBEF8021D3A74C07BEFBD87BD7BF742A150E0EFBFFFC6DB6FBF8DCCCC4CA1C354DFFB5FB16205ACADAD317FFE7C1C3A7408858585B87CF932A64E9D5AE3A52F4DD3F7FEB59DBEF75FD3F99F9C9C8C59B366C1D6D65648A627D5D6FF33C3542E97A3478F1E3871E284DA833DEDABAFBE824422C1F9F3E7D1BC79737CFDF5D758B870216C6D6D3168D020585959E1F0E1C3183C78B0C6B3010011E1D4A953E8D7AF9FDA8E21B2FF4AB6B6B6484C4CC4BFFEF52FBCFBEEBB68D1A205FAF4E983FBF7EF233E3E1E6DDBB61592AB29F4DFA953279C3C79125E5E5E983061025AB76E8D993367E2DD77DF858787074A4A4A847DCEAE29F40F3CFF73A6A74E9D129609681AFD3F7DFEDBD8D860EEDCB958B870213A74E80003030321B9807AF45FD30766162F5E4C0E0E0E545E5EAE8E8FEAE8ACA3478F6A64D708EEBF66DCBF58DCBF584DBDFFAE5DBB52DBB66D851DBF8EFE6B5EE8FED6AD5B5AF3C1696D326DDA34F2F2F252FB71B8FF9A71FF6271FF623585FE333333C9CACA8A4A4B4BAB7DFDF6EDDB2493C968E6CC991ACF54A98EFE9FBF05DBE0C183C9CFCF4F3DA974507A7A3A999898D0860D1B34723CEEBF3AEE5F2CEE5FACA6D27F66662601A059B366515A5A1A151515D1E9D3A7A94F9F3E646D6D4DB76EDDD27826A27AF5FFFC617AECD8310240070E1C504F3A1D3373E64C6ADFBE3D1517176BE478DC7F75DCBF58DCBF584DA9FFD8D8581A376E1CB56FDF9E8C8C8CC8C6C686A64C9942376FDED478964AF5E8FFF9C3948828202080DCDCDCB46A6D4A114E9E3C49060606B475EB568D1E97FBFF07F72F16F72F16F72F563DFBAF7D98A6A5A591959515BDFBEEBBAA4DA743140A0575E9D285468C18414AA552A3C7E6FEB97FD1B87FB1B87FB15EA0FFDA872911D1B66DDB482291D0F6EDDB55975047545454D0ABAFBE4AB6B6B6949595252403F7CFFD8BC2FD8BC5FD8BF582FDD73D4C8988E6CF9F4F72B99C6263631B9F5087CC9B378F8C8D8D292E2E4E680EEE9FFB1781FB178BFB17EB05FBAFDF30ADA8A8A02953A690B9B9391D3E7CB87109758052A9A4F7DF7F9F0C0C0C282A2A4A741CEE5F30EE5F2CEE5F2CEEBF5EEA374C89884A4B4B69D2A4492497CB69DBB66D0D4BA9034A4A4A68F2E4C9646464A4F137FC6BC3FD8BC5FD8BC5FD8BC5FDD7A9FEC394E89FBF50162C58401289844242429EF960ADAEBB73E70EBDF4D24B64616141870E1D121DE719DCBF58DCBF58DCBF58DC7FAD5E6C9856DAB87123356BD68CBCBDBD857EF6479576ECD841565656E4E6E646C9C9C9A2E3D48AFB178BFB178BFB178BFBAF51C3862911D1E5CB97C9D3D3934C4C4C68F9F2E51AFB30B1AAA5A4A490BFBF3F01A0C0C0407AF4E891E848F5C2FD8BC5FD8BC5FD8BC5FD3FA3E1C394E89FEBE8AB56AD22333333EADCB9336DD9B245EB16477E9E9C9C1C0A090921131313727575A523478E888EF4C2B87FB1B87FB1B87FB1B8FF6A1A374C2BA5A7A7D38C193348269351D7AE5D69D3A64D5ABB6A465A5A1A7DF8E18764666646AD5BB7A6B56BD7EAFCB57FEE5F2CEE5F2CEE5F2CEE9F8854354C2BDDB8718366CE9C49464646646D6D4DF3E7CFD78AEBFFA5A5A5141D1D4D01010164606040B6B6B6F4D5575F51515191E8682AC5FD8BC5FD8BC5FD8BD5C4FB57ED30AD949595452B56ACA00E1D3A1000727676A64F3EF984121313357619A0A0A08076EFDE4D3366CC206B6B6B924824347CF8708A8C8CA49292128D641085FB178BFB178BFB17AB89F61F29212252D7CEE44AA512C78F1FC7AE5DBB10151585D4D454585A5A62C08001183060007AF6EC09777777D8D9D935EA38E5E5E5B871E30692939371EAD429C4C7C7232929094AA512FDFAF5C3ABAFBE8A575F7D15EDDBB757CD13D311DCBF58DCBF58DCBF584DACFF1D6A1DA64F4B4E4EC6B163C7101717878484046464640000ACADADE1E4E4045B5B5B383A3AA275EBD6B0B4B4845C2E87A9A929E47239140A05CACBCBA1502850505080F4F474646767232D2D0DD7AF5F476969296432195C5C5C3078F0600C1A340883060D828D8D8DA69E9ED6E3FEC5E2FEC5E2FEC5D2F3FE353B4C9F969797878B172FE2D2A54BB879F326B2B2B270F7EE5D646767A3A0A000252525282A2A42696929CCCCCC60686808737373585858C0DEDE1EB6B6B670707080B3B333DCDCDCE0EAEA0AB95C2EEAE9E81CEE5F2CEE5F2CEE5F2C3DEB5FEC30658C31C6F4C00EA9E8048C31C698AEE361CA18638C35120F53C61863AC91640076880EC118638CE9B053FF1FD62D2637E57DAFB30000000049454E44AE426082>|png>|300px|||>
    </unfolded-io>

    <\input>
      twopi]\ 
    <|input>
      \;
    </input>
  </session>

  <\big-table|<block*|<tformat|<table|<row|<cell|Option>|<cell|Function>>|<row|<cell|-width>|<cell|control
  the width of the graph>>|<row|<cell|-height>|<cell|control the height of
  the graph>>|<row|<cell|-output>|<cell|control the internal output format of
  the graph>>>>>>
    Options on the magic line
  </big-table>

  Currently, only the <name|Graphviz> backend supports the switch of the
  output format. For some reason, the eps format does not always work fine
  for <name|Graphviz>. Don't worry, you may switch to png via the magic line.

  <section|Foldable>

  Sometimes, we do not care about how to generate the graph, but care about
  the graph itself. In this case we can just\ 

  <\with|par-columns|2>
    <\script-input|dot|default>
      %dot -height 400

      digraph G {

      \ v1 -\<gtr\> v2;

      \ v1 -\<gtr\> v3;

      \ v3 -\<gtr\> v2;

      \ v2 -\<gtr\> v4;

      \ v3 -\<gtr\> v4;

      \ v4 -\<gtr\> v5;

      \ v5 -\<gtr\> v4;

      \ v5 -\<gtr\> v3;

      \ v5 -\<gtr\> v6;

      \ v4 -\<gtr\> v6;

      \ v6 -\<gtr\> v7;

      }
    </script-input|<image|<tuple|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|ps>||400px||>>

    <\with|par-columns|2>
      <\script-output|dot|default>
        %dot -height 400

        digraph G {

        \ v1 -\<gtr\> v2;

        \ v1 -\<gtr\> v3;

        \ v3 -\<gtr\> v2;

        \ v2 -\<gtr\> v4;

        \ v3 -\<gtr\> v4;

        \ v4 -\<gtr\> v5;

        \ v5 -\<gtr\> v4;

        \ v5 -\<gtr\> v3;

        \ v5 -\<gtr\> v6;

        \ v4 -\<gtr\> v6;

        \ v6 -\<gtr\> v7;

        }
      </script-output|<image|<tuple|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|ps>||400px||>>
    </with>
  </with>

  <tmdoc-copyright|2019|Darcy Shen, Massimiliano Gubinelli>

  <tmdoc-license|Permission is granted to copy, distribute and/or modify this
  document under the terms of the GNU Free Documentation License, Version 1.1
  or any later version published by the Free Software Foundation; with no
  Invariant Sections, with no Front-Cover Texts, and with no Back-Cover
  Texts. A copy of the license is included in the section entitled "GNU Free
  Documentation License".>
</body>

<\initial>
  <\collection>
    <associate|par-hyphen|normal>
    <associate|preamble|false>
  </collection>
</initial>