(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/protobuf/io#marshal
    (lambda (_obj749_ _bio-write-e750_)
      (let ((_buf752_ (std/net/bio/buffer#open-serializer-output-buffer__0)))
        (_bio-write-e750_ _obj749_ _buf752_)
        (std/net/bio/buffer#chunked-output-u8vector _buf752_))))
  (define std/protobuf/io#unmarshal
    (lambda (_bytes744_ _bio-read-e745_)
      (let ((_buf747_ (std/net/bio/buffer#open-input-buffer__0 _bytes744_)))
        (_bio-read-e745_ _buf747_))))
  (define std/protobuf/io#read-delimited__%
    (lambda (_bio-read-e721_ _port722_)
      (let* ((_len724_ (std/protobuf/io#read-varuint _port722_))
             (_bytes726_ (make-u8vector _len724_))
             (_rd728_ (read-subu8vector _bytes726_ '0 _len724_ _port722_))
             (_g4466_ (if (fx= _rd728_ _len724_)
                          '#!void
                          (std/error#raise-io-error
                           'read-delimited
                           '"Premature end of input"
                           _port722_
                           _rd728_)))
             (_buf731_ (std/net/bio/buffer#open-input-buffer__0 _bytes726_)))
        (_bio-read-e721_ _buf731_))))
  (define std/protobuf/io#read-delimited__0
    (lambda (_bio-read-e737_)
      (let ((_port739_ (current-input-port)))
        (std/protobuf/io#read-delimited__% _bio-read-e737_ _port739_))))
  (define std/protobuf/io#read-delimited
    (lambda _g4468_
      (let ((_g4467_ (let () (declare (not safe)) (##length _g4468_))))
        (cond ((let () (declare (not safe)) (##fx= _g4467_ 1))
               (apply std/protobuf/io#read-delimited__0 _g4468_))
              ((let () (declare (not safe)) (##fx= _g4467_ 2))
               (apply std/protobuf/io#read-delimited__% _g4468_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/protobuf/io#read-delimited
                _g4468_))))))
  (define std/protobuf/io#write-delimited__%
    (lambda (_x698_ _bio-write-e699_ _port700_)
      (let ((_buf702_ (std/net/bio/buffer#open-serializer-output-buffer__0)))
        (_bio-write-e699_ _x698_ _buf702_)
        (let ((_len704_ (std/net/bio/buffer#chunked-output-length _buf702_)))
          (std/protobuf/io#write-varuint _len704_ _port700_)
          (for-each
           (lambda (_bytes706_)
             (write-subu8vector
              _bytes706_
              '0
              (u8vector-length _bytes706_)
              _port700_))
           (std/net/bio/buffer#chunked-output-chunks _buf702_))))))
  (define std/protobuf/io#write-delimited__0
    (lambda (_x711_ _bio-write-e712_)
      (let ((_port714_ (current-output-port)))
        (std/protobuf/io#write-delimited__%
         _x711_
         _bio-write-e712_
         _port714_))))
  (define std/protobuf/io#write-delimited
    (lambda _g4470_
      (let ((_g4469_ (let () (declare (not safe)) (##length _g4470_))))
        (cond ((let () (declare (not safe)) (##fx= _g4469_ 2))
               (apply std/protobuf/io#write-delimited__0 _g4470_))
              ((let () (declare (not safe)) (##fx= _g4469_ 3))
               (apply std/protobuf/io#write-delimited__% _g4470_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/protobuf/io#write-delimited
                _g4470_))))))
  (define std/protobuf/io#read-varuint
    (lambda (_port682_)
      (let _lp684_ ((_shift686_ '0) (_r687_ '0))
        (let* ((_bits689_ (read-u8 _port682_))
               (_g4471_ (if (eof-object? _bits689_)
                            (std/error#raise-io-error
                             'read-varuint
                             '"Premature end of input"
                             _port682_)
                            '#!void))
               (_limb692_
                (let () (declare (not safe)) (##fxand _bits689_ '127)))
               (_r694_ (bitwise-ior
                        (arithmetic-shift _limb692_ _shift686_)
                        _r687_)))
          (if (let ((__tmp4472
                     (let () (declare (not safe)) (##fxand _bits689_ '128))))
                (declare (not safe))
                (##fxzero? __tmp4472))
              _r694_
              (_lp684_ (let () (declare (not safe)) (##fx+ _shift686_ '7))
                       _r694_))))))
  (define std/protobuf/io#write-varuint
    (lambda (_x670_ _port671_)
      (let _lp673_ ((_bits675_ _x670_))
        (if (< _bits675_ '128)
            (write-u8 _bits675_ _port671_)
            (let* ((_limb677_ (bitwise-and _bits675_ '127))
                   (_obits679_
                    (let () (declare (not safe)) (##fxior _limb677_ '128))))
              (write-u8 _obits679_ _port671_)
              (_lp673_ (arithmetic-shift _bits675_ '-7)))))))
  (define std/protobuf/io#bio-read-field
    (lambda (_buf666_)
      (let ((_field668_ (std/protobuf/io#bio-read-varint _buf666_)))
        (values (arithmetic-shift _field668_ '-3)
                (std/protobuf/io#byte->tag (bitwise-and _field668_ '7))))))
  (define std/protobuf/io#bio-write-field
    (lambda (_x662_ _tag663_ _buf664_)
      (std/protobuf/io#bio-write-varint
       (bitwise-ior
        (arithmetic-shift _x662_ '3)
        (std/protobuf/io#tag->byte _tag663_))
       _buf664_)))
  (define std/protobuf/io#byte->tag
    (lambda (_x657_)
      (let ((_$e659_ _x657_))
        (if (eq? '0 _$e659_)
            'VARINT
            (if (eq? '1 _$e659_)
                'FIXED64
                (if (eq? '2 _$e659_)
                    'VARLEN
                    (if (eq? '5 _$e659_)
                        'FIXED32
                        (error '"Unknown type tag" _x657_))))))))
  (define std/protobuf/io#tag->byte
    (lambda (_x652_)
      (let ((_$e654_ _x652_))
        (if (eq? 'VARINT _$e654_)
            '0
            (if (eq? 'FIXED64 _$e654_)
                '1
                (if (eq? 'VARLEN _$e654_)
                    '2
                    (if (eq? 'FIXED32 _$e654_)
                        '5
                        (error '"Unknown type tag" _x652_))))))))
  (define std/protobuf/io#bio-input-skip-unknown
    (lambda (_tag646_ _buf647_)
      (let ((_$e649_ _tag646_))
        (if (eq? 'VARINT _$e649_)
            (std/protobuf/io#bio-input-skip-varint _buf647_)
            (if (eq? 'FIXED64 _$e649_)
                (std/net/bio/input#bio-input-skip '8 _buf647_)
                (if (eq? 'VARLEN _$e649_)
                    (std/net/bio/input#bio-input-skip
                     (std/protobuf/io#bio-read-varint _buf647_)
                     _buf647_)
                    (if (eq? 'FIXED32 _$e649_)
                        (std/net/bio/input#bio-input-skip '4 _buf647_)
                        (error '"Unknown type tag" _tag646_))))))))
  (define std/protobuf/io#bio-input-skip-varint
    (lambda (_buf639_)
      (let _lp641_ ()
        (let ((_byte644_ (std/net/bio/input#bio-read-u8 _buf639_)))
          (if (eof-object? _byte644_)
              (std/error#raise-io-error
               'bio-input-skip-varint
               '"Premature end of input"
               _buf639_)
              '#!void)
          (if (let ((__tmp4473
                     (let () (declare (not safe)) (##fxand _byte644_ '128))))
                (declare (not safe))
                (##fxzero? __tmp4473))
              '#!void
              (_lp641_))))))
  (define std/protobuf/io#bio-read-packed
    (lambda (_bio-read-e627_ _buf628_)
      (let* ((_len630_ (std/protobuf/io#bio-read-varint _buf628_))
             (_buf632_
              (std/net/bio/buffer#open-delimited-input-buffer
               _buf628_
               _len630_)))
        (let _lp635_ ((_r637_ '()))
          (if (eof-object? (std/net/bio/input#bio-peek-u8 _buf632_))
              (reverse _r637_)
              (_lp635_ (cons (_bio-read-e627_ _buf632_) _r637_)))))))
  (define std/protobuf/io#bio-write-packed
    (lambda (_xs613_ _bio-write-e614_ _buf615_)
      (let ((_tmpbuf617_
             (std/net/bio/buffer#open-serializer-output-buffer__0)))
        (for-each
         (lambda (_g618620_) (_bio-write-e614_ _g618620_ _tmpbuf617_))
         _xs613_)
        (std/protobuf/io#bio-write-varint
         (std/net/bio/buffer#chunked-output-length _tmpbuf617_)
         _buf615_)
        (for-each
         (lambda (_g622624_)
           (std/net/bio/output#bio-write-bytes _g622624_ _buf615_))
         (std/net/bio/buffer#chunked-output-chunks _tmpbuf617_)))))
  (define std/protobuf/io#bio-read-key-value-pair
    (lambda (_bio-read-key-e593_ _bio-read-value-e594_ _buf595_)
      (let* ((_len597_ (std/protobuf/io#bio-read-varint _buf595_))
             (_buf599_
              (std/net/bio/buffer#open-delimited-input-buffer
               _buf595_
               _len597_)))
        (let _lp602_ ((_key604_ '#f) (_value605_ '#f))
          (if (eof-object? (std/net/bio/input#bio-peek-u8 _buf599_))
              (cons _key604_ _value605_)
              (let ((_g4474_ (std/protobuf/io#bio-read-field _buf599_)))
                (begin
                  (let ((_g4475_ (let ()
                                   (declare (not safe))
                                   (if (##values? _g4474_)
                                       (##vector-length _g4474_)
                                       1))))
                    (if (not (let () (declare (not safe)) (##fx= _g4475_ 2)))
                        (error "Context expects 2 values" _g4475_)))
                  (let ((_field607_
                         (let ()
                           (declare (not safe))
                           (##vector-ref _g4474_ 0)))
                        (_tag608_
                         (let ()
                           (declare (not safe))
                           (##vector-ref _g4474_ 1))))
                    (let ((_$e610_ _field607_))
                      (if (eq? '1 _$e610_)
                          (_lp602_ (_bio-read-key-e593_ _buf599_) _value605_)
                          (if (eq? '2 _$e610_)
                              (_lp602_ _key604_
                                       (_bio-read-value-e594_ _buf599_))
                              (begin
                                (std/protobuf/io#bio-input-skip-unknown
                                 _tag608_
                                 _buf599_)
                                (_lp602_ _key604_ _value605_)))))))))))))
  (define std/protobuf/io#bio-write-key-value-pair
    (lambda (_k571_
             _v572_
             _ktag573_
             _bio-write-key-e574_
             _vtag575_
             _bio-write-value-e576_
             _buf577_)
      (let* ((_tmpbuf579_
              (std/net/bio/buffer#open-serializer-output-buffer__0))
             (_tmpbuf-write586_
              (lambda (_field581_ _tag582_ _val583_ _bio-write-e584_)
                (std/protobuf/io#bio-write-field
                 _field581_
                 _tag582_
                 _tmpbuf579_)
                (_bio-write-e584_ _val583_ _tmpbuf579_))))
        (_tmpbuf-write586_ '1 _ktag573_ _k571_ _bio-write-key-e574_)
        (_tmpbuf-write586_ '2 _vtag575_ _v572_ _bio-write-value-e576_)
        (std/protobuf/io#bio-write-varint
         (std/net/bio/buffer#chunked-output-length _tmpbuf579_)
         _buf577_)
        (for-each
         (lambda (_g588590_)
           (std/net/bio/output#bio-write-bytes _g588590_ _buf577_))
         (std/net/bio/buffer#chunked-output-chunks _tmpbuf579_)))))
  (define std/protobuf/io#bio-read-delimited
    (lambda (_bio-read-e563_ _buf564_)
      (let* ((_len566_ (std/protobuf/io#bio-read-varint _buf564_))
             (_buf568_
              (std/net/bio/buffer#open-delimited-input-buffer
               _buf564_
               _len566_)))
        (_bio-read-e563_ _buf568_))))
  (define std/protobuf/io#bio-write-delimited
    (lambda (_x553_ _bio-write-e554_ _buf555_)
      (let ((_tmpbuf557_
             (std/net/bio/buffer#open-serializer-output-buffer__0)))
        (_bio-write-e554_ _x553_ _tmpbuf557_)
        (std/protobuf/io#bio-write-varint
         (std/net/bio/buffer#chunked-output-length _tmpbuf557_)
         _buf555_)
        (for-each
         (lambda (_g558560_)
           (std/net/bio/output#bio-write-bytes _g558560_ _buf555_))
         (std/net/bio/buffer#chunked-output-chunks _tmpbuf557_)))))
  (define std/protobuf/io#bio-read-delimited-string
    (lambda (_buf537_)
      (declare (not safe))
      (let* ((_len540_ (std/protobuf/io#bio-read-varint _buf537_))
             (_buf542_
              (std/net/bio/buffer#open-delimited-input-buffer
               _buf537_
               _len540_))
             (_str544_ (make-string _len540_)))
        (let _lp547_ ((_i549_ '0))
          (if (eof-object? (std/net/bio/input#bio-peek-u8 _buf542_))
              (begin (string-shrink! _str544_ _i549_) _str544_)
              (let ((_char551_ (std/net/bio/input#bio-read-char _buf542_)))
                (string-set! _str544_ _i549_ _char551_)
                (_lp547_ (fx+ _i549_ '1))))))))
  (define std/protobuf/io#bio-write-delimited-string
    (lambda (_x532_ _buf533_)
      (let ((_len535_ (std/text/utf8#string-utf8-length__0 _x532_)))
        (std/protobuf/io#bio-write-varint _len535_ _buf533_)
        (std/net/bio/output#bio-write-string _x532_ _buf533_))))
  (define std/protobuf/io#bio-read-delimited-bytes
    (lambda (_buf525_)
      (let* ((_len527_ (std/protobuf/io#bio-read-varint _buf525_))
             (_bytes529_ (make-u8vector _len527_)))
        (std/net/bio/input#bio-read-bytes _bytes529_ _buf525_)
        _bytes529_)))
  (define std/protobuf/io#bio-write-delimited-bytes
    (lambda (_x522_ _buf523_)
      (std/protobuf/io#bio-write-varint (u8vector-length _x522_) _buf523_)
      (std/net/bio/output#bio-write-bytes _x522_ _buf523_)))
  (define std/protobuf/io#bio-read-boolean
    (lambda (_buf520_)
      (not (zero? (std/protobuf/io#bio-read-varint _buf520_)))))
  (define std/protobuf/io#bio-write-boolean
    (lambda (_x517_ _buf518_)
      (std/protobuf/io#bio-write-varint (if _x517_ '1 '0) _buf518_)))
  (define std/protobuf/io#2^31 (expt '2 '31))
  (define std/protobuf/io#2^32 (expt '2 '32))
  (define std/protobuf/io#2^63 (expt '2 '63))
  (define std/protobuf/io#2^64 (expt '2 '64))
  (define std/protobuf/io#bio-read-varint
    (lambda (_buf498_)
      (letrec ((_complement500_
                (lambda (_r515_)
                  (if (< _r515_ std/protobuf/io#2^63)
                      _r515_
                      (- _r515_ std/protobuf/io#2^64)))))
        (let _lp502_ ((_shift504_ '0) (_r505_ '0))
          (let* ((_bits507_ (std/net/bio/input#bio-read-u8 _buf498_))
                 (_g4476_ (if (eof-object? _bits507_)
                              (std/error#raise-io-error
                               'bio-read-varint
                               '"Premature end of input"
                               _buf498_)
                              '#!void))
                 (_limb510_
                  (let () (declare (not safe)) (##fxand _bits507_ '127)))
                 (_r512_ (bitwise-ior
                          (arithmetic-shift _limb510_ _shift504_)
                          _r505_)))
            (if (let ((__tmp4477
                       (let () (declare (not safe)) (##fxand _bits507_ '128))))
                  (declare (not safe))
                  (##fxzero? __tmp4477))
                (_complement500_ _r512_)
                (_lp502_ (let () (declare (not safe)) (##fx+ _shift504_ '7))
                         _r512_)))))))
  (define std/protobuf/io#bio-write-varint
    (lambda (_x482_ _buf483_)
      (letrec ((_complement485_
                (lambda (_r496_)
                  (if (< _r496_ '0) (+ std/protobuf/io#2^64 _r496_) _r496_))))
        (let _lp487_ ((_bits489_ (_complement485_ _x482_)))
          (if (< _bits489_ '128)
              (std/net/bio/output#bio-write-u8 _bits489_ _buf483_)
              (let* ((_limb491_ (bitwise-and _bits489_ '127))
                     (_obits493_
                      (let () (declare (not safe)) (##fxior _limb491_ '128))))
                (std/net/bio/output#bio-write-u8 _obits493_ _buf483_)
                (_lp487_ (arithmetic-shift _bits489_ '-7))))))))
  (define std/protobuf/io#bio-read-varint-zigzag
    (lambda (_buf478_)
      (let ((_y480_ (std/protobuf/io#bio-read-varint _buf478_)))
        (if (even? _y480_)
            (quotient _y480_ '2)
            (- (quotient (+ _y480_ '1) '2))))))
  (define std/protobuf/io#bio-write-varint-zigzag
    (lambda (_x473_ _buf474_)
      (let ((_y476_ (if (negative? _x473_)
                        (- (+ (* _x473_ '2) '1))
                        (* _x473_ '2))))
        (std/protobuf/io#bio-write-varint _y476_ _buf474_))))
  (define std/protobuf/io#bio-read-fixed-uint
    (lambda (_n463_ _buf464_)
      (let _lp466_ ((_i468_ '0) (_bits469_ '0))
        (if (let () (declare (not safe)) (##fx< _i468_ _n463_))
            (let ((_byte471_ (std/net/bio/input#bio-read-u8 _buf464_)))
              (if (eof-object? _byte471_)
                  (std/error#raise-io-error
                   'bio-read-sfixed32
                   '"Premature end of input"
                   _buf464_)
                  '#!void)
              (_lp466_ (let () (declare (not safe)) (##fx+ _i468_ '1))
                       (bitwise-ior
                        _bits469_
                        (arithmetic-shift
                         _byte471_
                         (let () (declare (not safe)) (##fx* '8 _i468_))))))
            _bits469_))))
  (define std/protobuf/io#bio-write-fixed-uint
    (lambda (_x454_ _n455_ _buf456_)
      (let _lp458_ ((_i460_ '0) (_bits461_ _x454_))
        (if (let () (declare (not safe)) (##fx< _i460_ _n455_))
            (begin
              (std/net/bio/output#bio-write-u8
               (bitwise-and _bits461_ '255)
               _buf456_)
              (_lp458_ (let () (declare (not safe)) (##fx+ _i460_ '1))
                       (arithmetic-shift _bits461_ '-8)))
            '#!void))))
  (define std/protobuf/io#bio-read-fixed32
    (lambda (_buf452_) (std/protobuf/io#bio-read-fixed-uint '4 _buf452_)))
  (define std/protobuf/io#bio-write-fixed32
    (lambda (_x449_ _buf450_)
      (std/protobuf/io#bio-write-fixed-uint _x449_ '4 _buf450_)))
  (define std/protobuf/io#bio-read-sfixed32
    (lambda (_buf445_)
      (let ((_y447_ (std/protobuf/io#bio-read-fixed-uint '4 _buf445_)))
        (if (< _y447_ std/protobuf/io#2^31)
            _y447_
            (- _y447_ std/protobuf/io#2^32)))))
  (define std/protobuf/io#bio-write-sfixed32
    (lambda (_x440_ _buf441_)
      (let ((_y443_ (if (< _x440_ '0) (+ std/protobuf/io#2^32 _x440_) _x440_)))
        (std/protobuf/io#bio-write-fixed-uint _y443_ '4 _buf441_))))
  (define std/protobuf/io#bio-read-fixed64
    (lambda (_buf438_) (std/protobuf/io#bio-read-fixed-uint '8 _buf438_)))
  (define std/protobuf/io#bio-write-fixed64
    (lambda (_x435_ _buf436_)
      (std/protobuf/io#bio-write-fixed-uint _x435_ '8 _buf436_)))
  (define std/protobuf/io#bio-read-sfixed64
    (lambda (_buf431_)
      (let ((_y433_ (std/protobuf/io#bio-read-fixed-uint '8 _buf431_)))
        (if (< _y433_ std/protobuf/io#2^63)
            _y433_
            (- _y433_ std/protobuf/io#2^64)))))
  (define std/protobuf/io#bio-write-sfixed64
    (lambda (_x426_ _buf427_)
      (let ((_y429_ (if (< _x426_ '0) (+ std/protobuf/io#2^64 _x426_) _x426_)))
        (std/protobuf/io#bio-write-fixed-uint _y429_ '8 _buf427_))))
  (define std/protobuf/io#bio-read-float
    (lambda (_buf424_)
      (std/protobuf/io#bio-read-float-bytes
       '4
       std/protobuf/io#bytes->float
       _buf424_)))
  (define std/protobuf/io#bio-write-float
    (lambda (_x421_ _buf422_)
      (std/protobuf/io#bio-write-float-bytes
       _x421_
       '4
       std/protobuf/io#float->bytes!
       _buf422_)))
  (define std/protobuf/io#bio-read-double
    (lambda (_buf419_)
      (std/protobuf/io#bio-read-float-bytes
       '8
       std/protobuf/io#bytes->double
       _buf419_)))
  (define std/protobuf/io#bio-write-double
    (lambda (_x416_ _buf417_)
      (std/protobuf/io#bio-write-float-bytes
       _x416_
       '8
       std/protobuf/io#double->bytes!
       _buf417_)))
  (define std/protobuf/io#bio-read-float-bytes
    (lambda (_n410_ _bytes->flonum411_ _buf412_)
      (let ((_bytes414_ (make-u8vector _n410_)))
        (std/net/bio/input#bio-read-bytes _bytes414_ _buf412_)
        (_bytes->flonum411_ _bytes414_))))
  (define std/protobuf/io#bio-write-float-bytes
    (lambda (_x403_ _n404_ _flonum->bytes!405_ _buf406_)
      (let ((_bytes408_ (make-u8vector _n404_)))
        (_flonum->bytes!405_ _x403_ _bytes408_)
        (std/net/bio/output#bio-write-bytes _bytes408_ _buf406_))))
  (define-macro (define-guard guard defn)
    (if (eval `(cond-expand (,guard #t) (else #f)))
        '(begin)
        (begin (eval `(define-cond-expand-feature ,guard)) defn)))
  (define-macro (define-c-lambda id args ret #!optional (name #f))
    (let ((name (or name (symbol->string id))))
      `(define ,id (c-lambda ,args ,ret ,name))))
  (define-macro (define-const symbol)
    (let* ((str (symbol->string symbol))
           (ref (string-append "___return (" str ");")))
      `(define ,symbol ((c-lambda () int ,ref)))))
  (define-macro (define-const* symbol)
    (let* ((str (symbol->string symbol))
           (code (string-append
                  "#ifdef "
                  str
                  "\n"
                  "___return (___FIX ("
                  str
                  "));\n"
                  "#else \n"
                  "___return (___FAL);\n"
                  "#endif")))
      `(define ,symbol ((c-lambda () scheme-object ,code)))))
  (define-macro (define-with-errno symbol ffi-symbol args)
    `(define (,symbol ,@args)
       (declare (not interrupts-enabled))
       (let ((r (,ffi-symbol ,@args)))
         (if (##fx< r 0) (##fx- (##c-code "___RESULT = ___FIX (errno);")) r))))
  (define-macro (define-c-struct
                 struct
                 #!optional
                 (members '())
                 release-function)
    (let* ((struct-str (symbol->string struct))
           (struct-ptr (string->symbol (string-append struct-str "*")))
           (shallow-ptr
            (string->symbol (string-append struct-str "-shallow-ptr*")))
           (borrowed-ptr
            (string->symbol (string-append struct-str "-borrowed-ptr*")))
           (string-types
            '(char-string
              nonull-char-string
              UTF-8-string
              nonnull-UTF-8-string
              UTF-16-string
              nonnull-UTF16-string))
           (string-compat-required?
            (let loop ((m members))
              (cond ((null? m) #f)
                    ((member (cdr (car m)) string-types) #t)
                    (else (loop (cdr m))))))
           (string-setter-body
            (lambda (member-name)
              (let ((m (string-append "___arg1->" member-name)))
                (string-append
                 "if("
                 m
                 " == NULL)"
                 "\n"
                 m
                 "= strdup(___arg2);"
                 "\n"
                 "else if (strcmp("
                 m
                 ", ___arg2) != 0) {"
                 "\n"
                 "free("
                 m
                 ");"
                 "\n"
                 m
                 "= strdup(___arg2);"
                 "\n"
                 "}"
                 "\n"
                 "___return;"
                 "\n"))))
           (default-free-body
            (and string-compat-required?
                 (string-append
                  "___SCMOBJ "
                  struct-str
                  "_ffi_free (void *ptr) {"
                  "\n"
                  "struct "
                  struct-str
                  " *obj = (struct "
                  struct-str
                  "*) ptr;"
                  "\n"
                  (apply string-append
                         (map (lambda (m)
                                (cond ((memq (cdr m) string-types)
                                       (let ((mem-name
                                              (symbol->string (car m))))
                                         (string-append
                                          "if(obj->"
                                          mem-name
                                          ") "
                                          "free(obj->"
                                          mem-name
                                          ");"
                                          "\n")))
                                      (else "")))
                              members))
                  "free(obj);"
                  "\n"
                  "return ___FIX (___NO_ERR);"
                  "\n"
                  "}")))
           (release-function
            (or release-function
                (if string-compat-required?
                    (string-append struct-str "_ffi_free")
                    "ffi_free")))
           (string-compat-types
            (if string-compat-required?
                `((c-declare ,default-free-body)
                  (c-define-type
                   ,shallow-ptr
                   (pointer ,struct (,struct-ptr) "ffi_free")))
                '())))
      `(begin
         (c-define-type ,struct (struct ,struct-str))
         (c-define-type
          ,struct-ptr
          (pointer ,struct (,struct-ptr) ,release-function))
         (c-define-type ,borrowed-ptr (pointer ,struct (,struct-ptr)))
         ,@string-compat-types
         (define ,(string->symbol (string-append struct-str "-ptr?"))
           (lambda (obj)
             (and (foreign? obj) (equal? (foreign-tags obj) '(,struct-ptr)))))
         ,@(apply append
                  (map (lambda (m)
                         (let* ((member-name (symbol->string (car m)))
                                (member-type (cdr m))
                                (getter-name
                                 (string-append struct-str "-" member-name))
                                (setter-body
                                 (cond ((member member-type string-types)
                                        (string-setter-body member-name))
                                       (else
                                        (string-append
                                         "___arg1->"
                                         member-name
                                         " = ___arg2;"
                                         "\n"
                                         "___return;"
                                         "\n")))))
                           `((define ,(string->symbol getter-name)
                               (c-lambda
                                (,struct-ptr)
                                ,member-type
                                ,(string-append
                                  "___return(___arg1->"
                                  member-name
                                  ");")))
                             (define ,(string->symbol
                                       (string-append getter-name "-set!"))
                               (c-lambda
                                (,struct-ptr ,member-type)
                                void
                                ,setter-body)))))
                       members))
         (define ,(string->symbol (string-append "malloc-" struct-str))
           (c-lambda
            ()
            ,struct-ptr
            ,(string-append
              "struct "
              struct-str
              "* var = (struct "
              struct-str
              " *) malloc(sizeof(struct "
              struct-str
              "));"
              "\n"
              "if (var == NULL)"
              "\n"
              "    ___return (NULL);"
              "\n"
              "memset(var, 0, sizeof(struct "
              struct-str
              "));"
              "___return(var);")))
         (define ,(string->symbol (string-append "ptr->" struct-str))
           (c-lambda (,struct-ptr) ,struct "___return(*___arg1);"))
         (define ,(string->symbol
                   (string-append "malloc-" struct-str "-array"))
           (c-lambda
            (unsigned-int32)
            ,(if string-compat-required? shallow-ptr struct-ptr)
            ,(string-append
              "struct "
              struct-str
              " *arr_var=(struct "
              struct-str
              " *) malloc(___arg1*sizeof(struct "
              struct-str
              "));"
              "\n"
              "if (arr_var == NULL)"
              "\n"
              "    ___return (NULL);"
              "\n"
              "memset(arr_var, 0, ___arg1*sizeof(struct "
              struct-str
              "));"
              "\n"
              "___return(arr_var);")))
         (define ,(string->symbol (string-append struct-str "-array-ref"))
           (c-lambda
            (,struct-ptr unsigned-int32)
            ,borrowed-ptr
            "___return (___arg1 + ___arg2);"))
         (define ,(string->symbol (string-append struct-str "-array-set!"))
           (c-lambda
            (,struct-ptr unsigned-int32 ,struct-ptr)
            void
            "*(___arg1 + ___arg2) = *___arg3; ___return;")))))
  (c-declare "#include <stdlib.h>")
  (c-declare "#include <string.h>")
  (c-declare "#include <errno.h>")
  (c-declare "static ___SCMOBJ ffi_free (void *ptr);")
  (c-declare
   "#ifndef ___HAVE_FFI_U8VECTOR\n#define ___HAVE_FFI_U8VECTOR\n#define U8_DATA(obj) ___CAST (___U8*, ___BODY_AS (obj, ___tSUBTYPED))\n#define U8_LEN(obj) ___HD_BYTES (___HEADER (obj))\n#endif")
  (namespace
   ("std/protobuf/io#"
    double->bytes!
    bytes->double
    float->bytes!
    bytes->float))
  (c-declare
   "static float ffi_read_float_bytes (___SCMOBJ bytes)\n{\n return *(float*)(U8_DATA (bytes));\n}\n\nstatic void ffi_write_float_bytes (float val, ___SCMOBJ bytes)\n{\n *(float*)(U8_DATA (bytes)) = val;\n}\n\nstatic double ffi_read_double_bytes (___SCMOBJ bytes)\n{\n return *(double*)(U8_DATA (bytes));\n}\n\nstatic void ffi_write_double_bytes (double val, ___SCMOBJ bytes)\n{\n *(double*)(U8_DATA (bytes)) = val;\n}")
  (define-c-lambda bytes->float (scheme-object) float "ffi_read_float_bytes")
  (define-c-lambda
   float->bytes!
   (float scheme-object)
   void
   "ffi_write_float_bytes")
  (define-c-lambda
   bytes->double
   (scheme-object)
   double
   "ffi_read_double_bytes")
  (define-c-lambda
   double->bytes!
   (double scheme-object)
   void
   "ffi_write_double_bytes")
  (c-declare
   "#ifndef ___HAVE_FFI_FREE\n#define ___HAVE_FFI_FREE\n___SCMOBJ ffi_free (void *ptr)\n{\n free (ptr);\n return ___FIX (___NO_ERR);\n}\n#endif"))
