/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.ArrayInspection;
import org.fest.assertions.ErrorMessages;

public class FloatArrayAssert
extends ArrayAssert<FloatArrayAssert, float[]> {
    protected FloatArrayAssert(float ... actual) {
        super(FloatArrayAssert.class, actual);
    }

    @Nonnull
    public FloatArrayAssert contains(float ... values) {
        this.assertContains(ArrayInspection.copy(values));
        return this;
    }

    @Nonnull
    public FloatArrayAssert containsOnly(float ... values) {
        this.assertContainsOnly(ArrayInspection.copy(values));
        return this;
    }

    @Nonnull
    public FloatArrayAssert excludes(float ... values) {
        this.assertExcludes(ArrayInspection.copy(values));
        return this;
    }

    @Override
    @Nonnull
    public FloatArrayAssert isEqualTo(@Nullable float[] expected) {
        if (Arrays.equals((float[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    @Override
    @Nonnull
    public FloatArrayAssert isNotEqualTo(@Nullable float[] array) {
        if (!Arrays.equals((float[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }
}

