/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.CommonBundle;
import com.intellij.compiler.PsiClassWriter;
import com.intellij.compiler.impl.FileSetCompileScope;
import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.GuiFormFileType;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.compiler.AsmCodeGenerator;
import com.intellij.uiDesigner.compiler.FormErrorInfo;
import com.intellij.uiDesigner.compiler.NestedFormLoader;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.lw.CompiledClassPropertiesProvider;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.LwComponent;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.make.PreviewNestedFormLoader;
import com.intellij.util.PathsList;
import com.jgoodies.forms.layout.CellConstraints;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.java.CopyResourcesUtil;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public final class PreviewFormAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(PreviewFormAction.class);
    private static final String CLASS_TO_BIND_NAME = "com.intellij.uiDesigner.FormPreviewFrame";
    private static final String CLASS_TO_BIND_RESOURCE_NAME = "com/intellij/uiDesigner/FormPreviewFrame";
    @NonNls
    private static final String RUNTIME_BUNDLE_PREFIX = "RuntimeBundle";
    @NonNls
    public static final String PREVIEW_BINDING_FIELD = "myComponent";

    @NotNull
    public static InstrumentationClassFinder createClassFinder(URL @Nullable [] platformUrls, @NotNull String classPath) {
        if (classPath == null) {
            PreviewFormAction.$$$reportNull$$$0(0);
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        StringTokenizer tokenizer = new StringTokenizer(classPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            try {
                urls.add(new File(s).toURI().toURL());
            }
            catch (Exception exc) {
                throw new RuntimeException(exc);
            }
        }
        URL[] zero = new URL[]{};
        return new InstrumentationClassFinder(platformUrls == null ? zero : platformUrls, urls.toArray(zero));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        GuiEditor editor;
        if (e == null) {
            PreviewFormAction.$$$reportNull$$$0(1);
        }
        if ((editor = FormEditingUtil.getActiveEditor(e.getDataContext())) != null) {
            PreviewFormAction.showPreviewFrame(editor.getModule(), editor.getFile(), editor.getStringDescriptorLocale());
        }
    }

    public void update(@NotNull AnActionEvent e) {
        GuiEditor editor;
        if (e == null) {
            PreviewFormAction.$$$reportNull$$$0(2);
        }
        if ((editor = FormEditingUtil.getActiveEditor(e.getDataContext())) == null) {
            e.getPresentation().setVisible(false);
            return;
        }
        VirtualFile file = editor.getFile();
        e.getPresentation().setVisible(FileDocumentManager.getInstance().getDocument(file) != null && FileTypeRegistry.getInstance().isFileOfType(file, (FileType)GuiFormFileType.INSTANCE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void showPreviewFrame(final @NotNull Module module, final @NotNull VirtualFile formFile, final @Nullable Locale stringDescriptorLocale) {
        String tempPath;
        if (module == null) {
            PreviewFormAction.$$$reportNull$$$0(3);
        }
        if (formFile == null) {
            PreviewFormAction.$$$reportNull$$$0(4);
        }
        try {
            File tempDirectory = FileUtil.createTempDirectory((String)"FormPreview", (String)"");
            tempPath = tempDirectory.getAbsolutePath();
            CopyResourcesUtil.copyFormsRuntime((String)tempPath, (boolean)true);
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)module.getProject(), (String)UIDesignerBundle.message("error.cannot.preview.form", formFile.getPath().replace('/', File.separatorChar), e.toString()), (String)CommonBundle.getErrorTitle());
            return;
        }
        URL[] platformUrls = null;
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk != null && sdk.getHomePath() != null && JavaSdk.getInstance().isOfVersionOrHigher(sdk, JavaSdkVersion.JDK_1_9)) {
            try {
                platformUrls = new URL[]{InstrumentationClassFinder.createJDKPlatformUrl((String)sdk.getHomePath())};
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        final PathsList sources = OrderEnumerator.orderEntries((Module)module).withoutSdk().withoutLibraries().withoutDepModules().getSourcePathsList();
        String classPath = OrderEnumerator.orderEntries((Module)module).recursively().getPathsList().getPathsString() + File.pathSeparator + sources.getPathsString() + File.pathSeparator + tempPath;
        InstrumentationClassFinder finder = PreviewFormAction.createClassFinder(platformUrls, classPath);
        try {
            LwRootContainer rootContainer;
            Document doc = FileDocumentManager.getInstance().getDocument(formFile);
            try {
                rootContainer = Utils.getRootContainer((String)doc.getText(), (PropertiesProvider)new CompiledClassPropertiesProvider(finder.getLoader()));
            }
            catch (Exception e) {
                Messages.showErrorDialog((Project)module.getProject(), (String)UIDesignerBundle.message("error.cannot.read.form", formFile.getPath().replace('/', File.separatorChar), e.getMessage()), (String)CommonBundle.getErrorTitle());
                finder.releaseResources();
                return;
            }
            if (rootContainer.getComponentCount() == 0) {
                Messages.showErrorDialog((Project)module.getProject(), (String)UIDesignerBundle.message("error.cannot.preview.empty.form", formFile.getPath().replace('/', File.separatorChar)), (String)CommonBundle.getErrorTitle());
                return;
            }
            PreviewFormAction.setPreviewBindings(rootContainer, CLASS_TO_BIND_NAME);
            try {
                PreviewNestedFormLoader nestedFormLoader = new PreviewNestedFormLoader(module, tempPath, finder);
                File tempFile = CopyResourcesUtil.copyClass((String)tempPath, (String)CLASS_TO_BIND_RESOURCE_NAME, (boolean)true);
                CopyResourcesUtil.copyClass((String)tempPath, (String)"com/intellij/uiDesigner/FormPreviewFrame$MyExitAction", (boolean)true);
                CopyResourcesUtil.copyClass((String)tempPath, (String)"com/intellij/uiDesigner/FormPreviewFrame$MyPackAction", (boolean)true);
                CopyResourcesUtil.copyClass((String)tempPath, (String)"com/intellij/uiDesigner/FormPreviewFrame$MySetLafAction", (boolean)true);
                Locale locale = Locale.getDefault();
                if (locale.getCountry().length() > 0 && locale.getLanguage().length() > 0) {
                    CopyResourcesUtil.copyProperties((String)tempPath, (String)("RuntimeBundle_" + locale.getLanguage() + "_" + locale.getCountry() + ".properties"));
                }
                if (locale.getLanguage().length() > 0) {
                    CopyResourcesUtil.copyProperties((String)tempPath, (String)("RuntimeBundle_" + locale.getLanguage() + ".properties"));
                }
                CopyResourcesUtil.copyProperties((String)tempPath, (String)("RuntimeBundle_" + locale.getLanguage() + ".properties"));
                CopyResourcesUtil.copyProperties((String)tempPath, (String)"RuntimeBundle.properties");
                AsmCodeGenerator codeGenerator = new AsmCodeGenerator(rootContainer, finder, (NestedFormLoader)nestedFormLoader, true, (ClassWriter)new PsiClassWriter(module));
                codeGenerator.patchFile(tempFile);
                FormErrorInfo[] errors = codeGenerator.getErrors();
                if (errors.length != 0) {
                    Messages.showErrorDialog((Project)module.getProject(), (String)UIDesignerBundle.message("error.cannot.preview.form", formFile.getPath().replace('/', File.separatorChar), errors[0].getErrorMessage()), (String)CommonBundle.getErrorTitle());
                    return;
                }
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
                Messages.showErrorDialog((Project)module.getProject(), (String)UIDesignerBundle.message("error.cannot.preview.form", formFile.getPath().replace('/', File.separatorChar), e.getMessage() != null ? e.getMessage() : e.toString()), (String)CommonBundle.getErrorTitle());
                return;
            }
            final HashSet bundleSet = new HashSet();
            FormEditingUtil.iterateStringDescriptors((IComponent)rootContainer, (FormEditingUtil.StringDescriptorVisitor<? super IComponent>)new FormEditingUtil.StringDescriptorVisitor<IComponent>(){

                @Override
                public boolean visit(IComponent component, StringDescriptor descriptor) {
                    if (descriptor.getBundleName() != null) {
                        bundleSet.add(descriptor.getDottedBundleName());
                    }
                    return true;
                }
            });
            if (bundleSet.size() > 0) {
                HashSet<VirtualFile> virtualFiles = new HashSet<VirtualFile>();
                HashSet<Module> modules = new HashSet<Module>();
                PropertiesReferenceManager manager = PropertiesReferenceManager.getInstance((Project)module.getProject());
                for (String bundleName : bundleSet) {
                    for (PropertiesFile propFile : manager.findPropertiesFiles(module, bundleName)) {
                        virtualFiles.add(propFile.getVirtualFile());
                        Module moduleForFile = ModuleUtil.findModuleForFile((VirtualFile)propFile.getVirtualFile(), (Project)module.getProject());
                        if (moduleForFile == null) continue;
                        modules.add(moduleForFile);
                    }
                }
                FileSetCompileScope scope = new FileSetCompileScope(virtualFiles, modules.toArray(Module.EMPTY_ARRAY));
                CompilerManager.getInstance((Project)module.getProject()).make((CompileScope)scope, new CompileStatusNotification(){

                    public void finished(boolean aborted, int errors, int warnings, @NotNull CompileContext compileContext) {
                        if (compileContext == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (!aborted && errors == 0) {
                            PreviewFormAction.runPreviewProcess(tempPath, sources, module, formFile, stringDescriptorLocale);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compileContext", "com/intellij/uiDesigner/actions/PreviewFormAction$2", "finished"));
                    }
                });
            } else {
                PreviewFormAction.runPreviewProcess(tempPath, sources, module, formFile, stringDescriptorLocale);
            }
        }
        finally {
            finder.releaseResources();
        }
    }

    public static void setPreviewBindings(LwRootContainer rootContainer, String classToBindName) {
        rootContainer.setClassToBind(classToBindName);
        FormEditingUtil.iterate((IComponent)rootContainer, new FormEditingUtil.ComponentVisitor<LwComponent>(){

            @Override
            public boolean visit(LwComponent iComponent) {
                iComponent.setBinding(null);
                return true;
            }
        });
        if (rootContainer.getComponentCount() == 1) {
            ((LwComponent)rootContainer.getComponent(0)).setBinding(PREVIEW_BINDING_FIELD);
        }
    }

    private static void runPreviewProcess(String tempPath, PathsList sources, Module module, VirtualFile formFile, @Nullable Locale stringDescriptorLocale) {
        JavaParameters parameters = new JavaParameters();
        parameters.getClassPath().add(tempPath);
        parameters.getClassPath().add(PathManager.getJarPathForClass(CellConstraints.class));
        List paths = sources.getPathList();
        for (String path : paths) {
            parameters.getClassPath().add(path);
        }
        try {
            parameters.configureByModule(module, 3);
        }
        catch (CantRunException e) {
            Messages.showErrorDialog((Project)module.getProject(), (String)UIDesignerBundle.message("error.cannot.preview.form", formFile.getPath().replace('/', File.separatorChar), e.getMessage()), (String)CommonBundle.getErrorTitle());
            return;
        }
        parameters.setMainClass(CLASS_TO_BIND_NAME);
        parameters.setWorkingDirectory(tempPath);
        if (stringDescriptorLocale != null && stringDescriptorLocale.getDisplayName().length() > 0) {
            parameters.getVMParametersList().add("-Duser.language=" + stringDescriptorLocale.getLanguage());
        }
        try {
            MyRunProfile profile = new MyRunProfile(module, parameters, tempPath, UIDesignerBundle.message("progress.preview.started", formFile.getPresentableUrl()));
            ExecutionEnvironmentBuilder.create((Project)module.getProject(), (Executor)DefaultRunExecutor.getRunExecutorInstance(), (RunProfile)profile).buildAndExecute();
        }
        catch (ExecutionException e) {
            Messages.showErrorDialog((Project)module.getProject(), (String)UIDesignerBundle.message("error.cannot.preview.form", formFile.getPath().replace('/', File.separatorChar), e.getMessage()), (String)CommonBundle.getErrorTitle());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uiDesigner/actions/PreviewFormAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createClassFinder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showPreviewFrame";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyRunProfile
    implements ModuleRunProfile {
        private final Module myModule;
        private final JavaParameters myParams;
        private final String myTempPath;
        @Nls
        private final String myStatusbarMessage;

        MyRunProfile(Module module, JavaParameters params, String tempPath, @Nls String statusbarMessage) {
            this.myModule = module;
            this.myParams = params;
            this.myTempPath = tempPath;
            this.myStatusbarMessage = statusbarMessage;
        }

        public Icon getIcon() {
            return null;
        }

        public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
            if (executor == null) {
                MyRunProfile.$$$reportNull$$$0(0);
            }
            if (env == null) {
                MyRunProfile.$$$reportNull$$$0(1);
            }
            return new JavaCommandLineState(env){

                protected JavaParameters createJavaParameters() {
                    return myParams;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @NotNull
                public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
                    if (executor == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (runner == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    ExecutionResult executionResult = super.execute(executor, runner);
                    executionResult.getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void processTerminated(@NotNull ProcessEvent event) {
                            if (event == null) {
                                MyRunProfile.1.$$$reportNull$$$0(0);
                            }
                            FileUtil.asyncDelete((File)new File(myTempPath));
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/uiDesigner/actions/PreviewFormAction$MyRunProfile$1$1", "processTerminated"));
                        }
                    });
                    ExecutionResult executionResult2 = executionResult;
                    ExecutionResult executionResult3 = executionResult2;
                    if (executionResult3 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return executionResult3;
                    finally {
                        Project project = myModule.getProject();
                        SwingUtilities.invokeLater(() -> WindowManager.getInstance().getStatusBar(project).setInfo(myStatusbarMessage));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "executor";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "runner";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/uiDesigner/actions/PreviewFormAction$MyRunProfile$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/uiDesigner/actions/PreviewFormAction$MyRunProfile$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "execute";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "execute";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }

        @NotNull
        public String getName() {
            String string = UIDesignerBundle.message("title.form.preview", new Object[0]);
            if (string == null) {
                MyRunProfile.$$$reportNull$$$0(2);
            }
            return string;
        }

        public Module @NotNull [] getModules() {
            Module[] moduleArray = new Module[]{this.myModule};
            if (moduleArray == null) {
                MyRunProfile.$$$reportNull$$$0(3);
            }
            return moduleArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/uiDesigner/actions/PreviewFormAction$MyRunProfile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/uiDesigner/actions/PreviewFormAction$MyRunProfile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModules";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getState";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

