/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scripting.gradle;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposable;
import org.jetbrains.kotlin.idea.core.script.configuration.listener.ScriptChangeListener;
import org.jetbrains.kotlin.idea.scripting.gradle.GradleScriptFileChangeListener;
import org.jetbrains.kotlin.idea.scripting.gradle.legacy.GradleLegacyScriptListener;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.GradleBuildRootsManager;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/scripting/gradle/GradleScriptListener;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/listener/ScriptChangeListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "buildRootsManager", "Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleBuildRootsManager;", "legacy", "Lorg/jetbrains/kotlin/idea/scripting/gradle/legacy/GradleLegacyScriptListener;", "documentChanged", "", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "editorActivated", "fileChanged", "filePath", "", "ts", "", "isApplicable", "", "isCustomScriptingSupport", "kotlin.gradle.gradle-idea"})
public final class GradleScriptListener
extends ScriptChangeListener {
    private final GradleLegacyScriptListener legacy;
    private final GradleBuildRootsManager buildRootsManager;

    public final void fileChanged(@NotNull String filePath, long ts) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.buildRootsManager.fileChanged(filePath, ts);
    }

    public boolean isApplicable(@NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        return this.legacy.isApplicable(vFile);
    }

    private final boolean isCustomScriptingSupport(VirtualFile vFile) {
        return this.buildRootsManager.isApplicable(vFile);
    }

    public void editorActivated(@NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        if (this.isCustomScriptingSupport(vFile)) {
            this.buildRootsManager.updateNotifications(false, (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(vFile){
                final /* synthetic */ VirtualFile $vFile;

                public final boolean invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it, (Object)this.$vFile.getPath());
                }
                {
                    this.$vFile = virtualFile;
                    super(1);
                }
            }));
        } else {
            this.legacy.editorActivated(vFile);
        }
    }

    public void documentChanged(@NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        String string = vFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"vFile.path");
        this.fileChanged(string, System.currentTimeMillis());
        if (!this.isCustomScriptingSupport(vFile)) {
            this.legacy.documentChanged(vFile);
        }
    }

    public GradleScriptListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.legacy = new GradleLegacyScriptListener(project);
        this.buildRootsManager = GradleBuildRootsManager.Companion.getInstance(project);
        GradleScriptFileChangeListener listener2 = new GradleScriptFileChangeListener(this, this.buildRootsManager);
        VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)listener2, KotlinPluginDisposable.Companion.getInstance(project));
    }
}

