/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scripting.gradle;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFileBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.KotlinIdeaGradleBundle;
import org.jetbrains.kotlin.idea.scripting.gradle.GradleImportHelperKt;
import org.jetbrains.kotlin.idea.scripting.gradle.UtilsKt;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.GradleBuildRoot;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.GradleBuildRootsManager;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/scripting/gradle/LoadConfigurationAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "ensureValidActionVisibility", "getKotlinScriptFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getNotificationVisibility", "", "update", "kotlin.gradle.gradle-idea"})
public final class LoadConfigurationAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"e.getData(CommonDataKeys.EDITOR) ?: return");
        Editor editor2 = editor;
        VirtualFile virtualFile = this.getKotlinScriptFile(editor2);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        Object object = GradleBuildRootsManager.Companion.getInstance(project2).getScriptInfo(file);
        if (object == null || (object = object.getBuildRoot()) == null) {
            return;
        }
        Object root = object;
        GradleImportHelperKt.runPartialGradleImport(project2, (GradleBuildRoot)root);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.ensureValidActionVisibility(e);
    }

    private final void ensureValidActionVisibility(AnActionEvent e) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"e.getData(CommonDataKeys.EDITOR) ?: return");
        Editor editor2 = editor;
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setVisible(this.getNotificationVisibility(editor2));
    }

    private final boolean getNotificationVisibility(Editor editor) {
        if (!GradleImportHelperKt.getScriptConfigurationsNeedToBeUpdatedBalloon()) {
            return false;
        }
        if (DiffUtil.isDiffEditor((Editor)editor)) {
            return false;
        }
        Project project = editor.getProject();
        if (project == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"editor.project ?: return false");
        Project project2 = project;
        VirtualFile virtualFile = this.getKotlinScriptFile(editor);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file = virtualFile;
        if (GradleImportHelperKt.autoReloadScriptConfigurations(project2, file)) {
            return false;
        }
        return GradleBuildRootsManager.Companion.getInstance(project2).isConfigurationOutOfDate(file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final VirtualFile getKotlinScriptFile(Editor editor) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (virtualFile == null) return null;
        VirtualFile virtualFile2 = virtualFile;
        boolean bl = false;
        boolean bl2 = false;
        VirtualFile it = virtualFile2;
        boolean bl3 = false;
        if (it instanceof LightVirtualFileBase) return null;
        VirtualFile virtualFile3 = it;
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"it");
        if (!virtualFile3.isValid()) return null;
        if (!Intrinsics.areEqual((Object)it.getFileType(), (Object)KotlinFileType.INSTANCE)) return null;
        if (!UtilsKt.isGradleKotlinScript(it)) return null;
        boolean bl4 = true;
        if (!bl4) return null;
        VirtualFile virtualFile4 = virtualFile2;
        return virtualFile4;
    }

    public LoadConfigurationAction() {
        super(KotlinIdeaGradleBundle.message("action.text.load.script.configurations", new Object[0]), KotlinIdeaGradleBundle.message("action.description.load.script.configurations", new Object[0]), KotlinIcons.LOAD_SCRIPT_CONFIGURATION);
    }
}

