/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.LineSeparatorPanel;
import com.intellij.util.LineSeparator;
import java.util.List;
import org.editorconfig.Utils;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.plugincomponents.SettingsProviderComponent;
import org.jetbrains.annotations.NotNull;

public final class LineEndingsManager
implements FileDocumentManagerListener {
    public static final String lineEndingsKey = "end_of_line";
    private boolean statusBarUpdated = false;

    public void beforeAllDocumentsSaving() {
        this.statusBarUpdated = false;
    }

    private static void updateStatusBar(Project project) {
        ApplicationManager.getApplication().invokeLater(() -> {
            StatusBarWidget widget;
            IdeFrame frame = WindowManager.getInstance().getIdeFrame(project);
            StatusBar statusBar = frame != null ? frame.getStatusBar() : null;
            StatusBarWidget statusBarWidget = widget = statusBar == null ? null : statusBar.getWidget("LineSeparator");
            if (widget instanceof LineSeparatorPanel) {
                ((LineSeparatorPanel)widget).selectionChanged((VirtualFile)null);
            }
        });
    }

    public void beforeDocumentSaving(@NotNull Document document) {
        if (document == null) {
            LineEndingsManager.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        if (file == null) {
            return;
        }
        Project project = ProjectLocator.getInstance().guessProjectForFile(file);
        if (project != null) {
            this.applySettings(project, file);
        }
    }

    private void applySettings(Project project, VirtualFile file) {
        if (!Utils.isEnabled(CodeStyle.getSettings((Project)project))) {
            return;
        }
        List<EditorConfig.OutPair> outPairs = SettingsProviderComponent.getInstance().getOutPairs(project, file);
        String lineEndings = Utils.configValueForKey(outPairs, lineEndingsKey);
        if (lineEndings.isEmpty()) {
            return;
        }
        try {
            LineSeparator separator = LineSeparator.valueOf((String)StringUtil.toUpperCase((String)lineEndings));
            String oldSeparator = file.getDetectedLineSeparator();
            String newSeparator = separator.getSeparatorString();
            if (!StringUtil.equals((CharSequence)oldSeparator, (CharSequence)newSeparator)) {
                file.setDetectedLineSeparator(newSeparator);
                if (!this.statusBarUpdated) {
                    this.statusBarUpdated = true;
                    LineEndingsManager.updateStatusBar(project);
                }
            }
        }
        catch (IllegalArgumentException e) {
            Utils.invalidConfigMessage(project, lineEndings, lineEndingsKey, file.getCanonicalPath());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/editorconfig/configmanagement/LineEndingsManager", "beforeDocumentSaving"));
    }
}

