/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.jna.JnaLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.io.win32.FileInfo;
import com.intellij.openapi.util.io.win32.IdeaWin32;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.LimitedPool;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.mac.CoreFoundation;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileSystemUtil {
    static final String FORCE_USE_NIO2_KEY = "idea.io.use.nio2";
    private static final String COARSE_TIMESTAMP_KEY = "idea.io.coarse.ts";
    @ApiStatus.Internal
    public static final boolean DO_NOT_RESOLVE_SYMLINKS = Boolean.getBoolean("idea.symlinks.no.resolve");
    private static final Logger LOG = Logger.getInstance(FileSystemUtil.class);
    private static final Mediator ourMediator = FileSystemUtil.computeMediator();
    private static volatile boolean ourLibExt2FsPresent = true;

    static Mediator computeMediator() {
        if (!Boolean.getBoolean(FORCE_USE_NIO2_KEY)) {
            try {
                if (SystemInfo.isWindows && IdeaWin32.isAvailable()) {
                    return FileSystemUtil.check(new IdeaWin32MediatorImpl());
                }
                if ((SystemInfo.isLinux || SystemInfo.isMac && !SystemInfo.isArm64 || SystemInfo.isSolaris || SystemInfo.isFreeBSD) && JnaLoader.isLoaded()) {
                    return FileSystemUtil.check(new JnaUnixMediatorImpl());
                }
            }
            catch (Throwable t) {
                LOG.warn("Failed to load filesystem access layer: " + SystemInfo.OS_NAME + ", " + SystemInfo.JAVA_VERSION, t);
            }
        }
        return new Nio2MediatorImpl();
    }

    private static Mediator check(Mediator mediator) throws Exception {
        String quickTestPath = SystemInfo.isWindows ? "C:\\" : "/";
        mediator.getAttributes(quickTestPath);
        return mediator;
    }

    private FileSystemUtil() {
    }

    @Nullable
    public static FileAttributes getAttributes(@NotNull String path) {
        if (path == null) {
            FileSystemUtil.$$$reportNull$$$0(0);
        }
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("getAttributes(" + path + ")");
                long t = System.nanoTime();
                FileAttributes result = ourMediator.getAttributes(path);
                t = (System.nanoTime() - t) / 1000L;
                LOG.trace("  " + t + " mks");
                return result;
            }
            return ourMediator.getAttributes(path);
        }
        catch (Exception e) {
            LOG.warn(e);
            return null;
        }
    }

    @Nullable
    public static FileAttributes getAttributes(@NotNull File file) {
        if (file == null) {
            FileSystemUtil.$$$reportNull$$$0(1);
        }
        return FileSystemUtil.getAttributes(file.getPath());
    }

    public static long lastModified(@NotNull File file) {
        FileAttributes attributes;
        if (file == null) {
            FileSystemUtil.$$$reportNull$$$0(2);
        }
        return (attributes = FileSystemUtil.getAttributes(file)) != null ? attributes.lastModified : 0L;
    }

    public static boolean isSymLink(@NotNull String path) {
        if (path == null) {
            FileSystemUtil.$$$reportNull$$$0(3);
        }
        if (SystemInfo.areSymLinksSupported) {
            FileAttributes attributes = FileSystemUtil.getAttributes(path);
            return attributes != null && attributes.isSymLink();
        }
        return false;
    }

    public static boolean isSymLink(@NotNull File file) {
        if (file == null) {
            FileSystemUtil.$$$reportNull$$$0(4);
        }
        return FileSystemUtil.isSymLink(file.getAbsolutePath());
    }

    @Nullable
    public static String resolveSymLink(@NotNull String path) {
        if (path == null) {
            FileSystemUtil.$$$reportNull$$$0(5);
        }
        try {
            String realPath;
            if (LOG.isTraceEnabled()) {
                LOG.trace("resolveSymLink(" + path + ")");
                long t = System.nanoTime();
                realPath = ourMediator.resolveSymLink(path);
                t = (System.nanoTime() - t) / 1000L;
                LOG.trace("  " + t + " mks");
            } else {
                realPath = ourMediator.resolveSymLink(path);
            }
            if (realPath != null && (SystemInfo.isWindows && realPath.startsWith("\\\\") || new File(realPath).exists())) {
                return realPath;
            }
        }
        catch (Exception e) {
            LOG.warn(e);
        }
        return null;
    }

    @Nullable
    public static String resolveSymLink(@NotNull File file) {
        if (file == null) {
            FileSystemUtil.$$$reportNull$$$0(6);
        }
        return FileSystemUtil.resolveSymLink(file.getAbsolutePath());
    }

    public static boolean clonePermissions(@NotNull String source, @NotNull String target) {
        if (source == null) {
            FileSystemUtil.$$$reportNull$$$0(7);
        }
        if (target == null) {
            FileSystemUtil.$$$reportNull$$$0(8);
        }
        try {
            return ourMediator.clonePermissions(source, target, false);
        }
        catch (Exception e) {
            LOG.warn(e);
            return false;
        }
    }

    public static boolean clonePermissionsToExecute(@NotNull String source, @NotNull String target) {
        if (source == null) {
            FileSystemUtil.$$$reportNull$$$0(9);
        }
        if (target == null) {
            FileSystemUtil.$$$reportNull$$$0(10);
        }
        try {
            return ourMediator.clonePermissions(source, target, true);
        }
        catch (Exception e) {
            LOG.warn(e);
            return false;
        }
    }

    @NotNull
    public static FileAttributes.CaseSensitivity readParentCaseSensitivity(@NotNull File anyChild) {
        block22: {
            FileAttributes.CaseSensitivity caseSensitivity;
            String altPath;
            FileAttributes newAttributes;
            String name;
            String altName;
            if (anyChild == null) {
                FileSystemUtil.$$$reportNull$$$0(11);
            }
            File parent = anyChild.getParentFile();
            if (JnaLoader.isLoaded()) {
                String path = (parent != null ? parent : anyChild).getAbsolutePath();
                FileAttributes.CaseSensitivity detected = FileAttributes.CaseSensitivity.UNKNOWN;
                if (SystemInfo.isWin10OrNewer && OSAgnosticPathUtil.isAbsoluteDosPath(path)) {
                    detected = FileSystemUtil.getNtfsCaseSensitivity(path);
                } else if (SystemInfo.isMac) {
                    detected = FileSystemUtil.getMacOsCaseSensitivity(path);
                } else if (SystemInfo.isLinux) {
                    detected = FileSystemUtil.getLinuxCaseSensitivity(path);
                }
                if (detected != FileAttributes.CaseSensitivity.UNKNOWN) {
                    FileAttributes.CaseSensitivity caseSensitivity2 = detected;
                    if (caseSensitivity2 == null) {
                        FileSystemUtil.$$$reportNull$$$0(12);
                    }
                    return caseSensitivity2;
                }
            }
            if (parent == null) {
                String probe = FileSystemUtil.findCaseToggleableChild(anyChild);
                if (probe == null) {
                    FileAttributes.CaseSensitivity caseSensitivity3 = FileAttributes.CaseSensitivity.UNKNOWN;
                    if (caseSensitivity3 == null) {
                        FileSystemUtil.$$$reportNull$$$0(13);
                    }
                    return caseSensitivity3;
                }
                parent = anyChild;
                anyChild = new File(parent, probe);
            }
            if ((altName = FileSystemUtil.toggleCase(name = anyChild.getName())).equals(name)) {
                name = FileSystemUtil.findCaseToggleableChild(parent);
                if (name == null) {
                    FileAttributes.CaseSensitivity caseSensitivity4 = FileAttributes.CaseSensitivity.UNKNOWN;
                    if (caseSensitivity4 == null) {
                        FileSystemUtil.$$$reportNull$$$0(14);
                    }
                    return caseSensitivity4;
                }
                altName = FileSystemUtil.toggleCase(name);
            }
            if ((newAttributes = FileSystemUtil.getAttributes(altPath = parent.getPath() + '/' + altName)) == null) {
                FileAttributes.CaseSensitivity caseSensitivity5 = FileAttributes.CaseSensitivity.SENSITIVE;
                if (caseSensitivity5 == null) {
                    FileSystemUtil.$$$reportNull$$$0(15);
                }
                return caseSensitivity5;
            }
            try {
                File altCanonicalFile = new File(altPath).getCanonicalFile();
                String altCanonicalName = altCanonicalFile.getName();
                if (!altCanonicalName.equals(name) && !altCanonicalName.equals(anyChild.getCanonicalFile().getName())) break block22;
                caseSensitivity = FileAttributes.CaseSensitivity.INSENSITIVE;
            }
            catch (IOException e) {
                FileAttributes.CaseSensitivity caseSensitivity6 = FileAttributes.CaseSensitivity.UNKNOWN;
                if (caseSensitivity6 == null) {
                    FileSystemUtil.$$$reportNull$$$0(17);
                }
                return caseSensitivity6;
            }
            if (caseSensitivity == null) {
                FileSystemUtil.$$$reportNull$$$0(16);
            }
            return caseSensitivity;
        }
        FileAttributes.CaseSensitivity caseSensitivity = FileAttributes.CaseSensitivity.SENSITIVE;
        if (caseSensitivity == null) {
            FileSystemUtil.$$$reportNull$$$0(18);
        }
        return caseSensitivity;
    }

    private static String toggleCase(@NotNull String name) {
        String altName;
        if (name == null) {
            FileSystemUtil.$$$reportNull$$$0(19);
        }
        if ((altName = name.toUpperCase(Locale.getDefault())).equals(name)) {
            altName = name.toLowerCase(Locale.getDefault());
        }
        return altName;
    }

    public static boolean isCaseSensitive(@NotNull String name) {
        if (name == null) {
            FileSystemUtil.$$$reportNull$$$0(20);
        }
        return !FileSystemUtil.toggleCase(name).equals(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String findCaseToggleableChild(@NotNull File dir) {
        if (dir == null) {
            FileSystemUtil.$$$reportNull$$$0(21);
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir.toPath());){
            Path path;
            String name;
            Iterator<Path> iterator = stream.iterator();
            do {
                if (!iterator.hasNext()) return null;
            } while ((name = (path = iterator.next()).getFileName().toString()).toLowerCase(Locale.getDefault()).equals(name.toUpperCase(Locale.getDefault())));
            String string = name;
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    private static FileAttributes.CaseSensitivity getNtfsCaseSensitivity(@NotNull String path) {
        block10: {
            NtOsKrnl.FILE_CASE_SENSITIVE_INFORMATION_P fileInformation;
            block12: {
                block11: {
                    if (path == null) {
                        FileSystemUtil.$$$reportNull$$$0(22);
                    }
                    NtOsKrnl ntOsKrnl = NtOsKrnl.INSTANCE;
                    NtOsKrnl.OBJECT_ATTRIBUTES_P objectAttributes = new NtOsKrnl.OBJECT_ATTRIBUTES_P();
                    objectAttributes.ObjectName = new NtOsKrnl.UNICODE_STRING_P("\\??\\" + path);
                    fileInformation = new NtOsKrnl.FILE_CASE_SENSITIVE_INFORMATION_P();
                    int result = ntOsKrnl.NtQueryInformationByName(objectAttributes, new NtOsKrnl.IO_STATUS_BLOCK_P(), fileInformation, fileInformation.size(), 71);
                    if (result != 0) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("NtQueryInformationByName(" + path + "): " + result);
                        }
                        break block10;
                    }
                    if (fileInformation.Flags != 0L) break block11;
                    FileAttributes.CaseSensitivity caseSensitivity = FileAttributes.CaseSensitivity.INSENSITIVE;
                    if (caseSensitivity == null) {
                        FileSystemUtil.$$$reportNull$$$0(23);
                    }
                    return caseSensitivity;
                }
                if (fileInformation.Flags != 1L) break block12;
                FileAttributes.CaseSensitivity caseSensitivity = FileAttributes.CaseSensitivity.SENSITIVE;
                if (caseSensitivity == null) {
                    FileSystemUtil.$$$reportNull$$$0(24);
                }
                return caseSensitivity;
            }
            try {
                LOG.warn("NtQueryInformationByName(" + path + "): unexpected 'FileCaseSensitiveInformation' value " + fileInformation.Flags);
            }
            catch (Throwable t) {
                LOG.warn("path: " + path, t);
            }
        }
        FileAttributes.CaseSensitivity caseSensitivity = FileAttributes.CaseSensitivity.UNKNOWN;
        if (caseSensitivity == null) {
            FileSystemUtil.$$$reportNull$$$0(25);
        }
        return caseSensitivity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    private static FileAttributes.CaseSensitivity getMacOsCaseSensitivity(@NotNull String path) {
        block11: {
            CoreFoundation.CFTypeRef url;
            block10: {
                if (path == null) {
                    FileSystemUtil.$$$reportNull$$$0(26);
                }
                CoreFoundation cf = CoreFoundation.INSTANCE;
                url = cf.CFURLCreateFromFileSystemRepresentation(null, path, path.length(), true);
                PointerByReference resultPtr = new PointerByReference();
                if (!cf.CFURLCopyResourcePropertyForKey(url, CoreFoundation.kCFURLVolumeSupportsCaseSensitiveNamesKey, resultPtr, null)) {
                    LOG.warn("CFURLCopyResourcePropertyForKey(" + path + "): error");
                    break block10;
                }
                Pointer result = resultPtr.getValue();
                if (result == null) {
                    LOG.info("CFURLCopyResourcePropertyForKey(" + path + "): property not available");
                    break block10;
                }
                boolean value = new CoreFoundation.CFBooleanRef(result).booleanValue();
                FileAttributes.CaseSensitivity caseSensitivity = value ? FileAttributes.CaseSensitivity.SENSITIVE : FileAttributes.CaseSensitivity.INSENSITIVE;
                url.release();
                FileAttributes.CaseSensitivity caseSensitivity2 = caseSensitivity;
                if (caseSensitivity2 == null) {
                    FileSystemUtil.$$$reportNull$$$0(27);
                }
                return caseSensitivity2;
            }
            try {
                url.release();
                break block11;
                {
                    catch (Throwable throwable) {
                        url.release();
                        throw throwable;
                    }
                }
            }
            catch (Throwable t) {
                LOG.warn("path: " + path, t);
            }
        }
        FileAttributes.CaseSensitivity caseSensitivity = FileAttributes.CaseSensitivity.UNKNOWN;
        if (caseSensitivity == null) {
            FileSystemUtil.$$$reportNull$$$0(28);
        }
        return caseSensitivity;
    }

    @NotNull
    private static FileAttributes.CaseSensitivity getLinuxCaseSensitivity(@NotNull String path) {
        block14: {
            FileAttributes.CaseSensitivity caseSensitivity;
            long fs;
            block16: {
                block15: {
                    if (path == null) {
                        FileSystemUtil.$$$reportNull$$$0(29);
                    }
                    Memory buf = new Memory(256L);
                    if (LibC.INSTANCE.statfs(path, buf) != 0) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("statfs(" + path + "): error");
                        }
                        break block14;
                    }
                    long l = fs = SystemInfo.is32Bit ? (long)buf.getInt(0L) : buf.getLong(0L);
                    if (fs != -1859950530L && fs != 1481003842L) break block15;
                    FileAttributes.CaseSensitivity caseSensitivity2 = FileAttributes.CaseSensitivity.SENSITIVE;
                    if (caseSensitivity2 == null) {
                        FileSystemUtil.$$$reportNull$$$0(30);
                    }
                    return caseSensitivity2;
                }
                if (fs != 19780L) break block16;
                FileAttributes.CaseSensitivity caseSensitivity3 = FileAttributes.CaseSensitivity.INSENSITIVE;
                if (caseSensitivity3 == null) {
                    FileSystemUtil.$$$reportNull$$$0(31);
                }
                return caseSensitivity3;
            }
            try {
                if (fs != 61267L && fs != -218816496L || !ourLibExt2FsPresent) break block14;
                LongByReference flags = new LongByReference();
                if (E2P.INSTANCE.fgetflags(path, flags) == 0) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("fgetflags(" + path + "): error");
                    }
                    break block14;
                }
                caseSensitivity = (flags.getValue() & 0x40000000L) != 0L ? FileAttributes.CaseSensitivity.INSENSITIVE : FileAttributes.CaseSensitivity.SENSITIVE;
            }
            catch (UnsatisfiedLinkError e) {
                ourLibExt2FsPresent = false;
                LOG.warn(e);
                break block14;
            }
            catch (Throwable t) {
                LOG.warn("path: " + path, t);
            }
            if (caseSensitivity == null) {
                FileSystemUtil.$$$reportNull$$$0(32);
            }
            return caseSensitivity;
        }
        FileAttributes.CaseSensitivity caseSensitivity = FileAttributes.CaseSensitivity.UNKNOWN;
        if (caseSensitivity == null) {
            FileSystemUtil.$$$reportNull$$$0(33);
        }
        return caseSensitivity;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anyChild";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/io/FileSystemUtil";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/io/FileSystemUtil";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "readParentCaseSensitivity";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getNtfsCaseSensitivity";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacOsCaseSensitivity";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinuxCaseSensitivity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "lastModified";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSymLink";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymLink";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "clonePermissions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "clonePermissionsToExecute";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readParentCaseSensitivity";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "toggleCase";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isCaseSensitive";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findCaseToggleableChild";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getNtfsCaseSensitivity";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getMacOsCaseSensitivity";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getLinuxCaseSensitivity";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface E2P
    extends Library {
        public static final E2P INSTANCE = (E2P)Native.load((String)"e2p", E2P.class);
        public static final long CASE_FOLD = 0x40000000L;

        public int fgetflags(String var1, LongByReference var2);
    }

    private static interface LibC
    extends Library {
        public static final LibC INSTANCE = (LibC)Native.load(LibC.class);

        public int statfs(String var1, Memory var2);
    }

    private static interface CoreFoundation
    extends com.sun.jna.platform.mac.CoreFoundation {
        public static final CoreFoundation INSTANCE = (CoreFoundation)Native.load((String)"CoreFoundation", CoreFoundation.class);
        public static final CoreFoundation.CFStringRef kCFURLVolumeSupportsCaseSensitiveNamesKey = CoreFoundation.CFStringRef.createCFString((String)"NSURLVolumeSupportsCaseSensitiveNamesKey");

        public CoreFoundation.CFTypeRef CFURLCreateFromFileSystemRepresentation(CoreFoundation.CFAllocatorRef var1, String var2, long var3, boolean var5);

        public boolean CFURLCopyResourcePropertyForKey(CoreFoundation.CFTypeRef var1, CoreFoundation.CFStringRef var2, PointerByReference var3, Pointer var4);
    }

    private static interface NtOsKrnl
    extends StdCallLibrary,
    WinNT {
        public static final NtOsKrnl INSTANCE = (NtOsKrnl)Native.load((String)"NtDll", NtOsKrnl.class, (Map)W32APIOptions.UNICODE_OPTIONS);
        public static final int FileCaseSensitiveInformation = 71;

        public int NtQueryInformationByName(OBJECT_ATTRIBUTES_P var1, IO_STATUS_BLOCK_P var2, Structure var3, long var4, int var6);

        @Structure.FieldOrder(value={"Flags"})
        public static class FILE_CASE_SENSITIVE_INFORMATION_P
        extends Structure
        implements Structure.ByReference {
            public long Flags;
        }

        @Structure.FieldOrder(value={"Pointer", "Information"})
        public static class IO_STATUS_BLOCK_P
        extends Structure
        implements Structure.ByReference {
            public Pointer Pointer;
            public Pointer Information;
        }

        @Structure.FieldOrder(value={"Length", "RootDirectory", "ObjectName", "Attributes", "SecurityDescriptor", "SecurityQualityOfService"})
        public static class OBJECT_ATTRIBUTES_P
        extends Structure
        implements Structure.ByReference {
            public long Length = this.size();
            public WinNT.HANDLE RootDirectory;
            public UNICODE_STRING_P ObjectName;
            public long Attributes;
            public Pointer SecurityDescriptor;
            public Pointer SecurityQualityOfService;
        }

        @Structure.FieldOrder(value={"Length", "MaximumLength", "Buffer"})
        public static class UNICODE_STRING_P
        extends Structure
        implements Structure.ByReference {
            public short Length;
            public short MaximumLength;
            public WTypes.LPWSTR Buffer;

            public UNICODE_STRING_P(String value) {
                this.Buffer = new WTypes.LPWSTR(value);
                this.Length = this.MaximumLength = (short)(value.length() * 2);
            }
        }
    }

    private static class Nio2MediatorImpl
    implements Mediator {
        private final LinkOption[] myNoFollowLinkOptions = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
        private final PosixFilePermission[] myExecPermissions = new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE};

        private Nio2MediatorImpl() {
        }

        @Override
        public FileAttributes getAttributes(@NotNull String pathStr) {
            if (pathStr == null) {
                Nio2MediatorImpl.$$$reportNull$$$0(0);
            }
            try {
                boolean isWritable;
                boolean isHidden;
                boolean isSymbolicLink;
                Path path = Paths.get(pathStr, new String[0]);
                Class schema = SystemInfo.isWindows ? DosFileAttributes.class : PosixFileAttributes.class;
                DosFileAttributes attributes = Files.readAttributes(path, schema, this.myNoFollowLinkOptions);
                boolean bl = isSymbolicLink = attributes.isSymbolicLink() || SystemInfo.isWindows && attributes.isOther() && attributes.isDirectory() && path.getParent() != null;
                if (isSymbolicLink) {
                    try {
                        attributes = Files.readAttributes(path, schema, new LinkOption[0]);
                    }
                    catch (NoSuchFileException e) {
                        return FileAttributes.BROKEN_SYMLINK;
                    }
                }
                boolean isDirectory = attributes.isDirectory();
                boolean isOther = attributes.isOther();
                long size = attributes.size();
                long lastModified = attributes.lastModifiedTime().toMillis();
                if (SystemInfo.isWindows) {
                    isHidden = path.getParent() != null && attributes.isHidden();
                    isWritable = isDirectory || !attributes.isReadOnly();
                } else {
                    isHidden = false;
                    isWritable = Files.isWritable(path);
                }
                return new FileAttributes(isDirectory, isOther, isSymbolicLink, isHidden, size, lastModified, isWritable);
            }
            catch (IOException | InvalidPathException e) {
                LOG.debug(pathStr, e);
                return null;
            }
        }

        @Override
        public String resolveSymLink(@NotNull String path) throws IOException {
            if (path == null) {
                Nio2MediatorImpl.$$$reportNull$$$0(1);
            }
            try {
                return Paths.get(path, new String[0]).toRealPath(new LinkOption[0]).toString();
            }
            catch (NoSuchFileException e) {
                return null;
            }
        }

        @Override
        public boolean clonePermissions(@NotNull String source, @NotNull String target, boolean execOnly) throws IOException {
            Set<PosixFilePermission> newPermissions;
            if (source == null) {
                Nio2MediatorImpl.$$$reportNull$$$0(2);
            }
            if (target == null) {
                Nio2MediatorImpl.$$$reportNull$$$0(3);
            }
            if (!SystemInfo.isUnix) {
                return false;
            }
            Path sourcePath = Paths.get(source, new String[0]);
            Path targetPath = Paths.get(target, new String[0]);
            Set<PosixFilePermission> sourcePermissions = Files.readAttributes(sourcePath, PosixFileAttributes.class, new LinkOption[0]).permissions();
            Set<PosixFilePermission> targetPermissions = Files.readAttributes(targetPath, PosixFileAttributes.class, new LinkOption[0]).permissions();
            if (execOnly) {
                newPermissions = EnumSet.copyOf(targetPermissions);
                for (PosixFilePermission permission : this.myExecPermissions) {
                    if (sourcePermissions.contains((Object)permission)) {
                        newPermissions.add(permission);
                        continue;
                    }
                    newPermissions.remove((Object)permission);
                }
            } else {
                newPermissions = sourcePermissions;
            }
            Files.setAttribute(targetPath, "posix:permissions", newPermissions, new LinkOption[0]);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathStr";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/util/io/FileSystemUtil$Nio2MediatorImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAttributes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveSymLink";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clonePermissions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class JnaUnixMediatorImpl
    implements Mediator {
        private static final int[] LINUX_32 = new int[]{16, 44, 72, 24, 28};
        private static final int[] LINUX_64 = new int[]{24, 48, 88, 28, 32};
        private static final int[] LNX_PPC32 = new int[]{16, 48, 80, 24, 28};
        private static final int[] LNX_PPC64 = LINUX_64;
        private static final int[] LNX_ARM32 = LNX_PPC32;
        private static final int[] BSD_32 = new int[]{8, 48, 32, 12, 16};
        private static final int[] BSD_64 = new int[]{8, 72, 40, 12, 16};
        private static final int[] BSD_32_12 = new int[]{24, 96, 64, 28, 32};
        private static final int[] BSD_64_12 = new int[]{24, 112, 64, 28, 32};
        private static final int[] SUN_OS_32 = new int[]{20, 48, 64, 28, 32};
        private static final int[] SUN_OS_64 = new int[]{16, 40, 64, 24, 28};
        private static final int STAT_VER = 1;
        private static final int OFF_MODE = 0;
        private static final int OFF_SIZE = 1;
        private static final int OFF_TIME = 2;
        private static final int OFF_UID = 3;
        private static final int OFF_GID = 4;
        private final int[] myOffsets;
        private final int myUid;
        private final int myGid;
        private final boolean myCoarseTs = SystemProperties.getBooleanProperty("idea.io.coarse.ts", false);
        private final LimitedPool<Memory> myMemoryPool = new LimitedPool.Sync<Memory>(10, () -> new Memory(256L));

        JnaUnixMediatorImpl() {
            if ("linux-x86".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = LINUX_32;
            } else if ("linux-x86-64".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = LINUX_64;
            } else if ("linux-arm".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = LNX_ARM32;
            } else if ("linux-ppc".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = LNX_PPC32;
            } else if ("linux-ppc64le".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = LNX_PPC64;
            } else if ("darwin".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = BSD_64;
            } else if ("freebsd-x86".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = SystemInfo.isOsVersionAtLeast("12") ? BSD_32_12 : BSD_32;
            } else if ("freebsd-x86-64".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = SystemInfo.isOsVersionAtLeast("12") ? BSD_64_12 : BSD_64;
            } else if ("sunos-x86".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = SUN_OS_32;
            } else if ("sunos-x86-64".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = SUN_OS_64;
            } else {
                throw new IllegalStateException("Unsupported OS/arch: " + SystemInfo.OS_NAME + "/" + SystemInfo.OS_ARCH);
            }
            Map<String, String> options = Collections.singletonMap("string-encoding", CharsetToolkit.getPlatformCharset().name());
            NativeLibrary lib = NativeLibrary.getInstance((String)"c", options);
            Native.register(LibC.class, (NativeLibrary)lib);
            Native.register(SystemInfo.isLinux ? LinuxLibC.class : UnixLibC.class, (NativeLibrary)lib);
            this.myUid = LibC.getuid();
            this.myGid = LibC.getgid();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileAttributes getAttributes(@NotNull String path) {
            if (path == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(0);
            }
            Memory buffer = this.myMemoryPool.alloc();
            try {
                long mTime1;
                boolean isSymlink;
                int res;
                int n = res = SystemInfo.isLinux ? LinuxLibC.__lxstat64(1, path, (Pointer)buffer) : UnixLibC.lstat(path, (Pointer)buffer);
                if (res != 0) {
                    FileAttributes fileAttributes = null;
                    return fileAttributes;
                }
                int mode = this.getModeFlags(buffer) & 0xFFFF;
                boolean bl = isSymlink = (mode & 0xF000) == 40960;
                if (isSymlink) {
                    if (!JnaUnixMediatorImpl.loadFileStatus(path, buffer)) {
                        FileAttributes fileAttributes = FileAttributes.BROKEN_SYMLINK;
                        return fileAttributes;
                    }
                    mode = this.getModeFlags(buffer) & 0xFFFF;
                }
                if (DO_NOT_RESOLVE_SYMLINKS) {
                    isSymlink = false;
                }
                boolean isDirectory = (mode & 0xF000) == 16384;
                boolean isSpecial = !isDirectory && (mode & 0xF000) != 32768;
                long size = buffer.getLong((long)this.myOffsets[1]);
                long l = mTime1 = SystemInfo.is32Bit ? (long)buffer.getInt((long)this.myOffsets[2]) : buffer.getLong((long)this.myOffsets[2]);
                long mTime2 = this.myCoarseTs ? 0L : (SystemInfo.is32Bit ? (long)buffer.getInt((long)(this.myOffsets[2] + 4)) : buffer.getLong((long)(this.myOffsets[2] + 8)));
                long mTime = mTime1 * 1000L + mTime2 / 1000000L;
                boolean writable = this.ownFile(buffer) ? (mode & 0x92) != 0 : LibC.access(path, 2) == 0;
                FileAttributes fileAttributes = new FileAttributes(isDirectory, isSpecial, isSymlink, false, size, mTime, writable);
                return fileAttributes;
            }
            finally {
                this.myMemoryPool.recycle(buffer);
            }
        }

        @Override
        public String resolveSymLink(@NotNull String path) throws IOException {
            if (path == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(1);
            }
            try {
                return DO_NOT_RESOLVE_SYMLINKS ? path : new File(path).getCanonicalPath();
            }
            catch (IOException e) {
                String message = e.getMessage();
                if (message != null && StringUtil.toLowerCase(message).contains("too many levels of symbolic links")) {
                    LOG.debug(e);
                    return null;
                }
                throw new IOException("Cannot resolve '" + path + "'", e);
            }
        }

        @Override
        public boolean clonePermissions(@NotNull String source, @NotNull String target, boolean execOnly) {
            int permissions;
            Memory buffer;
            if (source == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(2);
            }
            if (target == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(3);
            }
            if (!JnaUnixMediatorImpl.loadFileStatus(source, buffer = new Memory(256L))) {
                return false;
            }
            int sourcePermissions = this.getModeFlags(buffer) & 0x1FF;
            if (execOnly) {
                if (!JnaUnixMediatorImpl.loadFileStatus(target, buffer)) {
                    return false;
                }
                int targetPermissions = this.getModeFlags(buffer) & 0x1FF;
                permissions = targetPermissions & 0xFFFFFFB6 | sourcePermissions & 0x49;
            } else {
                permissions = sourcePermissions;
            }
            return LibC.chmod(target, permissions) == 0;
        }

        private static boolean loadFileStatus(@NotNull String path, @NotNull Memory buffer) {
            if (path == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(4);
            }
            if (buffer == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(5);
            }
            return (SystemInfo.isLinux ? LinuxLibC.__xstat64(1, path, (Pointer)buffer) : UnixLibC.stat(path, (Pointer)buffer)) == 0;
        }

        private int getModeFlags(@NotNull Memory buffer) {
            if (buffer == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(6);
            }
            return SystemInfo.isLinux ? buffer.getInt((long)this.myOffsets[0]) : (int)buffer.getShort((long)this.myOffsets[0]);
        }

        private boolean ownFile(@NotNull Memory buffer) {
            if (buffer == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(7);
            }
            return buffer.getInt((long)this.myOffsets[3]) == this.myUid && buffer.getInt((long)this.myOffsets[4]) == this.myGid;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buffer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/util/io/FileSystemUtil$JnaUnixMediatorImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAttributes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveSymLink";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clonePermissions";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadFileStatus";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getModeFlags";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "ownFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static final class LinuxLibC {
            private LinuxLibC() {
            }

            static native int __lxstat64(int var0, String var1, Pointer var2);

            static native int __xstat64(int var0, String var1, Pointer var2);
        }

        private static final class UnixLibC {
            private UnixLibC() {
            }

            static native int lstat(String var0, Pointer var1);

            static native int stat(String var0, Pointer var1);
        }

        private static final class LibC {
            static final int S_MASK = 65535;
            static final int S_IFMT = 61440;
            static final int S_IFLNK = 40960;
            static final int S_IFREG = 32768;
            static final int S_IFDIR = 16384;
            static final int PERM_MASK = 511;
            static final int EXECUTE_MASK = 73;
            static final int WRITE_MASK = 146;
            static final int W_OK = 2;

            private LibC() {
            }

            static native int getuid();

            static native int getgid();

            static native int chmod(String var0, int var1);

            static native int access(String var0, int var1);
        }
    }

    private static class IdeaWin32MediatorImpl
    implements Mediator {
        private final IdeaWin32 myInstance = IdeaWin32.getInstance();

        private IdeaWin32MediatorImpl() {
        }

        @Override
        public FileAttributes getAttributes(@NotNull String path) {
            FileInfo fileInfo;
            if (path == null) {
                IdeaWin32MediatorImpl.$$$reportNull$$$0(0);
            }
            return (fileInfo = this.myInstance.getInfo(path)) != null ? fileInfo.toFileAttributes() : null;
        }

        @Override
        public String resolveSymLink(@NotNull String path) {
            if (path == null) {
                IdeaWin32MediatorImpl.$$$reportNull$$$0(1);
            }
            path = new File(path).getAbsolutePath();
            char drive = Character.toUpperCase(path.charAt(0));
            if (path.length() <= 3 || drive < 'A' || drive > 'Z' || path.charAt(1) != ':' || path.charAt(2) != '\\') {
                return path;
            }
            int remainder = 4;
            while (remainder < path.length()) {
                int next = path.indexOf(92, remainder);
                String subPath = next > 0 ? path.substring(0, next) : path;
                FileAttributes attributes = this.getAttributes(subPath);
                if (attributes == null) {
                    return null;
                }
                if (attributes.isSymLink()) {
                    return this.myInstance.resolveSymLink(path);
                }
                remainder = next > 0 ? next + 1 : path.length();
            }
            return path;
        }

        @Override
        public boolean clonePermissions(@NotNull String source, @NotNull String target, boolean execOnly) {
            if (source == null) {
                IdeaWin32MediatorImpl.$$$reportNull$$$0(2);
            }
            if (target == null) {
                IdeaWin32MediatorImpl.$$$reportNull$$$0(3);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/util/io/FileSystemUtil$IdeaWin32MediatorImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAttributes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveSymLink";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clonePermissions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface Mediator {
        @Nullable
        public FileAttributes getAttributes(@NotNull String var1) throws IOException;

        @Nullable
        public String resolveSymLink(@NotNull String var1) throws IOException;

        public boolean clonePermissions(@NotNull String var1, @NotNull String var2, boolean var3) throws IOException;
    }
}

