/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.PrimitiveValueImpl;
import com.sun.jdi.CharValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;

public class CharValueImpl
extends PrimitiveValueImpl
implements CharValue {
    private final char value;

    CharValueImpl(VirtualMachine aVm, char aValue) {
        super(aVm);
        this.value = aValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CharValue) {
            return this.value == ((CharValue)obj).value() && super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.intValue();
    }

    @Override
    public int compareTo(CharValue obj) {
        char other = obj.value();
        return this.value() - other;
    }

    @Override
    public Type type() {
        return this.vm.theCharType();
    }

    @Override
    public char value() {
        return this.value;
    }

    @Override
    public boolean booleanValue() {
        return this.value != '\u0000';
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public char charValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    byte checkedByteValue() throws InvalidTypeException {
        if (this.value > '\u007f') {
            throw new InvalidTypeException("Can't convert " + this.value + " to byte");
        }
        return super.checkedByteValue();
    }

    @Override
    short checkedShortValue() throws InvalidTypeException {
        if (this.value > Short.MAX_VALUE) {
            throw new InvalidTypeException("Can't convert " + this.value + " to short");
        }
        return super.checkedShortValue();
    }

    @Override
    byte typeValueKey() {
        return 67;
    }
}

