/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.SocketConnection;
import com.sun.jdi.connect.TransportTimeoutException;
import com.sun.jdi.connect.spi.Connection;
import com.sun.jdi.connect.spi.TransportService;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ResourceBundle;

public class SocketTransportService
extends TransportService {
    private ResourceBundle messages = null;

    void handshake(Socket s, long timeout) throws IOException {
        int n;
        s.setSoTimeout((int)timeout);
        byte[] hello = "JDWP-Handshake".getBytes(StandardCharsets.UTF_8);
        s.getOutputStream().write(hello);
        byte[] b = new byte[hello.length];
        for (int received = 0; received < hello.length; received += n) {
            try {
                n = s.getInputStream().read(b, received, hello.length - received);
            }
            catch (SocketTimeoutException x) {
                throw new IOException("handshake timeout");
            }
            if (n >= 0) continue;
            s.close();
            throw new IOException("handshake failed - connection prematurally closed");
        }
        for (int i = 0; i < hello.length; ++i) {
            if (b[i] == hello[i]) continue;
            throw new IOException("handshake failed - unrecognized message from target VM");
        }
        s.setSoTimeout(0);
    }

    @Override
    public String name() {
        return "Socket";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String description() {
        SocketTransportService socketTransportService = this;
        synchronized (socketTransportService) {
            if (this.messages == null) {
                this.messages = ResourceBundle.getBundle("com.jetbrains.jdi.resources.jdi");
            }
        }
        return this.messages.getString("socket_transportservice.description");
    }

    @Override
    public TransportService.Capabilities capabilities() {
        return new TransportService.Capabilities(){

            @Override
            public boolean supportsMultipleConnections() {
                return true;
            }

            @Override
            public boolean supportsAttachTimeout() {
                return true;
            }

            @Override
            public boolean supportsAcceptTimeout() {
                return true;
            }

            @Override
            public boolean supportsHandshakeTimeout() {
                return true;
            }
        };
    }

    @Override
    public Connection attach(String address, long attachTimeout, long handshakeTimeout) throws IOException {
        if (address == null) {
            throw new NullPointerException("address is null");
        }
        if (attachTimeout < 0L || handshakeTimeout < 0L) {
            throw new IllegalArgumentException("timeout is negative");
        }
        HostPort hostPort = HostPort.parse(address);
        InetSocketAddress sa = new InetSocketAddress(hostPort.host == null ? InetAddress.getLoopbackAddress().getHostAddress() : hostPort.host, hostPort.port);
        Socket s = new Socket();
        try {
            s.connect(sa, (int)attachTimeout);
        }
        catch (SocketTimeoutException exc) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new TransportTimeoutException("timed out trying to establish connection");
        }
        try {
            this.handshake(s, handshakeTimeout);
        }
        catch (IOException exc) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw exc;
        }
        return new SocketConnection(s);
    }

    TransportService.ListenKey startListening(String localaddress, int port) throws IOException {
        InetSocketAddress sa = localaddress == null ? new InetSocketAddress(port) : new InetSocketAddress(localaddress, port);
        ServerSocket ss = new ServerSocket();
        if (port == 0) {
            ss.setReuseAddress(false);
        }
        ss.bind(sa);
        return new SocketListenKey(ss);
    }

    @Override
    public TransportService.ListenKey startListening(String address) throws IOException {
        HostPort hostPort = HostPort.parse(address == null || address.isEmpty() ? "0" : address);
        return this.startListening(hostPort.host, hostPort.port);
    }

    @Override
    public TransportService.ListenKey startListening() throws IOException {
        return this.startListening(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopListening(TransportService.ListenKey listener) throws IOException {
        if (!(listener instanceof SocketListenKey)) {
            throw new IllegalArgumentException("Invalid listener");
        }
        TransportService.ListenKey listenKey = listener;
        synchronized (listenKey) {
            ServerSocket ss = ((SocketListenKey)listener).socket();
            if (ss.isClosed()) {
                throw new IllegalArgumentException("Invalid listener");
            }
            ss.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection accept(TransportService.ListenKey listener, long acceptTimeout, long handshakeTimeout) throws IOException {
        Socket s;
        ServerSocket ss;
        if (acceptTimeout < 0L || handshakeTimeout < 0L) {
            throw new IllegalArgumentException("timeout is negative");
        }
        if (!(listener instanceof SocketListenKey)) {
            throw new IllegalArgumentException("Invalid listener");
        }
        TransportService.ListenKey listenKey = listener;
        synchronized (listenKey) {
            ss = ((SocketListenKey)listener).socket();
            if (ss.isClosed()) {
                throw new IllegalArgumentException("Invalid listener");
            }
        }
        ss.setSoTimeout((int)acceptTimeout);
        try {
            s = ss.accept();
        }
        catch (SocketTimeoutException x) {
            throw new TransportTimeoutException("timeout waiting for connection");
        }
        this.handshake(s, handshakeTimeout);
        return new SocketConnection(s);
    }

    public String toString() {
        return this.name();
    }

    private static class HostPort {
        public final String host;
        public final int port;

        private HostPort(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public static HostPort parse(String hostPort) {
            int port;
            int splitIndex = hostPort.lastIndexOf(58);
            try {
                port = Integer.decode(hostPort.substring(splitIndex + 1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("unable to parse port number in address");
            }
            if (port < 0 || port > 65535) {
                throw new IllegalArgumentException("port out of range");
            }
            if (splitIndex <= 0) {
                return new HostPort(InetAddress.getLoopbackAddress().getHostAddress(), port);
            }
            if (splitIndex == 1 && hostPort.charAt(0) == '*') {
                return new HostPort(null, port);
            }
            if (hostPort.charAt(0) == '[' && hostPort.charAt(splitIndex - 1) == ']') {
                return new HostPort(hostPort.substring(1, splitIndex - 1), port);
            }
            return new HostPort(hostPort.substring(0, splitIndex), port);
        }
    }

    static class SocketListenKey
    extends TransportService.ListenKey {
        final ServerSocket ss;

        SocketListenKey(ServerSocket ss) {
            this.ss = ss;
        }

        ServerSocket socket() {
            return this.ss;
        }

        @Override
        public String address() {
            String hostaddr;
            String hostname;
            InetAddress address = this.ss.getInetAddress();
            if (address.isAnyLocalAddress()) {
                try {
                    address = InetAddress.getLocalHost();
                }
                catch (UnknownHostException uhe) {
                    address = InetAddress.getLoopbackAddress();
                }
            }
            String result = (hostname = address.getHostName()).equals(hostaddr = address.getHostAddress()) ? (address instanceof Inet6Address ? "[" + hostaddr + "]" : hostaddr) : hostname;
            return result + ":" + this.ss.getLocalPort();
        }

        public String toString() {
            return this.address();
        }
    }
}

