/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.cachedValueProfiler;

import com.intellij.execution.filters.ExceptionFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorTextField;
import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;

class CVPTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final Project myProject;
    private Document myDocument;

    CVPTableCellEditor(@NotNull Project project) {
        if (project == null) {
            CVPTableCellEditor.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Document document = EditorFactory.getInstance().createDocument((CharSequence)((String)value));
        EditorTextField textField = new EditorTextField(document, this.myProject, (FileType)FileTypes.PLAIN_TEXT, true, true){

            protected boolean shouldHaveBorder() {
                return false;
            }

            public void addNotify() {
                super.addNotify();
                Editor editor = this.getEditor();
                if (editor != null) {
                    CVPTableCellEditor.this.addHyperLinks(editor, editor.getDocument().getText());
                }
            }
        };
        this.myDocument = textField.getDocument();
        return textField;
    }

    @Override
    public Object getCellEditorValue() {
        @NlsSafe String text = this.myDocument.getText();
        return text;
    }

    private void addHyperLinks(@NotNull Editor editor, @NotNull String text) {
        if (editor == null) {
            CVPTableCellEditor.$$$reportNull$$$0(1);
        }
        if (text == null) {
            CVPTableCellEditor.$$$reportNull$$$0(2);
        }
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES);
        ExceptionFilter filter = new ExceptionFilter(GlobalSearchScope.allScope((Project)this.myProject));
        Filter.Result result = filter.applyFilter(text, text.length());
        if (result != null) {
            EditorHyperlinkSupport hyperlinkSupport = EditorHyperlinkSupport.get((Editor)editor);
            for (Filter.ResultItem item : result.getResultItems()) {
                HyperlinkInfo hyperlinkInfo = item.getHyperlinkInfo();
                if (hyperlinkInfo == null) continue;
                hyperlinkSupport.createHyperlink(item.getHighlightStartOffset(), item.getHighlightEndOffset(), attributes, hyperlinkInfo);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/cachedValueProfiler/CVPTableCellEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addHyperLinks";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

