/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.PsiUtil;

public abstract class DevKitInspectionBase
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public final PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DevKitInspectionBase.$$$reportNull$$$0(0);
        }
        PsiElementVisitor psiElementVisitor = DevKitInspectionBase.isAllowed(holder) ? this.buildInternalVisitor(holder, isOnTheFly) : PsiElementVisitor.EMPTY_VISITOR;
        if (psiElementVisitor == null) {
            DevKitInspectionBase.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    protected PsiElementVisitor buildInternalVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DevKitInspectionBase.$$$reportNull$$$0(2);
        }
        return super.buildVisitor(holder, isOnTheFly);
    }

    static boolean isAllowed(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            DevKitInspectionBase.$$$reportNull$$$0(3);
        }
        return DevKitInspectionBase.isAllowed(holder, h -> true);
    }

    static boolean isAllowedInPluginsOnly(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            DevKitInspectionBase.$$$reportNull$$$0(4);
        }
        return DevKitInspectionBase.isAllowed(holder, DevKitInspectionBase::isPluginFile);
    }

    static boolean isAllowed(@NotNull ProblemsHolder holder, @NotNull Predicate<? super ProblemsHolder> predicate) {
        if (holder == null) {
            DevKitInspectionBase.$$$reportNull$$$0(5);
        }
        if (predicate == null) {
            DevKitInspectionBase.$$$reportNull$$$0(6);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (PsiUtil.isIdeaProject(holder.getProject())) {
            return predicate.test((ProblemsHolder)holder);
        }
        return DevKitInspectionBase.isInPluginModule(holder);
    }

    private static boolean isInPluginModule(@NotNull ProblemsHolder holder) {
        Module module;
        if (holder == null) {
            DevKitInspectionBase.$$$reportNull$$$0(7);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)holder.getFile())) == null) {
            return false;
        }
        return PluginModuleType.isPluginModuleOrDependency(module) || PsiUtil.isPluginModule(module);
    }

    private static boolean isPluginFile(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            DevKitInspectionBase.$$$reportNull$$$0(8);
        }
        return !holder.getFile().getVirtualFile().getPath().contains("/platform/");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/DevKitInspectionBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/DevKitInspectionBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildInternalVisitor";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAllowed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAllowedInPluginsOnly";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isInPluginModule";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isPluginFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

