/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.projectRoots;

import org.jetbrains.annotations.NonNls;

public enum IntelliJPlatformProduct {
    IDEA("IU", "IntelliJ IDEA", null),
    IDEA_IC("IC", "IntelliJ IDEA Community Edition", "Idea"),
    IDEA_IE("IE", "IntelliJ IDEA Educational Edition", "IdeaEdu"),
    RUBYMINE("RM", "RubyMine", "Ruby"),
    PYCHARM("PY", "PyCharm", "Python"),
    PYCHARM_PC("PC", "PyCharm Community Edition", "PyCharmCore"),
    PYCHARM_DS("PD", "JetBrains DataSpell", "PyCharmDS"),
    PYCHARM_EDU("PE", "PyCharm Educational Edition", "PyCharmEdu"),
    PHPSTORM("PS", "PhpStorm", "PhpStorm"),
    WEBSTORM("WS", "WebStorm", "WebStorm"),
    APPCODE("OC", "AppCode", "AppCode"),
    CLION("CL", "CLion", "CLion"),
    MOBILE_IDE("MI", "Mobile IDE", "MobileIDE"),
    DBE("DB", "DataGrip", "DataGrip"),
    RIDER("RD", "Rider", "Rider"),
    GOIDE("GO", "GoLand", "GoLand"),
    ANDROID_STUDIO("AI", "Android Studio", "AndroidStudio"),
    INTELLIJ_CLIENT("IJC", "IntelliJ Client", "IntelliJClient");

    private final String myProductCode;
    private final String myName;
    private final String myPlatformPrefix;

    @NonNls
    public String getName() {
        return this.myName;
    }

    @NonNls
    public String getPlatformPrefix() {
        return this.myPlatformPrefix;
    }

    private IntelliJPlatformProduct(@NonNls String productCode, String name, String platformPrefix) {
        this.myProductCode = productCode;
        this.myName = name;
        this.myPlatformPrefix = platformPrefix;
    }

    public static IntelliJPlatformProduct fromBuildNumber(String buildNumber) {
        for (IntelliJPlatformProduct product : IntelliJPlatformProduct.values()) {
            if (!buildNumber.startsWith(product.myProductCode)) continue;
            return product;
        }
        return IDEA;
    }
}

