/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.inference.common;

import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.nj2k.inference.common.BoundType;
import org.jetbrains.kotlin.nj2k.inference.common.BoundTypeLabel;
import org.jetbrains.kotlin.nj2k.inference.common.ClassReference;
import org.jetbrains.kotlin.nj2k.inference.common.Constraint;
import org.jetbrains.kotlin.nj2k.inference.common.ConstraintBound;
import org.jetbrains.kotlin.nj2k.inference.common.DebugPrinter$WhenMappings;
import org.jetbrains.kotlin.nj2k.inference.common.DebugPrinter$addTypeVariablesNames$;
import org.jetbrains.kotlin.nj2k.inference.common.DescriptorClassReference;
import org.jetbrains.kotlin.nj2k.inference.common.EqualsConstraint;
import org.jetbrains.kotlin.nj2k.inference.common.GenericLabel;
import org.jetbrains.kotlin.nj2k.inference.common.InferenceContext;
import org.jetbrains.kotlin.nj2k.inference.common.LiteralBound;
import org.jetbrains.kotlin.nj2k.inference.common.LiteralLabel;
import org.jetbrains.kotlin.nj2k.inference.common.Namer;
import org.jetbrains.kotlin.nj2k.inference.common.NoClassReference;
import org.jetbrains.kotlin.nj2k.inference.common.NullLiteralLabel;
import org.jetbrains.kotlin.nj2k.inference.common.StarProjectionLabel;
import org.jetbrains.kotlin.nj2k.inference.common.State;
import org.jetbrains.kotlin.nj2k.inference.common.SubtypeConstraint;
import org.jetbrains.kotlin.nj2k.inference.common.TypeParameter;
import org.jetbrains.kotlin.nj2k.inference.common.TypeParameterLabel;
import org.jetbrains.kotlin.nj2k.inference.common.TypeParameterReference;
import org.jetbrains.kotlin.nj2k.inference.common.TypeVariable;
import org.jetbrains.kotlin.nj2k.inference.common.TypeVariableBound;
import org.jetbrains.kotlin.nj2k.inference.common.TypeVariableLabel;
import org.jetbrains.kotlin.nj2k.inference.common.WithForcedStateBoundType;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeElement;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\f\u001a\u00020\r*\u00020\u000eJ\n\u0010\u000f\u001a\u00020\b*\u00020\u0010J\n\u0010\u000f\u001a\u00020\b*\u00020\u0011J\f\u0010\u000f\u001a\u00020\b*\u00020\u0012H\u0002J\n\u0010\u000f\u001a\u00020\b*\u00020\u0013J\f\u0010\u000f\u001a\u00020\b*\u00020\u0014H\u0002J\n\u0010\u000f\u001a\u00020\b*\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0007\u001a\u00020\b*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/nj2k/inference/common/DebugPrinter;", "", "inferenceContext", "Lorg/jetbrains/kotlin/nj2k/inference/common/InferenceContext;", "(Lorg/jetbrains/kotlin/nj2k/inference/common/InferenceContext;)V", "namer", "Lorg/jetbrains/kotlin/nj2k/inference/common/Namer;", "name", "", "Lorg/jetbrains/kotlin/nj2k/inference/common/TypeVariable;", "getName", "(Lorg/jetbrains/kotlin/nj2k/inference/common/TypeVariable;)Ljava/lang/String;", "addTypeVariablesNames", "", "Lcom/intellij/psi/PsiElement;", "asString", "Lorg/jetbrains/kotlin/nj2k/inference/common/BoundType;", "Lorg/jetbrains/kotlin/nj2k/inference/common/BoundTypeLabel;", "Lorg/jetbrains/kotlin/nj2k/inference/common/ClassReference;", "Lorg/jetbrains/kotlin/nj2k/inference/common/Constraint;", "Lorg/jetbrains/kotlin/nj2k/inference/common/ConstraintBound;", "Lorg/jetbrains/kotlin/nj2k/inference/common/State;", "kotlin.j2k.services"})
public final class DebugPrinter {
    private final Namer namer;
    private final InferenceContext inferenceContext;

    @NotNull
    public final String getName(@NotNull TypeVariable $this$name) {
        Intrinsics.checkNotNullParameter((Object)$this$name, (String)"$this$name");
        return this.namer.name($this$name);
    }

    private final String asString(ClassReference $this$asString) {
        String string;
        ClassReference classReference = $this$asString;
        if (classReference instanceof DescriptorClassReference) {
            string = ((DescriptorClassReference)$this$asString).getDescriptor().getName().toString();
        } else if (classReference instanceof TypeParameterReference) {
            string = ((TypeParameterReference)$this$asString).getDescriptor().getName().toString();
        } else if (classReference instanceof NoClassReference) {
            string = "NoClassRef";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"when (this) {\n        is\u2026nce -> \"NoClassRef\"\n    }");
        return string;
    }

    @NotNull
    public final String asString(@NotNull BoundTypeLabel $this$asString) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"$this$asString");
        BoundTypeLabel boundTypeLabel = $this$asString;
        if (boundTypeLabel instanceof TypeVariableLabel) {
            string = this.getName(((TypeVariableLabel)$this$asString).getTypeVariable()) + "@" + this.asString(((TypeVariableLabel)$this$asString).getTypeVariable().getClassReference());
        } else if (boundTypeLabel instanceof TypeParameterLabel) {
            String string2 = ((TypeParameterLabel)$this$asString).getTypeParameter().getName().asString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"typeParameter.name.asString()");
        } else if (boundTypeLabel instanceof GenericLabel) {
            string = this.asString(((GenericLabel)$this$asString).getClassReference());
        } else if (Intrinsics.areEqual((Object)boundTypeLabel, (Object)StarProjectionLabel.INSTANCE)) {
            string = "*";
        } else if (Intrinsics.areEqual((Object)boundTypeLabel, (Object)NullLiteralLabel.INSTANCE)) {
            string = "NULL";
        } else if (Intrinsics.areEqual((Object)boundTypeLabel, (Object)LiteralLabel.INSTANCE)) {
            string = "LIT";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public final String asString(@NotNull State $this$asString) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$asString), (String)"$this$asString");
        switch (DebugPrinter$WhenMappings.$EnumSwitchMapping$0[$this$asString.ordinal()]) {
            case 1: {
                string = "L";
                break;
            }
            case 2: {
                string = "U";
                break;
            }
            case 3: {
                string = "?";
                break;
            }
            case 4: {
                string = "$";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public final String asString(@NotNull BoundType $this$asString) {
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"$this$asString");
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        $this$buildString.append(this.asString($this$asString.getLabel()));
        Collection collection = $this$asString.getTypeParameters();
        boolean bl6 = false;
        if (!collection.isEmpty()) {
            CollectionsKt.joinTo$default((Iterable)$this$asString.getTypeParameters(), (Appendable)$this$buildString, (CharSequence)", ", (CharSequence)"<", (CharSequence)">", (int)0, null, (Function1)((Function1)new Function1<TypeParameter, CharSequence>(this, $this$asString){
                final /* synthetic */ DebugPrinter this$0;
                final /* synthetic */ BoundType $this_asString$inlined;
                {
                    this.this$0 = debugPrinter;
                    this.$this_asString$inlined = boundType;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull TypeParameter it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.this$0.asString(it.getBoundType());
                }
            }), (int)48, null);
        }
        if ($this$asString instanceof WithForcedStateBoundType) {
            $this$buildString.append("!!");
            $this$buildString.append(this.asString(((WithForcedStateBoundType)$this$asString).getForcedState()));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String asString(@NotNull Constraint $this$asString) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"$this$asString");
        StringBuilder stringBuilder = new StringBuilder();
        Constraint constraint = $this$asString;
        if (constraint instanceof EqualsConstraint) {
            string = this.asString(((EqualsConstraint)$this$asString).getLeft()) + " := " + this.asString(((EqualsConstraint)$this$asString).getRight());
        } else if (constraint instanceof SubtypeConstraint) {
            string = this.asString(((SubtypeConstraint)$this$asString).getSubtype()) + " <: " + this.asString(((SubtypeConstraint)$this$asString).getSupertype());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return stringBuilder.append(string).append(" due to '").append((Object)$this$asString.getPriority()).append('\'').toString();
    }

    private final String asString(ConstraintBound $this$asString) {
        String string;
        ConstraintBound constraintBound = $this$asString;
        if (constraintBound instanceof LiteralBound) {
            string = ((LiteralBound)$this$asString).getState().toString();
        } else if (constraintBound instanceof TypeVariableBound) {
            string = this.getName(((TypeVariableBound)$this$asString).getTypeVariable());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final void addTypeVariablesNames(@NotNull PsiElement $this$addTypeVariablesNames) {
        void $this$forEachDescendantOfType$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$addTypeVariablesNames, (String)"$this$addTypeVariablesNames");
        KtPsiFactory factory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)$this$addTypeVariablesNames, (boolean)false, (int)2, null);
        PsiElement $this$collectDescendantsOfType$iv = $this$addTypeVariablesNames;
        Function1 predicate$iv = addTypeVariablesNames$$inlined$collectDescendantsOfType$1.INSTANCE;
        boolean $i$f$collectDescendantsOfType = false;
        PsiElement $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        ArrayList result$iv$iv = new ArrayList();
        PsiElement psiElement = $this$collectDescendantsOfType$iv$iv;
        Function1 action$iv$iv$iv = (Function1)new Function1<KtTypeElement, Unit>(predicate$iv, result$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ ArrayList $result;
            {
                this.$predicate = function1;
                this.$result = arrayList;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                    this.$result.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        $this$forEachDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $captured_local_variable$1;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtTypeElement) {
                    this.$action.invoke((Object)element);
                }
            }
        });
        for (KtTypeElement typeElement : (List)result$iv$iv) {
            Object object = this.inferenceContext.getTypeElementToTypeVariable().get(typeElement);
            if (object == null || (object = this.getName((TypeVariable)object)) == null) {
                continue;
            }
            Object typeVariableName = object;
            PsiComment comment = factory.createComment("/*" + (String)typeVariableName + "@*/");
            typeElement.getParent().addBefore((PsiElement)comment, (PsiElement)typeElement);
        }
    }

    public DebugPrinter(@NotNull InferenceContext inferenceContext2) {
        Intrinsics.checkNotNullParameter((Object)inferenceContext2, (String)"inferenceContext");
        this.inferenceContext = inferenceContext2;
        this.namer = new Namer(this.inferenceContext);
    }
}

