/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.branch.DvcsBranchUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.dvcs.repo.VcsRepositoryMappingListener;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsStatusWidget<T extends Repository>
extends EditorBasedWidget
implements StatusBarWidget.MultipleTextValuesPresentation,
StatusBarWidget.Multiframe {
    protected static final Logger LOG = Logger.getInstance(DvcsStatusWidget.class);
    @NotNull
    private final String myVcsName;
    @Nullable
    @Nls
    private String myText;
    @Nullable
    private @NlsContexts.Tooltip String myTooltip;
    @Nullable
    private Icon myIcon;

    protected DvcsStatusWidget(@NotNull Project project, @NotNull @Nls String vcsName) {
        if (project == null) {
            DvcsStatusWidget.$$$reportNull$$$0(0);
        }
        if (vcsName == null) {
            DvcsStatusWidget.$$$reportNull$$$0(1);
        }
        super(project);
        this.myVcsName = vcsName;
        project.getMessageBus().connect((Disposable)this).subscribe(VcsRepositoryManager.VCS_REPOSITORY_MAPPING_UPDATED, (Object)new VcsRepositoryMappingListener(){

            @Override
            public void mappingChanged() {
                LOG.debug("repository mappings changed");
                DvcsStatusWidget.this.updateLater();
            }
        });
    }

    @Nullable
    protected abstract T guessCurrentRepository(@NotNull Project var1);

    @Nls
    @NotNull
    protected abstract String getFullBranchName(@NotNull T var1);

    @Nullable
    protected Icon getIcon(@NotNull T repository) {
        if (repository == null) {
            DvcsStatusWidget.$$$reportNull$$$0(2);
        }
        if (repository.getState() != Repository.State.NORMAL) {
            return AllIcons.General.Warning;
        }
        return AllIcons.Vcs.Branch;
    }

    protected abstract boolean isMultiRoot(@NotNull Project var1);

    @NotNull
    protected abstract ListPopup getPopup(@NotNull Project var1, @NotNull T var2);

    protected abstract void rememberRecentRoot(@NotNull String var1);

    public void install(@NotNull StatusBar statusBar2) {
        if (statusBar2 == null) {
            DvcsStatusWidget.$$$reportNull$$$0(3);
        }
        super.install(statusBar2);
        this.updateLater();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void deactivate() {
    }

    public StatusBarWidget.WidgetPresentation getPresentation() {
        return this;
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            DvcsStatusWidget.$$$reportNull$$$0(4);
        }
        LOG.debug("selection changed");
        this.update();
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            DvcsStatusWidget.$$$reportNull$$$0(5);
        }
        if (file == null) {
            DvcsStatusWidget.$$$reportNull$$$0(6);
        }
        LOG.debug("file opened");
        this.update();
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            DvcsStatusWidget.$$$reportNull$$$0(7);
        }
        if (file == null) {
            DvcsStatusWidget.$$$reportNull$$$0(8);
        }
        LOG.debug("file closed");
        this.update();
    }

    @RequiresEdt
    @Nullable
    public String getSelectedValue() {
        return StringUtil.defaultIfEmpty((String)this.myText, (String)"");
    }

    @Nullable
    public String getTooltipText() {
        return this.myTooltip;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @Nullable
    public ListPopup getPopupStep() {
        if (this.isDisposed()) {
            return null;
        }
        Project project = this.getProject();
        T repository = this.guessCurrentRepository(project);
        if (repository == null) {
            return null;
        }
        return this.getPopup(project, repository);
    }

    @Nullable
    public Consumer<MouseEvent> getClickConsumer() {
        return null;
    }

    protected void updateLater() {
        Project project = this.getProject();
        if (this.isDisposed()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            LOG.debug("update after repository change");
            this.update();
        }, project.getDisposed());
    }

    @RequiresEdt
    private void update() {
        this.myText = null;
        this.myTooltip = null;
        this.myIcon = null;
        if (this.isDisposed()) {
            return;
        }
        Project project = this.getProject();
        T repository = this.guessCurrentRepository(project);
        if (repository == null) {
            return;
        }
        this.myText = DvcsBranchUtil.shortenBranchName(this.getFullBranchName(repository));
        this.myTooltip = this.getToolTip(repository);
        this.myIcon = this.getIcon(repository);
        if (this.myStatusBar != null) {
            this.myStatusBar.updateWidget(this.ID());
        }
        this.rememberRecentRoot(repository.getRoot().getPath());
    }

    @NlsContexts.Tooltip
    @Nullable
    @RequiresEdt
    protected String getToolTip(@Nullable T repository) {
        if (repository == null) {
            return null;
        }
        Object message = DvcsBundle.message((String)"tooltip.branch.widget.vcs.branch.name.text", (Object[])new Object[]{this.myVcsName, this.getFullBranchName(repository)});
        if (this.isMultiRoot(repository.getProject())) {
            message = (String)message + "\n";
            message = (String)message + DvcsBundle.message((String)"tooltip.branch.widget.root.name.text", (Object[])new Object[]{repository.getRoot().getName()});
        }
        return message;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dvcs/ui/DvcsStatusWidget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "selectionChanged";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "fileOpened";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "fileClosed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

