/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.project.ProjectKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BaseRevisionTextPatchEP
implements PatchEP {
    public static final Key<Boolean> ourPutBaseRevisionTextKey = Key.create((String)"com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP.ourPutBaseRevisionTextKey");
    public static final Key<Map<FilePath, ContentRevision>> ourBaseRevisions = Key.create((String)"com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP.ourBaseRevisionPaths");
    public static final Key<Map<String, String>> ourStoredTexts = Key.create((String)"com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP.ourStoredTexts");
    private static final Logger LOG = Logger.getInstance(BaseRevisionTextPatchEP.class);

    @NotNull
    public String getName() {
        return "com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP";
    }

    public CharSequence provideContent(@NotNull Project project, @NotNull String path2, @Nullable CommitContext commitContext) {
        if (project == null) {
            BaseRevisionTextPatchEP.$$$reportNull$$$0(0);
        }
        if (path2 == null) {
            BaseRevisionTextPatchEP.$$$reportNull$$$0(1);
        }
        if (commitContext == null) {
            return null;
        }
        if (Boolean.TRUE.equals(commitContext.getUserData(ourPutBaseRevisionTextKey))) {
            ContentRevision baseRevision;
            Path file = ProjectKt.getStateStore((Project)project).getProjectBasePath().resolve(path2);
            FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePath(file, Files.isDirectory(file, new LinkOption[0]));
            Map baseRevisions = (Map)commitContext.getUserData(ourBaseRevisions);
            ContentRevision contentRevision = baseRevision = baseRevisions == null ? null : (ContentRevision)baseRevisions.get(filePath);
            if (baseRevision == null) {
                return null;
            }
            try {
                return baseRevision.getContent();
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        } else {
            Map map2 = (Map)commitContext.getUserData(ourStoredTexts);
            if (map2 != null) {
                return (CharSequence)map2.get(ProjectKt.getStateStore((Project)project).getProjectBasePath().resolve(path2).toString());
            }
        }
        return null;
    }

    public void consumeContentBeforePatchApplied(@NotNull Project project, @NotNull String path2, @NotNull CharSequence content2, @Nullable CommitContext commitContext) {
        if (project == null) {
            BaseRevisionTextPatchEP.$$$reportNull$$$0(2);
        }
        if (path2 == null) {
            BaseRevisionTextPatchEP.$$$reportNull$$$0(3);
        }
        if (content2 == null) {
            BaseRevisionTextPatchEP.$$$reportNull$$$0(4);
        }
        if (commitContext == null) {
            return;
        }
        HashMap<String, String> map2 = (HashMap<String, String>)commitContext.getUserData(ourStoredTexts);
        if (map2 == null) {
            map2 = new HashMap<String, String>();
            commitContext.putUserData(ourStoredTexts, map2);
        }
        map2.put(ProjectKt.getStateStore((Project)project).getProjectBasePath().resolve(path2).toString(), content2.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/diff/impl/patch/BaseRevisionTextPatchEP";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "provideContent";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "consumeContentBeforePatchApplied";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

