/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.dnd.DnDAware;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.VcsCurrentRevisionProxy;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserUnversionedFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupHandler;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcs.commit.ChangesViewCommitPanelKt;
import com.intellij.vcsUtil.VcsUtil;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesListView
extends ChangesTree
implements DataProvider,
DnDAware {
    @NonNls
    public static final String HELP_ID = "ideaInterface.changes";
    @NonNls
    public static final DataKey<ChangesListView> DATA_KEY = DataKey.create((String)"ChangeListView");
    @NonNls
    public static final DataKey<Stream<FilePath>> UNVERSIONED_FILE_PATHS_DATA_KEY = DataKey.create((String)"ChangeListView.UnversionedFiles");
    @NonNls
    public static final DataKey<Stream<VirtualFile>> EXACTLY_SELECTED_FILES_DATA_KEY = DataKey.create((String)"ChangeListView.ExactlySelectedFiles");
    @NonNls
    public static final DataKey<Stream<FilePath>> IGNORED_FILE_PATHS_DATA_KEY = DataKey.create((String)"ChangeListView.IgnoredFiles");
    @NonNls
    public static final DataKey<List<FilePath>> MISSING_FILES_DATA_KEY = DataKey.create((String)"ChangeListView.MissingFiles");
    @NonNls
    public static final DataKey<List<LocallyDeletedChange>> LOCALLY_DELETED_CHANGES = DataKey.create((String)"ChangeListView.LocallyDeletedChanges");

    public ChangesListView(@NotNull Project project, boolean showCheckboxes) {
        if (project == null) {
            ChangesListView.$$$reportNull$$$0(0);
        }
        super(project, showCheckboxes, true);
        this.setDragEnabled(true);
    }

    @Override
    @NotNull
    protected ChangesGroupingSupport installGroupingSupport() {
        return new ChangesGroupingSupport(this.myProject, (Object)this, true);
    }

    @Override
    public int getToggleClickCount() {
        return 2;
    }

    @Override
    protected boolean isInclusionVisible(@NotNull ChangesBrowserNode<?> node) {
        Object subtreeRootObject;
        if (node == null) {
            ChangesListView.$$$reportNull$$$0(1);
        }
        if ((subtreeRootObject = ChangesViewCommitPanelKt.subtreeRootObject(node)) instanceof LocalChangeList) {
            return !((LocalChangeList)subtreeRootObject).getChanges().isEmpty();
        }
        return subtreeRootObject == ChangesBrowserNode.UNVERSIONED_FILES_TAG;
    }

    public DefaultTreeModel getModel() {
        return (DefaultTreeModel)super.getModel();
    }

    public void updateModel(@NotNull DefaultTreeModel newModel) {
        if (newModel == null) {
            ChangesListView.$$$reportNull$$$0(2);
        }
        TreeState state = TreeState.createOn((JTree)((Object)this), this.getRoot());
        state.setScrollToSelection(false);
        ChangesBrowserNode<?> oldRoot = this.getRoot();
        this.setModel(newModel);
        ChangesBrowserNode<?> newRoot = this.getRoot();
        state.applyTo((JTree)((Object)this), newRoot);
        this.initTreeStateIfNeeded(oldRoot, newRoot);
    }

    @Override
    public void rebuildTree() {
    }

    private void initTreeStateIfNeeded(ChangesBrowserNode<?> oldRoot, ChangesBrowserNode<?> newRoot) {
        ChangesBrowserNode<?> defaultListNode = ChangesListView.getDefaultChangelistNode(newRoot);
        if (defaultListNode == null) {
            return;
        }
        if (this.getSelectionCount() == 0) {
            TreeUtil.selectNode((JTree)((Object)this), defaultListNode);
        }
        if (oldRoot.getFileCount() == 0 && TreeUtil.collectExpandedPaths((JTree)((Object)this)).size() == 0) {
            this.expandSafe(defaultListNode);
        }
    }

    @Nullable
    private static ChangesBrowserNode<?> getDefaultChangelistNode(@NotNull ChangesBrowserNode<?> root) {
        if (root == null) {
            ChangesListView.$$$reportNull$$$0(3);
        }
        Enumeration<TreeNode> children = root.children();
        Iterator nodes = ContainerUtil.iterate(children);
        return (ChangesBrowserNode)ContainerUtil.find((Iterator)nodes, node -> {
            if (node instanceof ChangesBrowserChangeListNode) {
                ChangeList list = (ChangeList)((ChangesBrowserChangeListNode)node).getUserObject();
                return list instanceof LocalChangeList && ((LocalChangeList)list).isDefault();
            }
            return false;
        });
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            ChangesListView.$$$reportNull$$$0(4);
        }
        if (DATA_KEY.is(dataId)) {
            return this;
        }
        if (VcsDataKeys.CHANGES.is(dataId)) {
            return this.getSelectedChanges().toArray(Change[]::new);
        }
        if (VcsDataKeys.CHANGE_LEAD_SELECTION.is(dataId)) {
            return this.getLeadSelection().toArray(Change[]::new);
        }
        if (VcsDataKeys.CHANGE_LISTS.is(dataId)) {
            return this.getSelectedChangeLists().toArray(ChangeList[]::new);
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            return this.getSelectedFiles().toArray(VirtualFile[]::new);
        }
        if (VcsDataKeys.VIRTUAL_FILE_STREAM.is(dataId)) {
            return this.getSelectedFiles();
        }
        if (VcsDataKeys.FILE_PATH_STREAM.is(dataId)) {
            return this.getSelectedFilePaths();
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            VirtualFile file = (VirtualFile)UtilKt.getIfSingle(this.getNavigatableFiles());
            return file != null && !file.isDirectory() ? PsiNavigationSupport.getInstance().createNavigatable(this.myProject, file, 0) : null;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return ChangesUtil.getNavigatableArray((Project)this.myProject, this.getNavigatableFiles());
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.getSelectionObjectsStream().anyMatch(userObject -> !(userObject instanceof ChangeList)) ? new VirtualFileDeleteProvider() : null;
        }
        if (UNVERSIONED_FILE_PATHS_DATA_KEY.is(dataId)) {
            return this.getSelectedUnversionedFiles();
        }
        if (EXACTLY_SELECTED_FILES_DATA_KEY.is(dataId)) {
            return ChangesListView.getExactlySelectedVirtualFiles((JTree)((Object)this));
        }
        if (IGNORED_FILE_PATHS_DATA_KEY.is(dataId)) {
            return this.getSelectedIgnoredFiles();
        }
        if (VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY.is(dataId)) {
            return this.getSelectedModifiedWithoutEditing().collect(Collectors.toList());
        }
        if (LOCALLY_DELETED_CHANGES.is(dataId)) {
            return this.getSelectedLocallyDeletedChanges().collect(Collectors.toList());
        }
        if (MISSING_FILES_DATA_KEY.is(dataId)) {
            return this.getSelectedMissingFiles().collect(Collectors.toList());
        }
        if (VcsDataKeys.HAVE_LOCALLY_DELETED.is(dataId)) {
            return this.getSelectedMissingFiles().findAny().isPresent();
        }
        if (VcsDataKeys.HAVE_MODIFIED_WITHOUT_EDITING.is(dataId)) {
            return this.getSelectedModifiedWithoutEditing().findAny().isPresent();
        }
        if (VcsDataKeys.HAVE_SELECTED_CHANGES.is(dataId)) {
            return !UtilKt.isEmpty(this.getSelectedChanges());
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        return super.getData(dataId);
    }

    @NotNull
    public Stream<FilePath> getUnversionedFiles() {
        Enumeration<TreeNode> nodes = this.getRoot().children();
        ChangesBrowserUnversionedFilesNode node = (ChangesBrowserUnversionedFilesNode)ContainerUtil.findInstance((Iterator)ContainerUtil.iterate(nodes), ChangesBrowserUnversionedFilesNode.class);
        if (node == null) {
            Stream<FilePath> stream = Stream.empty();
            if (stream == null) {
                ChangesListView.$$$reportNull$$$0(5);
            }
            return stream;
        }
        Stream<FilePath> stream = node.getFilePathsUnderStream();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(6);
        }
        return stream;
    }

    @NotNull
    static Stream<FilePath> getSelectedUnversionedFiles(@NotNull JTree tree) {
        if (tree == null) {
            ChangesListView.$$$reportNull$$$0(7);
        }
        return ChangesListView.getSelectedFilePaths(tree, ChangesBrowserNode.UNVERSIONED_FILES_TAG);
    }

    @NotNull
    public Stream<FilePath> getSelectedUnversionedFiles() {
        return ChangesListView.getSelectedUnversionedFiles((JTree)((Object)this));
    }

    @NotNull
    private Stream<FilePath> getSelectedIgnoredFiles() {
        Stream<FilePath> stream = this.getSelectedFilePaths(ChangesBrowserNode.IGNORED_FILES_TAG);
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(8);
        }
        return stream;
    }

    @NotNull
    private Stream<VirtualFile> getSelectedModifiedWithoutEditing() {
        Stream<VirtualFile> stream = this.getSelectedVirtualFiles(ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG);
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(9);
        }
        return stream;
    }

    @NotNull
    protected Stream<VirtualFile> getSelectedVirtualFiles(@Nullable Object tag) {
        Stream<VirtualFile> stream = ChangesListView.getSelectionNodesStream((JTree)((Object)this), tag).flatMap(ChangesBrowserNode::getFilesUnderStream).distinct();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(10);
        }
        return stream;
    }

    @NotNull
    protected Stream<FilePath> getSelectedFilePaths(@Nullable Object tag) {
        return ChangesListView.getSelectedFilePaths((JTree)((Object)this), tag);
    }

    @NotNull
    private static Stream<FilePath> getSelectedFilePaths(@NotNull JTree tree, @Nullable Object tag) {
        if (tree == null) {
            ChangesListView.$$$reportNull$$$0(11);
        }
        Stream<FilePath> stream = ChangesListView.getSelectionNodesStream(tree, tag).flatMap(ChangesBrowserNode::getFilePathsUnderStream).distinct();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(12);
        }
        return stream;
    }

    @NotNull
    static Stream<VirtualFile> getExactlySelectedVirtualFiles(@NotNull JTree tree) {
        if (tree == null) {
            ChangesListView.$$$reportNull$$$0(13);
        }
        VcsTreeModelData exactlySelected = VcsTreeModelData.exactlySelected(tree);
        Stream<VirtualFile> stream = exactlySelected.rawUserObjectsStream().map(object -> {
            if (object instanceof VirtualFile) {
                return (VirtualFile)object;
            }
            if (object instanceof FilePath) {
                return ((FilePath)object).getVirtualFile();
            }
            return null;
        }).filter(Objects::nonNull);
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(14);
        }
        return stream;
    }

    @NotNull
    private Stream<ChangesBrowserNode<?>> getSelectionNodesStream() {
        return ChangesListView.getSelectionNodesStream((JTree)((Object)this), null);
    }

    @NotNull
    private static Stream<ChangesBrowserNode<?>> getSelectionNodesStream(@NotNull JTree tree, @Nullable Object tag) {
        if (tree == null) {
            ChangesListView.$$$reportNull$$$0(15);
        }
        Stream<ChangesBrowserNode<?>> stream = UtilKt.stream((Object[])tree.getSelectionPaths()).filter(path2 -> ChangesListView.isUnderTag(path2, tag)).map(TreePath::getLastPathComponent).map(node -> (ChangesBrowserNode)node);
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(16);
        }
        return stream;
    }

    @NotNull
    private Stream<Object> getSelectionObjectsStream() {
        Stream<Object> stream = this.getSelectionNodesStream().map(ChangesBrowserNode::getUserObject);
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(17);
        }
        return stream;
    }

    @NotNull
    static Stream<VirtualFile> getVirtualFiles(TreePath @Nullable [] paths, @Nullable Object tag) {
        Stream<VirtualFile> stream = UtilKt.stream((Object[])paths).filter(path2 -> ChangesListView.isUnderTag(path2, tag)).map(TreePath::getLastPathComponent).map(node -> (ChangesBrowserNode)node).flatMap(ChangesBrowserNode::getFilesUnderStream).distinct();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(18);
        }
        return stream;
    }

    @NotNull
    static Stream<FilePath> getFilePaths(TreePath @Nullable [] paths, @Nullable Object tag) {
        Stream<FilePath> stream = UtilKt.stream((Object[])paths).filter(path2 -> ChangesListView.isUnderTag(path2, tag)).map(TreePath::getLastPathComponent).map(node -> (ChangesBrowserNode)node).flatMap(ChangesBrowserNode::getFilePathsUnderStream).distinct();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(19);
        }
        return stream;
    }

    static boolean isUnderTag(@NotNull TreePath path2, @Nullable Object tag) {
        if (path2 == null) {
            ChangesListView.$$$reportNull$$$0(20);
        }
        boolean result2 = true;
        if (tag != null) {
            result2 = path2.getPathCount() > 1 && ((ChangesBrowserNode)path2.getPathComponent(1)).getUserObject() == tag;
        }
        return result2;
    }

    @NotNull
    static Stream<Change> getChanges(@NotNull Project project, TreePath @Nullable [] paths) {
        if (project == null) {
            ChangesListView.$$$reportNull$$$0(21);
        }
        Stream<Change> changes = UtilKt.stream((Object[])paths).map(TreePath::getLastPathComponent).map(node -> (ChangesBrowserNode)node).flatMap(node -> node.getObjectsUnderStream(Change.class)).map(Change.class::cast);
        Stream<Change> hijackedChanges = ChangesListView.getVirtualFiles(paths, ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG).map(file -> ChangesListView.toHijackedChange(project, file)).filter(Objects::nonNull);
        Stream<Change> stream = Stream.concat(changes, hijackedChanges).filter(new DistinctChangePredicate());
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(22);
        }
        return stream;
    }

    @Nullable
    private static Change toHijackedChange(@NotNull Project project, @NotNull VirtualFile file) {
        VcsCurrentRevisionProxy before;
        if (project == null) {
            ChangesListView.$$$reportNull$$$0(23);
        }
        if (file == null) {
            ChangesListView.$$$reportNull$$$0(24);
        }
        if ((before = VcsCurrentRevisionProxy.create(file, project)) != null) {
            CurrentContentRevision afterRevision = new CurrentContentRevision(VcsUtil.getFilePath((VirtualFile)file));
            return new Change((ContentRevision)before, (ContentRevision)afterRevision, FileStatus.HIJACKED);
        }
        return null;
    }

    @NotNull
    private Stream<LocallyDeletedChange> getSelectedLocallyDeletedChanges() {
        Stream<LocallyDeletedChange> stream = ChangesListView.getSelectionNodesStream((JTree)((Object)this), ChangesBrowserNode.LOCALLY_DELETED_NODE_TAG).flatMap(node -> node.getObjectsUnderStream(LocallyDeletedChange.class)).distinct();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(25);
        }
        return stream;
    }

    @NotNull
    private Stream<FilePath> getSelectedMissingFiles() {
        Stream<FilePath> stream = this.getSelectedLocallyDeletedChanges().map(LocallyDeletedChange::getPath);
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(26);
        }
        return stream;
    }

    @NotNull
    private Stream<FilePath> getSelectedFilePaths() {
        Stream<FilePath> stream = UtilKt.concat((Stream[])new Stream[]{this.getSelectedChanges().map(ChangesUtil::getFilePath), this.getSelectedVirtualFiles(null).map(VcsUtil::getFilePath), this.getSelectedFilePaths(null)}).distinct();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(27);
        }
        return stream;
    }

    @NotNull
    private Stream<VirtualFile> getSelectedFiles() {
        Stream<VirtualFile> stream = UtilKt.concat((Stream[])new Stream[]{ChangesUtil.getAfterRevisionsFiles(this.getSelectedChanges()), this.getSelectedVirtualFiles(null), ChangesUtil.getFilesFromPaths(this.getSelectedFilePaths(null))}).distinct();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(28);
        }
        return stream;
    }

    @NotNull
    private Stream<VirtualFile> getNavigatableFiles() {
        Stream<VirtualFile> stream = UtilKt.concat((Stream[])new Stream[]{ChangesUtil.getFiles(this.getSelectedChanges()), this.getSelectedVirtualFiles(null), ChangesUtil.getFilesFromPaths(this.getSelectedFilePaths(null))}).distinct();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(29);
        }
        return stream;
    }

    @NotNull
    private Stream<Change> getLeadSelection() {
        Stream<Change> stream = this.getSelectionNodesStream().filter(node -> node instanceof ChangesBrowserChangeNode).map(ChangesBrowserChangeNode.class::cast).map(ChangesBrowserNode::getUserObject).filter(new DistinctChangePredicate());
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(30);
        }
        return stream;
    }

    @NotNull
    public Stream<Change> getChanges() {
        Stream<Change> stream = this.getRoot().getObjectsUnderStream(Change.class);
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(31);
        }
        return stream;
    }

    @Nullable
    public List<Change> getAllChangesFromSameChangelist(@NotNull Change change) {
        if (change == null) {
            ChangesListView.$$$reportNull$$$0(32);
        }
        for (DefaultMutableTreeNode node = this.findNodeInTree(change); node != null; node = (DefaultMutableTreeNode)node.getParent()) {
            if (node instanceof ChangesBrowserChangeListNode) {
                return ((ChangesBrowserChangeListNode)node).getAllChangesUnder();
            }
            if (node != this.getRoot() || !Registry.is((String)"vcs.skip.single.default.changelist")) continue;
            return this.getRoot().getAllChangesUnder();
        }
        return null;
    }

    @NotNull
    public Stream<Change> getSelectedChanges() {
        return ChangesListView.getChanges(this.myProject, this.getSelectionPaths());
    }

    @NotNull
    private Stream<ChangeList> getSelectedChangeLists() {
        Stream<ChangeList> stream = this.getSelectionObjectsStream().filter(userObject -> userObject instanceof ChangeList).map(ChangeList.class::cast).distinct();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(33);
        }
        return stream;
    }

    @Override
    public void installPopupHandler(@NotNull ActionGroup group2) {
        if (group2 == null) {
            ChangesListView.$$$reportNull$$$0(34);
        }
        PopupHandler.installPopupHandler((JComponent)((Object)this), (ActionGroup)group2, (String)"ChangesViewPopup", (ActionManager)ActionManager.getInstance());
    }

    @NotNull
    public JComponent getComponent() {
        ChangesListView changesListView = this;
        if (changesListView == null) {
            ChangesListView.$$$reportNull$$$0(35);
        }
        return changesListView;
    }

    public void processMouseEvent(MouseEvent e) {
        if (!(502 != e.getID() || this.isSelectionEmpty() || e.isShiftDown() || e.isControlDown() || e.isMetaDown() || e.isPopupTrigger() || !this.isOverSelection(e.getPoint()))) {
            this.clearSelection();
            TreePath path2 = this.getPathForLocation(e.getPoint().x, e.getPoint().y);
            if (path2 != null) {
                this.setSelectionPath(path2);
            }
        }
        super.processMouseEvent(e);
    }

    public boolean isOverSelection(Point point) {
        return TreeUtil.isOverSelection((JTree)((Object)this), (Point)point);
    }

    public void dropSelectionButUnderPoint(Point point) {
        TreeUtil.dropSelectionButUnderPoint((JTree)((Object)this), (Point)point);
    }

    @Nullable
    public DefaultMutableTreeNode findNodeInTree(Object userObject) {
        if (userObject instanceof LocalChangeList) {
            return (DefaultMutableTreeNode)TreeUtil.nodeChildren(this.getRoot()).filter(DefaultMutableTreeNode.class).find(node -> userObject.equals(node.getUserObject()));
        }
        if (userObject instanceof ChangeListChange) {
            return TreeUtil.findNode(this.getRoot(), node -> ChangeListChange.HASHING_STRATEGY.equals(node.getUserObject(), userObject));
        }
        return TreeUtil.findNodeWithObject(this.getRoot(), (Object)userObject);
    }

    @Nullable
    public TreePath findNodePathInTree(Object userObject) {
        DefaultMutableTreeNode node = this.findNodeInTree(userObject);
        return node != null ? TreeUtil.getPathFromRoot((TreeNode)node) : null;
    }

    public void expandSafe(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            ChangesListView.$$$reportNull$$$0(36);
        }
        if (node.getChildCount() <= 10000) {
            this.expandPath(TreeUtil.getPathFromRoot((TreeNode)node));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesListView";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesListView";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnversionedFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedIgnoredFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedModifiedWithoutEditing";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedVirtualFiles";
                break;
            }
            case 12: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFilePaths";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getExactlySelectedVirtualFiles";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionNodesStream";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionObjectsStream";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFiles";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePaths";
                break;
            }
            case 22: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedLocallyDeletedChanges";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedMissingFiles";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigatableFiles";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeadSelection";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChangeLists";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isInclusionVisible";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateModel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultChangelistNode";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 35: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedUnversionedFiles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedFilePaths";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getExactlySelectedVirtualFiles";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSelectionNodesStream";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isUnderTag";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getChanges";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "toHijackedChange";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getAllChangesFromSameChangelist";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "installPopupHandler";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "expandSafe";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DistinctChangePredicate
    implements Predicate<Change> {
        private final Set<Object> seen = new ObjectOpenCustomHashSet(ChangeListChange.HASHING_STRATEGY);

        private DistinctChangePredicate() {
        }

        @Override
        public boolean test(Change change) {
            return this.seen.add(change);
        }
    }
}

