/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt.engine.local.saxon9;

import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.InstructionDetails;
import net.sf.saxon.expr.instruct.TraceExpression;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trace.InstructionInfo;
import org.intellij.plugins.xsltDebugger.rt.engine.Debugger;
import org.intellij.plugins.xsltDebugger.rt.engine.Value;
import org.intellij.plugins.xsltDebugger.rt.engine.local.LocalDebugger;
import org.intellij.plugins.xsltDebugger.rt.engine.local.saxon9.AbstractSaxon9Frame;
import org.intellij.plugins.xsltDebugger.rt.engine.local.saxon9.Saxon9SourceFrame;
import org.intellij.plugins.xsltDebugger.rt.engine.local.saxon9.Saxon9StyleFrame;

public class Saxon9TraceListener
implements TraceListener {
    private static final boolean TRACE = "true".equals(System.getProperty("xslt.debugger.trace", "false"));
    private LocalDebugger myDebugger;
    static boolean MUTED;

    public void setDebugger(LocalDebugger debugger) {
        this.myDebugger = debugger;
    }

    private static void trace(String s) {
        if (TRACE) {
            System.err.println(s);
        }
    }

    public void open(Controller controller) {
        this.myDebugger.getEventQueue().startDocument();
        Saxon9TraceListener.trace("<trace>");
    }

    public void setOutputDestination(Logger logger) {
    }

    public void close() {
        this.myDebugger.getEventQueue().endDocument();
        Saxon9TraceListener.trace("</trace>");
    }

    public void enter(InstructionInfo instructionInfo, XPathContext xPathContext) {
        if (MUTED) {
            return;
        }
        Saxon9TraceListener.trace("<" + instructionInfo + ">");
        if (instructionInfo instanceof TraceExpression) {
            this.myDebugger.enter(new Saxon9StyleFrame(this.myDebugger.getCurrentFrame(), (TraceExpression)instructionInfo, xPathContext));
        } else if (instructionInfo instanceof InstructionDetails) {
            this.myDebugger.enter(new VirtualFrame(this.myDebugger.getCurrentFrame(), (InstructionDetails)instructionInfo));
        }
    }

    public void leave(InstructionInfo instructionInfo) {
        if (MUTED) {
            return;
        }
        Saxon9TraceListener.trace("</>");
        if (instructionInfo instanceof TraceExpression || instructionInfo instanceof InstructionDetails) {
            this.myDebugger.leave();
        }
    }

    public void startCurrentItem(Item item) {
        if (MUTED) {
            return;
        }
        if (item instanceof NodeInfo) {
            Saxon9TraceListener.trace("<" + ((NodeInfo)item).getDisplayName() + ">");
            this.myDebugger.pushSource(new Saxon9SourceFrame<NodeInfo>(this.myDebugger.getSourceFrame(), (NodeInfo)item));
        }
    }

    public void endCurrentItem(Item item) {
        if (MUTED) {
            return;
        }
        if (item instanceof NodeInfo) {
            this.myDebugger.popSource();
        }
    }

    private static class VirtualFrame
    extends AbstractSaxon9Frame<Debugger.StyleFrame, SourceLocator>
    implements Debugger.StyleFrame {
        VirtualFrame(Debugger.StyleFrame previous, InstructionDetails instr) {
            super(previous, new MySource(instr));
        }

        public String getInstruction() {
            return ((Debugger.StyleFrame)this.getPrevious()).getInstruction();
        }

        public Value eval(String expr) throws Debugger.EvaluationException {
            return ((Debugger.StyleFrame)this.getPrevious()).eval(expr);
        }

        public List<Debugger.Variable> getVariables() {
            return ((Debugger.StyleFrame)this.getPrevious()).getVariables();
        }

        private static class MySource
        implements Source,
        SourceLocator {
            private final InstructionDetails myInstruction;

            MySource(InstructionDetails instr) {
                this.myInstruction = instr;
            }

            @Override
            public void setSystemId(String systemId) {
            }

            @Override
            public String getPublicId() {
                return null;
            }

            @Override
            public String getSystemId() {
                return this.myInstruction.getSystemId();
            }

            @Override
            public int getLineNumber() {
                return this.myInstruction.getLineNumber();
            }

            @Override
            public int getColumnNumber() {
                return this.myInstruction.getColumnNumber();
            }
        }
    }
}

