/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathsList;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KotlinIdeaReplBundle;
import org.jetbrains.kotlin.console.KotlinConsoleRunner;
import org.jetbrains.kotlin.idea.artifacts.KotlinArtifacts;
import org.jetbrains.kotlin.idea.artifacts.KotlinClassPath;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.idea.util.JavaParametersBuilder;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JdkPlatform;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u0007J\u0018\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\bJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u0007J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/console/KotlinConsoleKeeper;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "consoleMap", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getConsoleByVirtualFile", "virtualFile", "putVirtualFileToConsole", "console", "removeConsole", "run", "module", "Lcom/intellij/openapi/module/Module;", "previousCompilationFailed", "", "Companion", "kotlin.repl"})
public final class KotlinConsoleKeeper {
    private final Map<VirtualFile, KotlinConsoleRunner> consoleMap;
    @NotNull
    private final Project project;
    private static final Logger LOG;
    public static final Companion Companion;

    @Nullable
    public final KotlinConsoleRunner getConsoleByVirtualFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return this.consoleMap.get(virtualFile);
    }

    @Nullable
    public final KotlinConsoleRunner putVirtualFileToConsole(@NotNull VirtualFile virtualFile, @NotNull KotlinConsoleRunner console) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)((Object)console), (String)"console");
        return this.consoleMap.put(virtualFile, console);
    }

    @Nullable
    public final KotlinConsoleRunner removeConsole(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return this.consoleMap.remove(virtualFile);
    }

    @Nullable
    public final KotlinConsoleRunner run(@NotNull Module module, boolean previousCompilationFailed) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        String string = module.getModuleFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.moduleFilePath");
        String path = string;
        GeneralCommandLine cmdLine = Companion.createReplCommandLine(this.project, module);
        KotlinConsoleRunner consoleRunner = new KotlinConsoleRunner(module, cmdLine, previousCompilationFailed, this.project, KotlinIdeaReplBundle.message("name.kotlin.repl", new Object[0]), path);
        consoleRunner.initAndRun();
        return consoleRunner;
    }

    public static /* synthetic */ KotlinConsoleRunner run$default(KotlinConsoleKeeper kotlinConsoleKeeper, Module module, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return kotlinConsoleKeeper.run(module, bl);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public KotlinConsoleKeeper(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.consoleMap = new ConcurrentHashMap();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance((String)"#org.jetbrains.kotlin.console");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#org\u2026etbrains.kotlin.console\")");
        LOG = logger;
    }

    @JvmStatic
    public static final KotlinConsoleKeeper getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r2\u0006\u0010\b\u001a\u00020\tH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/console/KotlinConsoleKeeper$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createReplCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "getInstance", "Lorg/jetbrains/kotlin/console/KotlinConsoleKeeper;", "kotlin.jvm.PlatformType", "kotlin.repl"})
    public static final class Companion {
        @JvmStatic
        public final KotlinConsoleKeeper getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return (KotlinConsoleKeeper)ServiceManager.getService((Project)project, KotlinConsoleKeeper.class);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final GeneralCommandLine createReplCommandLine(@NotNull Project project, @Nullable Module module) {
            void it;
            Object $this$filterIsInstance$iv$iv2;
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            JavaParameters javaParameters = new JavaParametersBuilder(project).withSdkFrom(module, true).withMainClassName("org.jetbrains.kotlin.cli.jvm.K2JVMCompiler").build();
            javaParameters.setCharset((Charset)null);
            javaParameters.getVMParametersList().add("-Dkotlin.repl.ideMode=true");
            KotlinArtifacts kotlinArtifacts = KotlinArtifacts.Companion.getInstance();
            Object object = javaParameters.getClassPath();
            boolean bl = false;
            boolean bl2 = false;
            PathsList $this$apply = object;
            boolean bl3 = false;
            List classPath = KotlinClassPath.CompilerWithScripting.computeClassPath();
            Iterable iterable = classPath;
            PathsList pathsList = $this$apply;
            boolean $i$f$map = false;
            void var14_24 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                File file = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                String absolutePath = it2.getAbsolutePath();
                if (!it2.exists()) {
                    LOG.warn("Compiler dependency classpath " + absolutePath + " does not exist");
                }
                String string = absolutePath;
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            pathsList.addAll((List)collection);
            if (module != null) {
                void $this$filterIsInstanceTo$iv$iv$iv;
                List classPath2 = JavaParametersBuilder.Companion.getModuleDependencies(module);
                Collection collection2 = classPath2;
                bl2 = false;
                if (!collection2.isEmpty()) {
                    javaParameters.setUseDynamicParameters(javaParameters.isDynamicClasspath());
                    javaParameters.getProgramParametersList().add("-cp");
                    ParametersList parametersList = javaParameters.getProgramParametersList();
                    Iterable iterable2 = classPath2;
                    String string = File.pathSeparator;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File.pathSeparator");
                    parametersList.add(CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)string, null, null, (int)0, null, null, (int)62, null));
                }
                TargetPlatform targetPlatform = TargetPlatformDetector.getPlatform((Module)module);
                Intrinsics.checkNotNullExpressionValue((Object)targetPlatform, (String)"TargetPlatformDetector.getPlatform(module)");
                TargetPlatform $this$subplatformsOfType$iv = targetPlatform;
                boolean $i$f$subplatformsOfType = false;
                $this$filterIsInstance$iv$iv2 = $this$subplatformsOfType$iv.getComponentPlatforms();
                boolean $i$f$filterIsInstance = false;
                classPath = $this$filterIsInstance$iv$iv2;
                Collection destination$iv$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                    if (!(element$iv$iv$iv instanceof JdkPlatform)) continue;
                    destination$iv$iv$iv.add(element$iv$iv$iv);
                }
                JdkPlatform jdkPlatform = (JdkPlatform)CollectionsKt.firstOrNull((List)((List)destination$iv$iv$iv));
                if (jdkPlatform != null && (jdkPlatform = jdkPlatform.getTargetVersion()) != null) {
                    collection2 = jdkPlatform;
                    bl2 = false;
                    boolean $this$filterIsInstance$iv$iv2 = false;
                    Collection it3 = collection2;
                    boolean bl5 = false;
                    javaParameters.getProgramParametersList().add("-jvm-target");
                    javaParameters.getProgramParametersList().add(it3.getDescription());
                }
            }
            javaParameters.getProgramParametersList().add("-kotlin-home");
            object = KotlinArtifacts.Companion.getInstance().getKotlincDirectory();
            bl = false;
            bl2 = false;
            $this$filterIsInstance$iv$iv2 = object;
            ParametersList parametersList = javaParameters.getProgramParametersList();
            boolean bl6 = false;
            boolean bl7 = it.exists();
            boolean bl8 = false;
            boolean bl9 = false;
            if (!bl7) {
                boolean bl10 = false;
                String string = "Kotlinc directory does not exist";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
            parametersList.add(((File)object).getAbsolutePath());
            GeneralCommandLine generalCommandLine = javaParameters.toCommandLine();
            Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"javaParameters.toCommandLine()");
            return generalCommandLine;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

