/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.rename;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sh.ShBundle;
import com.intellij.sh.statistics.ShFeatureUsagesCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ShTextRenameRefactoring {
    @NonNls
    private static final String FEATURE_ACTION_ID = "RenamingActionUsed";
    @NonNls
    private static final String PRIMARY_VARIABLE_NAME = "PrimaryVariable";
    @NonNls
    private static final String OTHER_VARIABLE_NAME = "OtherVariable";
    private final Editor myEditor;
    private final Project myProject;
    private final PsiFile myPsiFile;
    private final Collection<TextRange> myOccurrenceRanges;
    private final String myOccurrenceText;
    private final TextRange myOccurrenceRangeAtCaret;
    private RangeMarker myCaretRangeMarker;
    private List<RangeHighlighter> myHighlighters;

    private ShTextRenameRefactoring(@NotNull Editor editor, @NotNull Project project, @NotNull PsiFile psiFile, @NotNull String occurrenceText, @NotNull Collection<TextRange> occurrenceRanges, @NotNull TextRange occurrenceRangeAtCaret) {
        if (editor == null) {
            ShTextRenameRefactoring.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ShTextRenameRefactoring.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            ShTextRenameRefactoring.$$$reportNull$$$0(2);
        }
        if (occurrenceText == null) {
            ShTextRenameRefactoring.$$$reportNull$$$0(3);
        }
        if (occurrenceRanges == null) {
            ShTextRenameRefactoring.$$$reportNull$$$0(4);
        }
        if (occurrenceRangeAtCaret == null) {
            ShTextRenameRefactoring.$$$reportNull$$$0(5);
        }
        this.myEditor = editor;
        this.myProject = project;
        this.myPsiFile = psiFile;
        this.myOccurrenceText = occurrenceText;
        this.myOccurrenceRanges = occurrenceRanges;
        this.myOccurrenceRangeAtCaret = occurrenceRangeAtCaret;
    }

    @Nullable
    static ShTextRenameRefactoring create(@NotNull Editor editor, @NotNull Project project, @NotNull String occurrenceText, @NotNull Collection<TextRange> occurrenceRanges, @NotNull TextRange occurrenceRangeAtCaret) {
        PsiFile psiFile;
        if (editor == null) {
            ShTextRenameRefactoring.$$$reportNull$$$0(6);
        }
        if (project == null) {
            ShTextRenameRefactoring.$$$reportNull$$$0(7);
        }
        if (occurrenceText == null) {
            ShTextRenameRefactoring.$$$reportNull$$$0(8);
        }
        if (occurrenceRanges == null) {
            ShTextRenameRefactoring.$$$reportNull$$$0(9);
        }
        if (occurrenceRangeAtCaret == null) {
            ShTextRenameRefactoring.$$$reportNull$$$0(10);
        }
        if ((psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) != null) {
            return new ShTextRenameRefactoring(editor, project, psiFile, occurrenceText, occurrenceRanges, occurrenceRangeAtCaret);
        }
        return null;
    }

    void start() {
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)this.myPsiFile);
        for (TextRange occurrence : this.myOccurrenceRanges) {
            if (occurrence.equals((Object)this.myOccurrenceRangeAtCaret)) {
                builder.replaceElement((PsiElement)this.myPsiFile, occurrence, PRIMARY_VARIABLE_NAME, (Expression)new MyExpression(this.myOccurrenceText), true);
                continue;
            }
            builder.replaceElement((PsiElement)this.myPsiFile, occurrence, OTHER_VARIABLE_NAME, PRIMARY_VARIABLE_NAME, false);
        }
        this.createCaretRangeMarker();
        WriteCommandAction.writeCommandAction((Project)this.myProject).withName(ShBundle.message("sh.rename.occurence", this.myOccurrenceText)).run(() -> this.startTemplate(builder));
        ShFeatureUsagesCollector.logFeatureUsage(FEATURE_ACTION_ID);
    }

    private void createCaretRangeMarker() {
        int offset = this.myEditor.getCaretModel().getOffset();
        this.myCaretRangeMarker = this.myEditor.getDocument().createRangeMarker(offset, offset);
        this.myCaretRangeMarker.setGreedyToLeft(true);
        this.myCaretRangeMarker.setGreedyToRight(true);
    }

    private void startTemplate(TemplateBuilderImpl builder) {
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        TextRange range = this.myPsiFile.getTextRange();
        assert (range != null);
        RangeMarker rangeMarker = this.myEditor.getDocument().createRangeMarker(range);
        Template template = builder.buildInlineTemplate();
        template.setToShortenLongNames(false);
        template.setToReformat(false);
        this.myEditor.getCaretModel().moveToOffset(rangeMarker.getStartOffset());
        TemplateManager.getInstance((Project)this.myProject).startTemplate(this.myEditor, template, (TemplateEditingListener)new MyTemplateListener());
        this.restoreOldCaretPositionAndSelection(caretOffset);
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.highlightTemplateVariables(template);
    }

    private void highlightTemplateVariables(@NotNull Template template) {
        if (template == null) {
            ShTextRenameRefactoring.$$$reportNull$$$0(11);
        }
        if (this.myHighlighters != null) {
            HashMap<TextRange, TextAttributes> rangesToHighlight = new HashMap<TextRange, TextAttributes>();
            TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)this.myEditor);
            if (templateState != null) {
                EditorColorsManager colorsManager = EditorColorsManager.getInstance();
                for (int i = 0; i < templateState.getSegmentsCount(); ++i) {
                    TextRange segmentOffset = templateState.getSegmentRange(i);
                    TextAttributes attributes = ShTextRenameRefactoring.getAttributes(colorsManager, template.getSegmentName(i));
                    if (attributes == null) continue;
                    rangesToHighlight.put(segmentOffset, attributes);
                }
            }
            this.addHighlights(rangesToHighlight, this.myHighlighters);
        }
    }

    @Nullable
    private static TextAttributes getAttributes(@NotNull EditorColorsManager colorsManager, @NotNull String segmentName) {
        if (colorsManager == null) {
            ShTextRenameRefactoring.$$$reportNull$$$0(12);
        }
        if (segmentName == null) {
            ShTextRenameRefactoring.$$$reportNull$$$0(13);
        }
        if (segmentName.equals(PRIMARY_VARIABLE_NAME)) {
            return colorsManager.getGlobalScheme().getAttributes(EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES);
        }
        if (segmentName.equals(OTHER_VARIABLE_NAME)) {
            return colorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        }
        return null;
    }

    private void addHighlights(@NotNull Map<TextRange, TextAttributes> ranges, @NotNull Collection<RangeHighlighter> highlighters) {
        if (ranges == null) {
            ShTextRenameRefactoring.$$$reportNull$$$0(14);
        }
        if (highlighters == null) {
            ShTextRenameRefactoring.$$$reportNull$$$0(15);
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
        for (Map.Entry<TextRange, TextAttributes> entry : ranges.entrySet()) {
            TextRange range = entry.getKey();
            TextAttributes attributes = entry.getValue();
            highlightManager.addOccurrenceHighlight(this.myEditor, range.getStartOffset(), range.getEndOffset(), attributes, 0, highlighters, null);
        }
        for (RangeHighlighter highlighter : highlighters) {
            highlighter.setGreedyToLeft(true);
            highlighter.setGreedyToRight(true);
        }
    }

    private void clearHighlights() {
        if (this.myHighlighters != null) {
            if (!this.myProject.isDisposed()) {
                HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
                for (RangeHighlighter highlighter : this.myHighlighters) {
                    highlightManager.removeSegmentHighlighter(this.myEditor, highlighter);
                }
            }
            this.myHighlighters = null;
        }
    }

    private void restoreOldCaretPositionAndSelection(int offset) {
        Runnable runnable = () -> this.myEditor.getCaretModel().moveToOffset(this.restoreCaretOffset(offset));
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup((Editor)this.myEditor);
        if (lookup != null && lookup.getLookupStart() <= this.restoreCaretOffset(offset)) {
            lookup.setLookupFocusDegree(LookupFocusDegree.UNFOCUSED);
            lookup.performGuardedChange(runnable);
        } else {
            runnable.run();
        }
    }

    private int restoreCaretOffset(int offset) {
        return this.myCaretRangeMarker.isValid() ? this.myCaretRangeMarker.getEndOffset() : offset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrenceText";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrenceRanges";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrenceRangeAtCaret";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsManager";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segmentName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighters";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sh/rename/ShTextRenameRefactoring";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightTemplateVariables";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getAttributes";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "addHighlights";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyTemplateListener
    extends TemplateEditingAdapter {
        private MyTemplateListener() {
        }

        public void beforeTemplateFinished(@NotNull TemplateState templateState, Template template) {
            if (templateState == null) {
                MyTemplateListener.$$$reportNull$$$0(0);
            }
            ShTextRenameRefactoring.this.clearHighlights();
        }

        public void templateCancelled(Template template) {
            ShTextRenameRefactoring.this.clearHighlights();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateState", "com/intellij/sh/rename/ShTextRenameRefactoring$MyTemplateListener", "beforeTemplateFinished"));
        }
    }

    private static final class MyExpression
    extends Expression {
        private final String myInitialText;

        private MyExpression(@NotNull String initialText) {
            if (initialText == null) {
                MyExpression.$$$reportNull$$$0(0);
            }
            this.myInitialText = initialText;
        }

        public Result calculateResult(ExpressionContext context) {
            Editor editor = context.getEditor();
            if (editor != null) {
                TextResult insertedValue;
                TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)editor);
                TextResult textResult = insertedValue = templateState != null ? templateState.getVariableValue(ShTextRenameRefactoring.PRIMARY_VARIABLE_NAME) : null;
                if (insertedValue != null && !insertedValue.getText().isEmpty()) {
                    return insertedValue;
                }
            }
            return new TextResult(this.myInitialText);
        }

        public LookupElement[] calculateLookupItems(ExpressionContext context) {
            return LookupElement.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialText", "com/intellij/sh/rename/ShTextRenameRefactoring$MyExpression", "<init>"));
        }
    }
}

