/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformDependencies;
import org.gradle.api.internal.artifacts.transform.DefaultArtifactTransformDependencies;
import org.gradle.api.internal.artifacts.transform.ExecutionGraphDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.FilteredResultFactory;
import org.gradle.api.internal.artifacts.transform.TransformationStep;
import org.gradle.api.internal.artifacts.transform.Transformer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.WorkNodeAction;
import org.gradle.internal.Factory;
import org.gradle.internal.Try;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprinter;

public class DefaultExecutionGraphDependenciesResolver
implements ExecutionGraphDependenciesResolver {
    public static final ArtifactTransformDependencies MISSING_DEPENDENCIES = new ArtifactTransformDependencies(){

        @Override
        public FileCollection getFiles() {
            throw new IllegalStateException("Transform does not use artifact dependencies.");
        }

        @Override
        public CurrentFileCollectionFingerprint fingerprint(FileCollectionFingerprinter fingerprinter) {
            return fingerprinter.empty();
        }
    };
    private final ComponentIdentifier componentIdentifier;
    private final Factory<ResolverResults> graphResults;
    private final Factory<ResolverResults> artifactResults;
    private final DomainObjectContext owner;
    private final FilteredResultFactory filteredResultFactory;
    private Set<ComponentIdentifier> dependencies;
    private TaskDependencyContainer taskDependencies;

    public DefaultExecutionGraphDependenciesResolver(ComponentIdentifier componentIdentifier, Factory<ResolverResults> graphResults, Factory<ResolverResults> artifactResults, DomainObjectContext owner, FilteredResultFactory filteredResultFactory) {
        this.componentIdentifier = componentIdentifier;
        this.graphResults = graphResults;
        this.artifactResults = artifactResults;
        this.owner = owner;
        this.filteredResultFactory = filteredResultFactory;
    }

    @Override
    public FileCollection selectedArtifacts(Transformer transformer) {
        if (!transformer.requiresDependencies()) {
            return MISSING_DEPENDENCIES.getFiles();
        }
        return this.selectedArtifacts(transformer.getFromAttributes());
    }

    @Override
    public Try<ArtifactTransformDependencies> computeArtifacts(Transformer transformer) {
        if (!transformer.requiresDependencies()) {
            return Try.successful(MISSING_DEPENDENCIES);
        }
        return this.resolvedArtifacts(transformer.getFromAttributes());
    }

    private Try<ArtifactTransformDependencies> resolvedArtifacts(ImmutableAttributes fromAttributes) {
        try {
            FileCollectionInternal files2 = this.selectedArtifacts(fromAttributes);
            files2.getFiles();
            return Try.successful(new DefaultArtifactTransformDependencies(files2));
        }
        catch (Exception e) {
            return Try.failure(e);
        }
    }

    private FileCollectionInternal selectedArtifacts(ImmutableAttributes fromAttributes) {
        ResolverResults results = this.artifactResults.create();
        if (this.dependencies == null) {
            this.dependencies = DefaultExecutionGraphDependenciesResolver.computeDependencies(this.componentIdentifier, ComponentIdentifier.class, results.getResolutionResult().getAllComponents(), false);
        }
        return this.filteredResultFactory.resultsMatching(fromAttributes, element -> this.dependencies.contains(element));
    }

    @Override
    public TaskDependencyContainer computeDependencyNodes(TransformationStep transformationStep) {
        if (!transformationStep.requiresDependencies()) {
            return TaskDependencyContainer.EMPTY;
        }
        if (this.taskDependencies == null) {
            this.taskDependencies = context -> {
                ResolverResults results = this.graphResults.create();
                Set<ComponentIdentifier> buildDependencies = DefaultExecutionGraphDependenciesResolver.computeDependencies(this.componentIdentifier, ComponentIdentifier.class, results.getResolutionResult().getAllComponents(), true);
                FileCollectionInternal files2 = this.filteredResultFactory.resultsMatching(transformationStep.getFromAttributes(), element -> buildDependencies.contains(element));
                context.add(new FinalizeTransformDependencies(files2, transformationStep));
            };
        }
        return this.taskDependencies;
    }

    private static Set<ComponentIdentifier> computeDependencies(ComponentIdentifier componentIdentifier, Class<? extends ComponentIdentifier> type, Set<ResolvedComponentResult> componentResults, boolean strict) {
        ResolvedComponentResult targetComponent = null;
        for (ResolvedComponentResult component : componentResults) {
            if (!component.getId().equals(componentIdentifier)) continue;
            targetComponent = component;
            break;
        }
        if (targetComponent == null) {
            if (strict) {
                throw new AssertionError((Object)("Could not find component " + componentIdentifier + " in provided results."));
            }
            return Collections.emptySet();
        }
        HashSet<ComponentIdentifier> buildDependencies = new HashSet<ComponentIdentifier>();
        DefaultExecutionGraphDependenciesResolver.collectDependenciesIdentifiers(buildDependencies, type, new HashSet<ComponentIdentifier>(), targetComponent.getDependencies());
        return buildDependencies;
    }

    private static void collectDependenciesIdentifiers(Set<ComponentIdentifier> dependenciesIdentifiers, Class<? extends ComponentIdentifier> type, Set<ComponentIdentifier> visited, Set<? extends DependencyResult> dependencies) {
        for (DependencyResult dependencyResult : dependencies) {
            if (!(dependencyResult instanceof ResolvedDependencyResult)) continue;
            ResolvedDependencyResult resolvedDependency = (ResolvedDependencyResult)dependencyResult;
            ResolvedComponentResult selected = resolvedDependency.getSelected();
            if (type.isInstance(selected.getId())) {
                dependenciesIdentifiers.add(selected.getId());
            }
            if (!visited.add(selected.getId())) continue;
            DefaultExecutionGraphDependenciesResolver.collectDependenciesIdentifiers(dependenciesIdentifiers, type, visited, selected.getDependencies());
        }
    }

    public class FinalizeTransformDependencies
    implements WorkNodeAction {
        private final FileCollectionInternal files;
        private final TransformationStep transformationStep;

        public FinalizeTransformDependencies(FileCollectionInternal files2, TransformationStep transformationStep) {
            this.files = files2;
            this.transformationStep = transformationStep;
        }

        @Override
        public Project getProject() {
            return DefaultExecutionGraphDependenciesResolver.this.owner.getProject();
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
            context.add(this.files);
        }

        @Override
        public void run(NodeExecutionContext context) {
            DefaultExecutionGraphDependenciesResolver.this.resolvedArtifacts(this.transformationStep.getFromAttributes());
        }
    }
}

