/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformListener;
import org.gradle.api.internal.artifacts.transform.ExecutionGraphDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.Transformation;
import org.gradle.api.internal.artifacts.transform.TransformationNode;
import org.gradle.api.internal.artifacts.transform.TransformationNodeRegistry;
import org.gradle.api.internal.artifacts.transform.TransformationStep;
import org.gradle.internal.impldep.com.google.common.base.Equivalence;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.operations.BuildOperationExecutor;

public class DefaultTransformationNodeRegistry
implements TransformationNodeRegistry {
    private final Map<ArtifactTransformKey, TransformationNode> transformations = Maps.newConcurrentMap();
    private final BuildOperationExecutor buildOperationExecutor;
    private final ArtifactTransformListener transformListener;

    public DefaultTransformationNodeRegistry(BuildOperationExecutor buildOperationExecutor, ArtifactTransformListener transformListener) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.transformListener = transformListener;
    }

    @Override
    public Collection<TransformationNode> getOrCreate(ResolvedArtifactSet artifactSet, Transformation transformation, ExecutionGraphDependenciesResolver dependenciesResolver) {
        List<Equivalence.Wrapper<TransformationStep>> transformationChain = DefaultTransformationNodeRegistry.unpackTransformation(transformation);
        ImmutableList.Builder builder = ImmutableList.builder();
        artifactSet.visitLocalArtifacts(localArtifacts -> {
            TransformationNode transformationNode = this.getOrCreateInternal(localArtifacts, transformationChain, dependenciesResolver);
            builder.add((Object)transformationNode);
        });
        return builder.build();
    }

    @Override
    public Optional<TransformationNode> getIfExecuted(ComponentArtifactIdentifier artifactId, Transformation transformation) {
        List<Equivalence.Wrapper<TransformationStep>> transformationChain = DefaultTransformationNodeRegistry.unpackTransformation(transformation);
        ArtifactTransformKey transformKey = new ArtifactTransformKey(artifactId, transformationChain);
        TransformationNode node = this.transformations.get(transformKey);
        if (node != null && node.isExecuted()) {
            return Optional.of(node);
        }
        return Optional.empty();
    }

    private TransformationNode getOrCreateInternal(ResolvedArtifactSet.LocalArtifactSet localArtifacts, List<Equivalence.Wrapper<TransformationStep>> transformationChain, ExecutionGraphDependenciesResolver dependenciesResolver) {
        ArtifactTransformKey key = new ArtifactTransformKey(localArtifacts.getId(), transformationChain);
        TransformationNode transformationNode = this.transformations.get(key);
        if (transformationNode == null) {
            if (transformationChain.size() == 1) {
                transformationNode = TransformationNode.initial((TransformationStep)transformationChain.get(0).get(), localArtifacts, dependenciesResolver, this.buildOperationExecutor, this.transformListener);
            } else {
                TransformationNode previous = this.getOrCreateInternal(localArtifacts, transformationChain.subList(0, transformationChain.size() - 1), dependenciesResolver);
                transformationNode = TransformationNode.chained((TransformationStep)transformationChain.get(transformationChain.size() - 1).get(), previous, dependenciesResolver, this.buildOperationExecutor, this.transformListener);
            }
            this.transformations.put(key, transformationNode);
        }
        return transformationNode;
    }

    private static List<Equivalence.Wrapper<TransformationStep>> unpackTransformation(Transformation transformation) {
        ImmutableList.Builder builder = ImmutableList.builder();
        transformation.visitTransformationSteps(transformation1 -> builder.add((Object)TransformationStep.FOR_SCHEDULING.wrap(transformation1)));
        return builder.build();
    }

    private static class ArtifactTransformKey {
        private final Object artifactSetId;
        private final List<Equivalence.Wrapper<TransformationStep>> transformations;

        private ArtifactTransformKey(Object artifactSetId, List<Equivalence.Wrapper<TransformationStep>> transformations) {
            this.artifactSetId = artifactSetId;
            this.transformations = transformations;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArtifactTransformKey that = (ArtifactTransformKey)o;
            if (!this.artifactSetId.equals(that.artifactSetId)) {
                return false;
            }
            return this.transformations.equals(that.transformations);
        }

        public int hashCode() {
            int result = this.artifactSetId.hashCode();
            result = 31 * result + this.transformations.hashCode();
            return result;
        }
    }
}

