/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.verification.signatures;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPObjectFactory;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPublicKey;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPUtil;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

class PublicKeySerializer
extends AbstractSerializer<PGPPublicKey> {
    PublicKeySerializer() {
    }

    @Override
    public PGPPublicKey read(Decoder decoder) throws Exception {
        byte[] encoded = decoder.readBinary();
        PGPObjectFactory objectFactory = new PGPObjectFactory(PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(encoded)), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        Object object = objectFactory.nextObject();
        if (object instanceof PGPPublicKey) {
            return (PGPPublicKey)object;
        }
        if (object instanceof PGPPublicKeyRing) {
            return ((PGPPublicKeyRing)object).getPublicKey();
        }
        throw new IllegalStateException("Unexpected key in cache: " + object.getClass());
    }

    @Override
    public void write(Encoder encoder, PGPPublicKey key) throws Exception {
        encoder.writeBinary(key.getEncoded());
    }
}

