/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import org.gradle.api.internal.changedetection.state.RegularFileHasher;
import org.gradle.api.internal.changedetection.state.ResourceSnapshotterCacheService;
import org.gradle.cache.GlobalCacheLocations;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.RegularFileSnapshot;

public class SplitResourceSnapshotterCacheService
implements ResourceSnapshotterCacheService {
    private final ResourceSnapshotterCacheService globalCache;
    private final ResourceSnapshotterCacheService localCache;
    private final GlobalCacheLocations globalCacheLocations;

    public SplitResourceSnapshotterCacheService(ResourceSnapshotterCacheService globalCache, ResourceSnapshotterCacheService localCache, GlobalCacheLocations globalCacheLocations) {
        this.globalCache = globalCache;
        this.localCache = localCache;
        this.globalCacheLocations = globalCacheLocations;
    }

    @Override
    public HashCode hashFile(RegularFileSnapshot fileSnapshot, RegularFileHasher hasher, HashCode configurationHash) {
        if (this.globalCacheLocations.isInsideGlobalCache(fileSnapshot.getAbsolutePath())) {
            return this.globalCache.hashFile(fileSnapshot, hasher, configurationHash);
        }
        return this.localCache.hashFile(fileSnapshot, hasher, configurationHash);
    }
}

