/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.metadata;

import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.collect.BiMap;
import org.gradle.internal.impldep.com.google.common.collect.HashBiMap;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.logging.text.TreeFormatter;

@NotThreadSafe
class InvalidPublicationChecker {
    private static final DocumentationRegistry DOCUMENTATION_REGISTRY = new DocumentationRegistry();
    private final String publicationName;
    private final BiMap<String, VariantIdentity> variants = HashBiMap.create();
    private List<String> errors;
    private boolean publicationHasVersion = false;
    private boolean publicationHasDependencyOrConstraint = false;

    public InvalidPublicationChecker(String publicationName) {
        this.publicationName = publicationName;
    }

    public void registerVariant(String name, AttributeContainer attributes, Set<? extends Capability> capabilities) {
        if (attributes.isEmpty()) {
            this.failWith("Variant '" + name + "' must declare at least one attribute.");
        }
        if (this.variants.containsKey((Object)name)) {
            this.failWith("It is invalid to have multiple variants with the same name ('" + name + "')");
        } else {
            VariantIdentity identity = new VariantIdentity(attributes, capabilities);
            if (this.variants.containsValue((Object)identity)) {
                String found = (String)this.variants.inverse().get((Object)identity);
                this.failWith("Variants '" + found + "' and '" + name + "' have the same attributes and capabilities. Please make sure either attributes or capabilities are different.");
            } else {
                this.variants.put((Object)name, (Object)identity);
            }
        }
    }

    private void checkVariantDependencyVersions() {
        if (this.publicationHasDependencyOrConstraint && !this.publicationHasVersion) {
            this.failWith("Publication only contains dependencies and/or constraints without a version. You need to add minimal version information, publish resolved versions (" + DOCUMENTATION_REGISTRY.getDocumentationFor("publishing_maven", "publishing_maven:resolved_dependencies") + ") or reference a platform (" + DOCUMENTATION_REGISTRY.getDocumentationFor("platforms") + ")");
        }
    }

    public void validate() {
        if (this.variants.isEmpty()) {
            this.failWith("This publication must publish at least one variant");
        }
        this.checkVariantDependencyVersions();
        if (this.errors != null) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Invalid publication '" + this.publicationName + "'");
            formatter.startChildren();
            for (String error : this.errors) {
                formatter.node(error);
            }
            formatter.endChildren();
            throw new InvalidUserCodeException(formatter.toString());
        }
    }

    private void failWith(String message2) {
        if (this.errors == null) {
            this.errors = Lists.newArrayList();
        }
        this.errors.add(message2);
    }

    public void sawVersion() {
        this.publicationHasVersion = true;
    }

    public void sawDependencyOrConstraint() {
        this.publicationHasDependencyOrConstraint = true;
    }

    private static final class VariantIdentity {
        private final AttributeContainer attributes;
        private final Set<? extends Capability> capabilities;

        private VariantIdentity(AttributeContainer attributes, Set<? extends Capability> capabilities) {
            this.attributes = attributes;
            this.capabilities = capabilities;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VariantIdentity that = (VariantIdentity)o;
            return Objects.equal((Object)this.attributes, (Object)that.attributes) && Objects.equal(this.capabilities, that.capabilities);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.attributes, this.capabilities});
        }
    }
}

