/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker.child;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.JavaVersion;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.io.StreamByteBuffer;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;
import org.gradle.internal.process.ArgWriter;
import org.gradle.internal.remote.Address;
import org.gradle.internal.remote.internal.inet.MultiChoiceAddress;
import org.gradle.internal.remote.internal.inet.MultiChoiceAddressSerializer;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.OutputStreamBackedEncoder;
import org.gradle.internal.stream.EncodedStream;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.worker.GradleWorkerMain;
import org.gradle.process.internal.worker.WorkerProcessBuilder;
import org.gradle.process.internal.worker.child.BootstrapSecurityManager;
import org.gradle.process.internal.worker.child.WorkerImplementationFactory;
import org.gradle.util.GUtil;

public class ApplicationClassesInSystemClassLoaderWorkerImplementationFactory
implements WorkerImplementationFactory {
    private final ClassPathRegistry classPathRegistry;
    private final TemporaryFileProvider temporaryFileProvider;
    private final JvmVersionDetector jvmVersionDetector;
    private final File gradleUserHomeDir;

    public ApplicationClassesInSystemClassLoaderWorkerImplementationFactory(ClassPathRegistry classPathRegistry, TemporaryFileProvider temporaryFileProvider, JvmVersionDetector jvmVersionDetector, File gradleUserHomeDir) {
        this.classPathRegistry = classPathRegistry;
        this.temporaryFileProvider = temporaryFileProvider;
        this.jvmVersionDetector = jvmVersionDetector;
        this.gradleUserHomeDir = gradleUserHomeDir;
    }

    @Override
    public void prepareJavaCommand(long workerId, String displayName, WorkerProcessBuilder processBuilder, List<URL> implementationClassPath, List<URL> implementationModulePath, Address serverAddress, JavaExecHandleBuilder execSpec, boolean publishProcessInfo) {
        Set<File> applicationClasspath = processBuilder.getApplicationClasspath();
        Set<File> applicationModulePath = processBuilder.getApplicationModulePath();
        LogLevel logLevel = processBuilder.getLogLevel();
        Set<String> sharedPackages = processBuilder.getSharedPackages();
        Object requestedSecurityManager = execSpec.getSystemProperties().get("java.security.manager");
        List<File> workerMainClassPath = this.classPathRegistry.getClassPath("WORKER_MAIN").getAsFiles();
        execSpec.getMainModule().set("gradle.worker");
        execSpec.getMainClass().set("worker." + GradleWorkerMain.class.getName());
        boolean useOptionsFile = this.shouldUseOptionsFile(execSpec);
        if (useOptionsFile) {
            File optionsFile = this.temporaryFileProvider.createTemporaryFile("gradle-worker-classpath", "txt", new String[0]);
            List<String> jvmArgs = this.writeOptionsFile((Boolean)execSpec.getModularity().getInferModulePath().get(), workerMainClassPath, implementationModulePath, applicationClasspath, applicationModulePath, optionsFile);
            execSpec.jvmArgs(jvmArgs);
        } else {
            execSpec.classpath(workerMainClassPath);
            execSpec.systemProperty("java.security.manager", "worker." + BootstrapSecurityManager.class.getName());
        }
        StreamByteBuffer buffer = new StreamByteBuffer();
        try {
            DataOutputStream outstr = new DataOutputStream(new EncodedStream.EncodedOutput(buffer.getOutputStream()));
            if (!useOptionsFile) {
                outstr.writeInt(applicationClasspath.size());
                for (File file : applicationClasspath) {
                    outstr.writeUTF(file.getAbsolutePath());
                }
                outstr.writeUTF(requestedSecurityManager == null ? "" : requestedSecurityManager.toString());
            }
            outstr.writeInt(sharedPackages.size());
            for (String str : sharedPackages) {
                outstr.writeUTF(str);
            }
            if (((Boolean)execSpec.getModularity().getInferModulePath().get()).booleanValue() || implementationModulePath == null) {
                outstr.writeInt(implementationClassPath.size());
                for (URL entry : implementationClassPath) {
                    outstr.writeUTF(entry.toString());
                }
            } else {
                outstr.writeInt(implementationClassPath.size() + implementationModulePath.size());
                for (URL entry : implementationClassPath) {
                    outstr.writeUTF(entry.toString());
                }
                for (URL entry : implementationModulePath) {
                    outstr.writeUTF(entry.toString());
                }
            }
            OutputStreamBackedEncoder encoder = new OutputStreamBackedEncoder(outstr);
            encoder.writeSmallInt(logLevel.ordinal());
            encoder.writeBoolean(publishProcessInfo);
            encoder.writeString(this.gradleUserHomeDir.getAbsolutePath());
            new MultiChoiceAddressSerializer().write((Encoder)encoder, (MultiChoiceAddress)serverAddress);
            encoder.writeSmallLong(workerId);
            encoder.writeString(displayName);
            byte[] serializedWorker = GUtil.serialize(processBuilder.getWorker());
            encoder.writeBinary(serializedWorker);
            encoder.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        execSpec.setStandardInput(buffer.getInputStream());
    }

    private boolean shouldUseOptionsFile(JavaExecHandleBuilder execSpec) {
        JavaVersion executableVersion = this.jvmVersionDetector.getJavaVersion(execSpec.getExecutable());
        return executableVersion != null && executableVersion.isJava9Compatible();
    }

    private List<String> writeOptionsFile(boolean runAsModule, Collection<File> workerMainClassPath, Collection<URL> implementationModulePath, Collection<File> applicationClasspath, Set<File> applicationModulePath, File optionsFile) {
        ArrayList<File> classpath = new ArrayList<File>();
        ArrayList<File> modulePath = new ArrayList<File>();
        if (runAsModule) {
            modulePath.addAll(workerMainClassPath);
        } else {
            classpath.addAll(workerMainClassPath);
        }
        modulePath.addAll(applicationModulePath);
        classpath.addAll(applicationClasspath);
        if (!modulePath.isEmpty() && implementationModulePath != null && !implementationModulePath.isEmpty()) {
            modulePath.addAll(implementationModulePath.stream().map(url -> {
                try {
                    return new File(url.toURI());
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList()));
        }
        ArrayList<String> argumentList = new ArrayList<String>();
        if (!modulePath.isEmpty()) {
            argumentList.addAll(Arrays.asList("--module-path", Joiner.on((String)File.pathSeparator).join(modulePath), "--add-modules", "ALL-MODULE-PATH"));
        }
        if (!classpath.isEmpty()) {
            argumentList.addAll(Arrays.asList("-cp", Joiner.on((String)File.pathSeparator).join(classpath)));
        }
        return ArgWriter.argsFileGenerator(optionsFile, ArgWriter.javaStyleFactory()).transform(argumentList);
    }
}

