/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.inspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JUnitImplicitUsageProvider
implements ImplicitUsageProvider {
    private static final String MOCK = "org.mockito.Mock";
    private static final String ENUM_SOURCE = "org.junit.jupiter.params.provider.EnumSource";
    private static final List<String> INJECTED_FIELD_ANNOTATIONS = Arrays.asList("org.mockito.Mock", "org.mockito.Spy", "org.mockito.Captor", "org.mockito.InjectMocks");

    public boolean isImplicitUsage(@NotNull PsiElement element) {
        if (element == null) {
            JUnitImplicitUsageProvider.$$$reportNull$$$0(0);
        }
        return JUnitImplicitUsageProvider.isReferencedInsideEnumSourceAnnotation(element);
    }

    private static boolean isReferencedInsideEnumSourceAnnotation(@NotNull PsiElement element) {
        if (element == null) {
            JUnitImplicitUsageProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiEnumConstant) {
            PsiSearchHelper searchHelper;
            PsiSearchHelper.SearchCostResult cheapEnough;
            String className;
            PsiClass psiClass = ((PsiEnumConstant)element).getContainingClass();
            String string = className = psiClass != null ? psiClass.getName() : null;
            if (className == null) {
                return false;
            }
            SearchScope useScope = psiClass.getUseScope();
            if (!(useScope instanceof LocalSearchScope || (cheapEnough = (searchHelper = PsiSearchHelper.getInstance((Project)psiClass.getProject())).isCheapEnoughToSearch(className, (GlobalSearchScope)useScope, null, null)) != PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES && cheapEnough != PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES)) {
                return false;
            }
            return ReferencesSearch.search((PsiElement)psiClass, (SearchScope)useScope, (boolean)false).anyMatch(reference -> {
                String annotationName;
                PsiElement referenceElement = reference.getElement();
                PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)referenceElement, PsiAnnotation.class);
                return annotation != null && ENUM_SOURCE.equals(annotationName = annotation.getQualifiedName()) && annotation.getAttributes().size() == 1;
            });
        }
        return false;
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        if (element == null) {
            JUnitImplicitUsageProvider.$$$reportNull$$$0(2);
        }
        return false;
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            JUnitImplicitUsageProvider.$$$reportNull$$$0(3);
        }
        return element instanceof PsiParameter && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiParameter)element), (String)MOCK, (int)0) || element instanceof PsiField && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiField)element), INJECTED_FIELD_ANNOTATIONS, (int)0);
    }

    public boolean isImplicitlyNotNullInitialized(@NotNull PsiElement element) {
        if (element == null) {
            JUnitImplicitUsageProvider.$$$reportNull$$$0(4);
        }
        return this.isImplicitWrite(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/execution/junit2/inspection/JUnitImplicitUsageProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitUsage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isReferencedInsideEnumSourceAnnotation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitRead";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitWrite";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitlyNotNullInitialized";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

