/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;

class NestingDepthVisitor
extends GroovyRecursiveElementVisitor {
    private int m_maximumDepth = 0;
    private int m_currentDepth = 0;

    NestingDepthVisitor() {
    }

    @Override
    public void visitBlockStatement(@NotNull GrBlockStatement statement) {
        PsiElement parent2;
        boolean isAlreadyCounted;
        if (statement == null) {
            NestingDepthVisitor.$$$reportNull$$$0(0);
        }
        boolean bl = isAlreadyCounted = (parent2 = statement.getParent()) instanceof GrWhileStatement || parent2 instanceof GrForStatement || parent2 instanceof GrIfStatement;
        if (!isAlreadyCounted) {
            this.enterScope();
        }
        super.visitBlockStatement(statement);
        if (!isAlreadyCounted) {
            this.exitScope();
        }
    }

    @Override
    public void visitForStatement(@NotNull GrForStatement statement) {
        if (statement == null) {
            NestingDepthVisitor.$$$reportNull$$$0(1);
        }
        this.enterScope();
        super.visitForStatement(statement);
        this.exitScope();
    }

    @Override
    public void visitIfStatement(@NotNull GrIfStatement statement) {
        if (statement == null) {
            NestingDepthVisitor.$$$reportNull$$$0(2);
        }
        boolean isAlreadyCounted = false;
        if (statement.getParent() instanceof GrIfStatement) {
            GrIfStatement parent2 = (GrIfStatement)statement.getParent();
            assert (parent2 != null);
            GrStatement elseBranch = parent2.getElseBranch();
            if (statement.equals(elseBranch)) {
                isAlreadyCounted = true;
            }
        }
        if (!isAlreadyCounted) {
            this.enterScope();
        }
        super.visitIfStatement(statement);
        if (!isAlreadyCounted) {
            this.exitScope();
        }
    }

    @Override
    public void visitTryStatement(@NotNull GrTryCatchStatement statement) {
        if (statement == null) {
            NestingDepthVisitor.$$$reportNull$$$0(3);
        }
        this.enterScope();
        super.visitTryStatement(statement);
        this.exitScope();
    }

    @Override
    public void visitSwitchStatement(@NotNull GrSwitchStatement statement) {
        if (statement == null) {
            NestingDepthVisitor.$$$reportNull$$$0(4);
        }
        this.enterScope();
        super.visitSwitchStatement(statement);
        this.exitScope();
    }

    @Override
    public void visitWhileStatement(@NotNull GrWhileStatement statement) {
        if (statement == null) {
            NestingDepthVisitor.$$$reportNull$$$0(5);
        }
        this.enterScope();
        super.visitWhileStatement(statement);
        this.exitScope();
    }

    private void enterScope() {
        ++this.m_currentDepth;
        this.m_maximumDepth = Math.max(this.m_maximumDepth, this.m_currentDepth);
    }

    private void exitScope() {
        --this.m_currentDepth;
    }

    public int getMaximumDepth() {
        return this.m_maximumDepth;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "statement";
        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/metrics/NestingDepthVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBlockStatement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitForStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitIfStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTryStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSwitchStatement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitWhileStatement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

